/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.state;

import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class InfoLineHoneyLevel
extends InfoLine {
    private static final String HONEY_KEY = "minihud.info_line.honey_level";

    public InfoLineHoneyLevel(InfoToggle type) {
        super(type);
    }

    public InfoLineHoneyLevel() {
        this(InfoToggle.HONEY_LEVEL);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasBlockState() && ctx.state() != null) {
            return this.parseBlockState(ctx.world(), ctx.state());
        }
        return null;
    }

    @Override
    public List<InfoLine.Entry> parseBlockState(@Nonnull Level world, @Nonnull BlockState state) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (state.getBlock() instanceof BeehiveBlock) {
            list.add(this.translate(HONEY_KEY, BeehiveBlockEntity.getHoneyLevel((BlockState)state)));
        }
        return list;
    }
}

