/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.te;

import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.commons.lang3.tuple.Pair;

public class InfoLineBeeCount
extends InfoLine {
    private static final String BEES_KEY = "minihud.info_line.bee_count";

    public InfoLineBeeCount(InfoToggle type) {
        super(type);
    }

    public InfoLineBeeCount() {
        this(InfoToggle.BEE_COUNT);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasNbt()) {
            BlockEntityType beType = NbtBlockUtils.getBlockEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (beType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), beType, ctx.nbt());
        }
        return ctx.be() != null ? this.parseBlockEnt(ctx.world(), ctx.be()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@Nonnull Level world, @Nonnull BlockEntityType<?> beType, @Nonnull CompoundTag nbt) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (beType.equals((Object)BlockEntityType.BEEHIVE)) {
            Pair bees = NbtBlockUtils.getBeesDataFromNbt((CompoundTag)nbt);
            if (((BlockPos)bees.getRight()).equals((Object)BlockPos.ZERO)) {
                list.add(this.translate(BEES_KEY, ((List)bees.getLeft()).size()));
            } else {
                list.add(this.translate("minihud.info_line.bee_count.flower_pos", ((List)bees.getLeft()).size(), ((BlockPos)bees.getRight()).toShortString()));
            }
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseBlockEnt(@Nonnull Level world, @Nonnull BlockEntity be) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (be instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity bbe = (BeehiveBlockEntity)be;
            list.add(this.translate(BEES_KEY, bbe.getOccupantCount()));
        }
        return list;
    }
}

