/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.te;

import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ComparatorBlockEntity;

public class InfoLineComparator
extends InfoLine {
    private static final String COMPARATOR_KEY = "minihud.info_line.comparator_output_signal";

    public InfoLineComparator(InfoToggle type) {
        super(type);
    }

    public InfoLineComparator() {
        this(InfoToggle.COMPARATOR_OUTPUT);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasNbt()) {
            BlockEntityType beType = NbtBlockUtils.getBlockEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (beType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), beType, ctx.nbt());
        }
        return ctx.be() != null ? this.parseBlockEnt(ctx.world(), ctx.be()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@Nonnull Level world, @Nonnull BlockEntityType<?> beType, @Nonnull CompoundTag nbt) {
        int output;
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (beType.equals((Object)BlockEntityType.COMPARATOR) && (output = NbtBlockUtils.getOutputSignalFromNbt((CompoundTag)nbt)) > 0) {
            list.add(this.translate(COMPARATOR_KEY, output));
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseBlockEnt(@Nonnull Level world, @Nonnull BlockEntity be) {
        ComparatorBlockEntity cbe;
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (be instanceof ComparatorBlockEntity && (cbe = (ComparatorBlockEntity)be).getOutputSignal() > 0) {
            list.add(this.translate(COMPARATOR_KEY, cbe.getOutputSignal()));
        }
        return list;
    }
}

