/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.world;

import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineChunkCache;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class InfoLineDifficulty
extends InfoLine {
    private static final String DIFF_KEY = "minihud.info_line.difficulty";

    public InfoLineDifficulty(InfoToggle type) {
        super(type);
    }

    public InfoLineDifficulty() {
        this(InfoToggle.DIFFICULTY);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (this.getClientWorld() == null || ctx.pos() == null) {
            return null;
        }
        return this.parseBlockPos(ctx.world() == null ? this.getClientWorld() : ctx.world(), ctx.pos());
    }

    @Override
    public List<InfoLine.Entry> parseBlockPos(@Nonnull Level world, @Nonnull BlockPos pos) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        long chunkInhabitedTime = 0L;
        float moonPhaseFactor = 0.0f;
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk serverChunk = InfoLineChunkCache.INSTANCE.getChunk(chunkPos);
        if (serverChunk != null) {
            moonPhaseFactor = world.getMoonBrightness();
            chunkInhabitedTime = serverChunk.getInhabitedTime();
        }
        DifficultyInstance diff = new DifficultyInstance(world.getDifficulty(), world.getDayTime(), chunkInhabitedTime, moonPhaseFactor);
        list.add(this.translate(DIFF_KEY, Float.valueOf(diff.getEffectiveDifficulty()), Float.valueOf(diff.getSpecialMultiplier()), world.getDayTime() / 24000L));
        return list;
    }
}

