/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.mixin.block;

import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BeaconBlockEntity.class})
public abstract class MixinBeaconBlockEntity
extends BlockEntity {
    @Shadow
    int levels;
    @Unique
    private int levelPre = -1;

    private MixinBeaconBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"setRemoved()V"}, at={@At(value="RETURN")})
    private void minihud_onRemoved(CallbackInfo ci) {
        OverlayRendererBeaconRange.INSTANCE.onBlockStatusChange(this.getBlockPos());
    }

    @Inject(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getGameTime()J")})
    private static void minihud_onUpdateSegmentsPre(Level world, BlockPos pos, BlockState state, BeaconBlockEntity blockEntity, CallbackInfo ci) {
        if (((MixinBeaconBlockEntity)blockEntity).levelPre != -1 && ((MixinBeaconBlockEntity)blockEntity).levelPre != ((MixinBeaconBlockEntity)blockEntity).levels) {
            ((MixinBeaconBlockEntity)blockEntity).levelPre = ((MixinBeaconBlockEntity)blockEntity).levels;
        }
    }

    @Inject(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;)V"}, at={@At(value="FIELD", opcode=181, shift=At.Shift.AFTER, target="Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;levels:I", ordinal=0)})
    private static void minihud_onUpdateSegmentsPost(Level world, BlockPos pos, BlockState state, BeaconBlockEntity blockEntity, CallbackInfo ci) {
        int newLevel = ((MixinBeaconBlockEntity)blockEntity).levels;
        if (((MixinBeaconBlockEntity)blockEntity).levelPre != newLevel) {
            OverlayRendererBeaconRange.INSTANCE.onBlockStatusChange(pos);
            ((MixinBeaconBlockEntity)blockEntity).levelPre = newLevel;
        }
    }

    @Inject(method={"updateBase(Lnet/minecraft/world/level/Level;III)I"}, at={@At(value="RETURN")})
    private static void minihud_onUpdateLevel(Level world, int x, int y, int z, CallbackInfoReturnable<Integer> cir) {
        BlockPos pos = new BlockPos(x, y, z);
        OverlayRendererBeaconRange.INSTANCE.onBlockStatusChange(pos);
    }
}

