/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.mixin.block;

import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.util.ConduitExtra;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ConduitBlockEntity.class})
public abstract class MixinConduitBlockEntity
implements ConduitExtra {
    @Shadow
    @Final
    private List<BlockPos> effectBlocks;
    @Unique
    private int minihud_activatingBlockCount;

    @Override
    public int minihud$getCurrentActivatingBlockCount() {
        return this.effectBlocks.size();
    }

    @Override
    public int minihud$getStoredActivatingBlockCount() {
        return this.minihud_activatingBlockCount;
    }

    @Override
    public void minihud$setActivatingBlockCount(int count) {
        this.minihud_activatingBlockCount = count;
    }

    @Inject(method={"clientTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/ConduitBlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/ConduitBlockEntity;updateHunting(Lnet/minecraft/world/level/block/entity/ConduitBlockEntity;Ljava/util/List;)V")})
    private static void minihud_postActiveBlockScan(Level world, BlockPos pos, BlockState state, ConduitBlockEntity blockEntity, CallbackInfo ci) {
        int countBefore;
        int count;
        if (RendererToggle.OVERLAY_CONDUIT_RANGE.getBooleanValue() && (count = ((ConduitExtra)blockEntity).minihud$getCurrentActivatingBlockCount()) != (countBefore = ((ConduitExtra)blockEntity).minihud$getStoredActivatingBlockCount())) {
            OverlayRendererConduitRange.INSTANCE.onBlockStatusChange(pos);
            ((ConduitExtra)blockEntity).minihud$setActivatingBlockCount(count);
        }
    }
}

