/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.mixin.network;

import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.mixin.world.IMixinChunkDeltaUpdateS2CPacket;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.NotificationUtils;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class MixinClientPlayNetworkHandler {
    @Inject(method={"handleBlockUpdate(Lnet/minecraft/network/protocol/game/ClientboundBlockUpdatePacket;)V"}, at={@At(value="RETURN")})
    private void minihud_markChunkChangedBlockChange(ClientboundBlockUpdatePacket packet, CallbackInfo ci) {
        NotificationUtils.onBlockChange(packet.getPos(), packet.getBlockState());
    }

    @Inject(method={"handleLevelChunkWithLight(Lnet/minecraft/network/protocol/game/ClientboundLevelChunkWithLightPacket;)V"}, at={@At(value="RETURN")})
    private void minihud_markChunkChangedFullChunk(ClientboundLevelChunkWithLightPacket packet, CallbackInfo ci) {
        NotificationUtils.onChunkData(packet.getX(), packet.getZ(), packet.getChunkData());
    }

    @Inject(method={"handleChunkBlocksUpdate(Lnet/minecraft/network/protocol/game/ClientboundSectionBlocksUpdatePacket;)V"}, at={@At(value="RETURN")})
    private void minihud_markChunkChangedMultiBlockChange(ClientboundSectionBlocksUpdatePacket packet, CallbackInfo ci) {
        SectionPos pos = ((IMixinChunkDeltaUpdateS2CPacket)packet).minihud_getChunkSectionPos();
        NotificationUtils.onMultiBlockChange(pos, packet);
    }

    @Inject(method={"handleSystemChat(Lnet/minecraft/network/protocol/game/ClientboundSystemChatPacket;)V"}, at={@At(value="RETURN")})
    private void minihud_onGameMessage(ClientboundSystemChatPacket packet, CallbackInfo ci) {
        DataStorage.getInstance().onChatMessage(packet.content());
    }

    @Inject(method={"handleTabListCustomisation(Lnet/minecraft/network/protocol/game/ClientboundTabListPacket;)V"}, at={@At(value="RETURN")})
    private void minihud_onHandlePlayerListHeaderFooter(ClientboundTabListPacket packetIn, CallbackInfo ci) {
        DataStorage.getInstance().handleCarpetServerTPSData(packetIn.footer());
        DataStorage.getInstance().getMobCapData().parsePlayerListFooterMobCapData(packetIn.footer());
    }

    @Inject(method={"handleSetTime(Lnet/minecraft/network/protocol/game/ClientboundSetTimePacket;)V"}, at={@At(value="RETURN")})
    private void minihud_onTimeUpdate(ClientboundSetTimePacket packetIn, CallbackInfo ci) {
    }

    @Inject(method={"handleSetSpawn(Lnet/minecraft/network/protocol/game/ClientboundSetDefaultSpawnPositionPacket;)V"}, at={@At(value="RETURN")})
    private void minihud_onSetSpawn(ClientboundSetDefaultSpawnPositionPacket packet, CallbackInfo ci) {
        HudDataManager.getInstance().setWorldSpawn(packet.respawnData().globalPos());
    }

    @Inject(method={"handleLogin(Lnet/minecraft/network/protocol/game/ClientboundLoginPacket;)V"}, at={@At(value="RETURN")})
    private void minihud_onPostGameJoin(ClientboundLoginPacket packet, CallbackInfo ci) {
        DataStorage.getInstance().setSimulationDistance(packet.simulationDistance());
    }

    @Inject(method={"handleTagQueryPacket(Lnet/minecraft/network/protocol/game/ClientboundTagQueryPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/DebugQueryHandler;handleResponse(ILnet/minecraft/nbt/CompoundTag;)Z")})
    private void minihud_onQueryResponse(ClientboundTagQueryPacket packet, CallbackInfo ci) {
        if (Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            EntitiesDataManager.getInstance().handleVanillaQueryNbt(packet.getTransactionId(), packet.getTag());
        }
    }

    @Inject(method={"handleCommands(Lnet/minecraft/network/protocol/game/ClientboundCommandsPacket;)V"}, at={@At(value="RETURN")})
    private void minihud_onCommandTree(CallbackInfo ci) {
        if (Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
            EntitiesDataManager.getInstance().resetOpCheck();
        }
    }
}

