/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.network.ServuxHudHandler;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class ServuxHudPacket
implements IClientPayloadData {
    private Type packetType;
    private CompoundTag nbt;
    private FriendlyByteBuf buffer;
    public static final int PROTOCOL_VERSION = 2;

    private ServuxHudPacket(Type type) {
        this.packetType = type;
        this.nbt = new CompoundTag();
        this.clearPacket();
    }

    public static ServuxHudPacket MetadataRequest(@Nullable CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_C2S_METADATA_REQUEST);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket MetadataResponse(@Nullable CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_METADATA);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket SpawnRequest(@Nullable CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_C2S_SPAWN_DATA_REQUEST);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket SpawnResponse(@Nullable CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_SPAWN_DATA);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket DataLoggerRequest(@Nullable CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_C2S_DATA_LOGGER_REQUEST);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket DataLoggerTick(@Nullable CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_DATA_LOGGER_TICK);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket WeatherTick(@Nullable CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_WEATHER_TICK);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket RecipeManagerRequest(@Nullable CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_C2S_RECIPE_MANAGER_REQUEST);
        if (nbt != null) {
            packet.nbt.merge(nbt);
        }
        return packet;
    }

    public static ServuxHudPacket ResponseS2CStart(@Nonnull CompoundTag nbt) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_NBT_RESPONSE_START);
        packet.nbt.merge(nbt);
        return packet;
    }

    public static ServuxHudPacket ResponseS2CData(@Nonnull FriendlyByteBuf buffer) {
        ServuxHudPacket packet = new ServuxHudPacket(Type.PACKET_S2C_NBT_RESPONSE_DATA);
        packet.buffer = new FriendlyByteBuf(buffer.copy());
        packet.nbt = new CompoundTag();
        return packet;
    }

    private void clearPacket() {
        if (this.buffer != null) {
            this.buffer.clear();
            this.buffer = new FriendlyByteBuf(Unpooled.buffer());
        }
    }

    public int getVersion() {
        return 2;
    }

    public int getPacketType() {
        return this.packetType.get();
    }

    public int getTotalSize() {
        int total = 2;
        if (this.nbt != null && !this.nbt.isEmpty()) {
            total += this.nbt.sizeInBytes();
        }
        if (this.buffer != null) {
            total += this.buffer.readableBytes();
        }
        return total;
    }

    public Type getType() {
        return this.packetType;
    }

    public CompoundTag getCompound() {
        return this.nbt;
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    public boolean hasBuffer() {
        return this.buffer != null && this.buffer.isReadable();
    }

    public boolean hasNbt() {
        return this.nbt != null && !this.nbt.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasBuffer() && !this.hasNbt();
    }

    public void toPacket(FriendlyByteBuf output) {
        output.writeVarInt(this.packetType.get());
        switch (this.packetType.ordinal()) {
            case 9: {
                try {
                    output.writeBytes(this.buffer.copy());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#toPacket: error writing buffer data to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                try {
                    output.writeNbt((Tag)this.nbt);
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#toPacket: error writing NBT to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                MiniHUD.LOGGER.error("ServuxHudPacket#toPacket: Unknown packet type!");
            }
        }
    }

    @Nullable
    public static ServuxHudPacket fromPacket(FriendlyByteBuf input) {
        int i = input.readVarInt();
        Type type = ServuxHudPacket.getType(i);
        if (type == null) {
            MiniHUD.LOGGER.warn("ServuxHudPacket#fromPacket: invalid packet type received");
            return null;
        }
        switch (type.ordinal()) {
            case 9: {
                try {
                    return ServuxHudPacket.ResponseS2CData(new FriendlyByteBuf(input.readBytes(input.readableBytes())));
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading S2C Bulk Response Buffer from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 1: {
                try {
                    return ServuxHudPacket.MetadataRequest(input.readNbt());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading Metadata Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 0: {
                try {
                    return ServuxHudPacket.MetadataResponse(input.readNbt());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading Metadata Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 3: {
                try {
                    return ServuxHudPacket.SpawnRequest(input.readNbt());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading Spawn Data Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 2: {
                try {
                    return ServuxHudPacket.SpawnResponse(input.readNbt());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading Spawn Data Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 7: {
                try {
                    return ServuxHudPacket.DataLoggerRequest(input.readNbt());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading Data Logger Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 6: {
                try {
                    return ServuxHudPacket.DataLoggerTick(input.readNbt());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading Data Logger Tick from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 4: {
                try {
                    return ServuxHudPacket.WeatherTick(input.readNbt());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading Weather Tick from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 5: {
                try {
                    return ServuxHudPacket.RecipeManagerRequest(input.readNbt());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: error reading Recipe Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            default: {
                MiniHUD.LOGGER.error("ServuxHudPacket#fromPacket: Unknown packet type!");
            }
        }
        return null;
    }

    public void clear() {
        if (this.nbt != null && !this.nbt.isEmpty()) {
            this.nbt = new CompoundTag();
        }
        this.clearPacket();
        this.packetType = null;
    }

    @Nullable
    public static Type getType(int input) {
        for (Type type : Type.values()) {
            if (type.get() != input) continue;
            return type;
        }
        return null;
    }

    public static enum Type {
        PACKET_S2C_METADATA(1),
        PACKET_C2S_METADATA_REQUEST(2),
        PACKET_S2C_SPAWN_DATA(3),
        PACKET_C2S_SPAWN_DATA_REQUEST(4),
        PACKET_S2C_WEATHER_TICK(5),
        PACKET_C2S_RECIPE_MANAGER_REQUEST(6),
        PACKET_S2C_DATA_LOGGER_TICK(7),
        PACKET_C2S_DATA_LOGGER_REQUEST(8),
        PACKET_S2C_NBT_RESPONSE_START(10),
        PACKET_S2C_NBT_RESPONSE_DATA(11);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        int get() {
            return this.type;
        }
    }

    public record Payload(ServuxHudPacket data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Payload> ID = new CustomPacketPayload.Type(ServuxHudHandler.CHANNEL_ID);
        public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = CustomPacketPayload.codec(Payload::write, Payload::new);

        public Payload(FriendlyByteBuf input) {
            this(ServuxHudPacket.fromPacket(input));
        }

        private void write(FriendlyByteBuf output) {
            this.data.toPacket(output);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}

