/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.network.PacketSplitter;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.network.ServuxStructuresPacket;
import fi.dy.masa.minihud.util.DataStorage;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public abstract class ServuxStructuresHandler<T extends CustomPacketPayload>
implements IPluginClientPlayHandler<T> {
    private static final ServuxStructuresHandler<ServuxStructuresPacket.Payload> INSTANCE = new ServuxStructuresHandler<ServuxStructuresPacket.Payload>(){

        public void receive(ServuxStructuresPacket.Payload payload, ClientPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final ResourceLocation CHANNEL_ID = ResourceLocation.fromNamespaceAndPath((String)"servux", (String)"structures");
    private boolean servuxRegistered;
    private boolean payloadRegistered = false;
    private int failures = 0;
    private static final int MAX_FAILURES = 4;
    private long readingSessionKey = -1L;

    public static ServuxStructuresHandler<ServuxStructuresPacket.Payload> getInstance() {
        return INSTANCE;
    }

    public ResourceLocation getPayloadChannel() {
        return CHANNEL_ID;
    }

    public boolean isPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    public void setPlayRegistered(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    public void decodeStructuresPacket(ResourceLocation channel, ServuxStructuresPacket packet) {
        if (!channel.equals((Object)CHANNEL_ID) || packet == null) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_S2C_STRUCTURE_DATA: {
                FriendlyByteBuf fullPacket;
                if (this.readingSessionKey == -1L) {
                    this.readingSessionKey = RandomSource.create((long)Util.getMillis()).nextLong();
                }
                if ((fullPacket = PacketSplitter.receive((IPluginClientPlayHandler)this, (long)this.readingSessionKey, (FriendlyByteBuf)packet.getBuffer())) == null) break;
                try {
                    CompoundTag nbt = (CompoundTag)fullPacket.readNbt(NbtAccounter.unlimitedHeap());
                    this.readingSessionKey = -1L;
                    if (nbt != null) {
                        ListTag structures = nbt.getListOrEmpty("Structures");
                        DataStorage.getInstance().addOrUpdateStructuresFromServer(structures, this.servuxRegistered);
                        break;
                    }
                    MiniHUD.LOGGER.warn("decodeStructuresPacket(): Structures Data: error reading fullBuffer NBT is NULL");
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("decodeStructuresPacket(): Structures Data: error reading fullBuffer [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case PACKET_S2C_METADATA: {
                if (!DataStorage.getInstance().receiveServuxStrucutresMetadata(packet.getCompound())) break;
                this.servuxRegistered = true;
                break;
            }
            case PACKET_S2C_SPAWN_METADATA: {
                if (HudDataManager.getInstance().hasServuxServer()) break;
                HudDataManager.getInstance().receiveSpawnMetadata(packet.getCompound());
                break;
            }
            case PACKET_S2C_WEATHER_DATA: {
                if (HudDataManager.getInstance().hasServuxServer()) break;
                HudDataManager.getInstance().receiveWeatherData(packet.getCompound());
                break;
            }
            default: {
                MiniHUD.LOGGER.warn("decodeStructuresPacket(): received unhandled packetType {} of size {} bytes.", (Object)packet.getPacketType(), (Object)packet.getTotalSize());
            }
        }
    }

    public void reset(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.servuxRegistered) {
            this.servuxRegistered = false;
            this.failures = 0;
            this.readingSessionKey = -1L;
        }
    }

    public void resetFailures(ResourceLocation channel) {
        if (channel.equals((Object)CHANNEL_ID) && this.failures > 0) {
            this.failures = 0;
        }
    }

    public void receivePlayPayload(T payload, ClientPlayNetworking.Context ctx) {
        if (payload.type().id().equals((Object)CHANNEL_ID)) {
            INSTANCE.decodeStructuresPacket(CHANNEL_ID, ((ServuxStructuresPacket.Payload)payload).data());
        }
    }

    public void encodeWithSplitter(FriendlyByteBuf buffer, ClientPacketListener handler) {
    }

    public void encodeStructuresPacket(ServuxStructuresPacket packet) {
        if (!INSTANCE.sendPlayPayload(new ServuxStructuresPacket.Payload(packet))) {
            if (this.failures > 4) {
                MiniHUD.debugLog("encodeStructuresPacket(): encountered [{}] sendPayload failures, cancelling any Servux join attempt(s)", 4);
                this.servuxRegistered = false;
                INSTANCE.unregisterPlayReceiver();
                DataStorage.getInstance().onPacketFailure();
            } else {
                ++this.failures;
            }
        }
    }
}

