/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.network.ServuxStructuresHandler;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class ServuxStructuresPacket
implements IClientPayloadData {
    private Type packetType;
    private CompoundTag nbt;
    private FriendlyByteBuf buffer;
    public static final int PROTOCOL_VERSION = 2;

    public ServuxStructuresPacket(Type type, @Nullable CompoundTag nbt) {
        this.packetType = type;
        if (nbt != null && !nbt.isEmpty()) {
            this.nbt = new CompoundTag();
            this.nbt.merge(nbt);
        }
        if (this.buffer != null) {
            this.buffer.clear();
            this.buffer = new FriendlyByteBuf(Unpooled.buffer());
        }
    }

    public ServuxStructuresPacket(Type type, @Nonnull FriendlyByteBuf packet) {
        this.packetType = type;
        this.nbt = new CompoundTag();
        this.buffer = new FriendlyByteBuf(packet.copy());
    }

    public int getVersion() {
        return 2;
    }

    public int getPacketType() {
        return this.packetType.get();
    }

    public int getTotalSize() {
        int total = 2;
        if (this.nbt != null && !this.nbt.isEmpty()) {
            total += this.nbt.sizeInBytes();
        }
        if (this.buffer != null) {
            total += this.buffer.readableBytes();
        }
        return total;
    }

    public Type getType() {
        return this.packetType;
    }

    public CompoundTag getCompound() {
        return this.nbt;
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    public boolean hasBuffer() {
        return this.buffer != null && this.buffer.isReadable();
    }

    public boolean hasNbt() {
        return this.nbt != null && !this.nbt.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasBuffer() && !this.hasNbt();
    }

    public void toPacket(FriendlyByteBuf output) {
        output.writeVarInt(this.getPacketType());
        if (this.packetType.equals((Object)Type.PACKET_S2C_STRUCTURE_DATA)) {
            try {
                output.writeBytes(this.buffer.copy());
            }
            catch (Exception e) {
                MiniHUD.LOGGER.error("ServuxStructuresPacket#toPacket: error writing data to packet: [{}]", (Object)e.getLocalizedMessage());
            }
        } else {
            try {
                output.writeNbt((Tag)this.nbt);
            }
            catch (Exception e) {
                MiniHUD.LOGGER.error("ServuxStructuresPacket#toPacket: error writing NBT to packet: [{}]", (Object)e.getLocalizedMessage());
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static ServuxStructuresPacket fromPacket(FriendlyByteBuf input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clear() {
        if (this.nbt != null && !this.nbt.isEmpty()) {
            this.nbt = new CompoundTag();
        }
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.buffer.clear();
            this.buffer = new FriendlyByteBuf(Unpooled.buffer());
        }
        this.packetType = null;
    }

    @Nullable
    public static Type getType(int input) {
        for (Type type : Type.values()) {
            if (type.get() != input) continue;
            return type;
        }
        return null;
    }

    public static enum Type {
        PACKET_S2C_METADATA(1),
        PACKET_S2C_STRUCTURE_DATA(2),
        PACKET_C2S_STRUCTURES_REGISTER(3),
        PACKET_C2S_STRUCTURES_UNREGISTER(4),
        PACKET_S2C_STRUCTURE_DATA_START(5),
        PACKET_S2C_SPAWN_METADATA(10),
        PACKET_C2S_REQUEST_SPAWN_METADATA(11),
        PACKET_S2C_WEATHER_DATA(12);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        int get() {
            return this.type;
        }
    }

    public record Payload(ServuxStructuresPacket data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Payload> ID = new CustomPacketPayload.Type(ServuxStructuresHandler.CHANNEL_ID);
        public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = CustomPacketPayload.codec(Payload::write, Payload::new);

        public Payload(FriendlyByteBuf input) {
            this(ServuxStructuresPacket.fromPacket(input));
        }

        private void write(FriendlyByteBuf output) {
            this.data.toPacket(output);
        }

        public CustomPacketPayload.Type<Payload> type() {
            return ID;
        }
    }
}

