/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;

public abstract class BaseBlockRangeOverlay<T extends BlockEntity>
extends OverlayRendererBase {
    protected final IConfigBoolean renderToggleConfig;
    protected final LongOpenHashSet blockPositions;
    protected final BlockEntityType<T> blockEntityType;
    protected final Class<T> blockEntityClass;
    protected Level world;
    protected boolean needsUpdate;
    protected boolean hasData;
    protected int updateDistance = 48;

    protected BaseBlockRangeOverlay(IConfigBoolean renderToggleConfig, BlockEntityType<T> blockEntityType, Class<T> blockEntityClass) {
        this.renderToggleConfig = renderToggleConfig;
        this.blockEntityType = blockEntityType;
        this.blockEntityClass = blockEntityClass;
        this.blockPositions = new LongOpenHashSet();
        this.world = null;
        this.hasData = false;
    }

    public void setNeedsUpdate() {
        if (!this.renderToggleConfig.getBooleanValue()) {
            this.clear();
            return;
        }
        this.needsUpdate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBlockStatusChange(BlockPos pos) {
        if (this.renderToggleConfig.getBooleanValue()) {
            LongOpenHashSet longOpenHashSet = this.blockPositions;
            synchronized (longOpenHashSet) {
                this.blockPositions.add(pos.asLong());
                this.needsUpdate = true;
            }
        }
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return this.renderToggleConfig.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity cameraEntity, Minecraft mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(cameraEntity.getX() - (double)this.lastUpdatePos.getX()) > (double)this.updateDistance || Math.abs(cameraEntity.getZ() - (double)this.lastUpdatePos.getZ()) > (double)this.updateDistance || Math.abs(cameraEntity.getY() - (double)this.lastUpdatePos.getY()) > (double)this.updateDistance;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null) {
            return;
        }
        this.hasData = this.fetchAllTargetBlockEntityPositions(mc.level, entity.blockPosition(), mc);
        this.world = entity.level();
        if (this.hasData()) {
            this.updateBlockRanges(this.world, cameraPos, mc, profiler);
            this.render(cameraPos, mc, profiler);
        }
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.blockPositions.isEmpty();
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.renderBlockRange(this.world, cameraPos, mc, profiler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        LongOpenHashSet longOpenHashSet = this.blockPositions;
        synchronized (longOpenHashSet) {
            this.blockPositions.clear();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.resetBlockRange();
        this.clear();
        this.hasData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fetchAllTargetBlockEntityPositions(ClientLevel world, BlockPos centerPos, Minecraft mc) {
        ClientChunkCache chunkManager = world.getChunkSource();
        int centerCX = centerPos.getX() >> 4;
        int centerCZ = centerPos.getZ() >> 4;
        int chunkRadius = (Integer)mc.options.renderDistance().get();
        this.blockPositions.clear();
        for (int cz = centerCZ - chunkRadius; cz <= centerCZ + chunkRadius; ++cz) {
            for (int cx = centerCX - chunkRadius; cx <= centerCX + chunkRadius; ++cx) {
                LevelChunk chunk = chunkManager.getChunk(cx, cz, ChunkStatus.FULL, false);
                if (chunk == null) continue;
                for (BlockEntity be : chunk.getBlockEntities().values()) {
                    if (be.getType() != this.blockEntityType) continue;
                    LongOpenHashSet longOpenHashSet = this.blockPositions;
                    synchronized (longOpenHashSet) {
                        this.blockPositions.add(be.getBlockPos().asLong());
                        this.hasData = true;
                    }
                }
            }
        }
        return !this.blockPositions.isEmpty() && this.blockPositions.size() > 0;
    }

    protected void updateBlockRanges(Level world, Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        LongIterator it = this.blockPositions.iterator();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        double max = ((Integer)mc.options.renderDistance().get() + 2) * 16;
        max *= max;
        profiler.push("render_block_ranges");
        while (it.hasNext()) {
            mutablePos.set(it.nextLong());
            BlockEntity be = world.getBlockEntity((BlockPos)mutablePos);
            if (be == null || !this.blockEntityClass.isAssignableFrom(be.getClass())) {
                it.remove();
                continue;
            }
            double distSq = (cameraPos.x - (double)mutablePos.getX()) * (cameraPos.x - (double)mutablePos.getX()) + (cameraPos.z - (double)mutablePos.getZ()) * (cameraPos.z - (double)mutablePos.getZ());
            if (distSq > max) continue;
            BlockEntity castBe = (BlockEntity)this.blockEntityClass.cast(be);
            this.updateBlockRange(world, mutablePos.immutable(), castBe, cameraPos, mc, profiler);
        }
        profiler.pop();
    }

    protected abstract void updateBlockRange(Level var1, BlockPos var2, T var3, Vec3 var4, Minecraft var5, ProfilerFiller var6);

    protected abstract void renderBlockRange(Level var1, Vec3 var2, Minecraft var3, ProfilerFiller var4);

    protected abstract void resetBlockRange();
}

