/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.interfaces.IInventoryOverlayHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.mixin.entity.IMixinPiglinEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.RayTraceUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class InventoryOverlayHandler
implements IInventoryOverlayHandler {
    private static final InventoryOverlayHandler INSTANCE = new InventoryOverlayHandler();
    private InventoryOverlay.Context context = null;
    private Refresher refresher = null;
    private IDataSyncer syncer = null;
    private Pair<BlockPos, InventoryOverlay.Context> lastBlockEntityContext = null;
    private Pair<Integer, InventoryOverlay.Context> lastEntityContext = null;

    public static InventoryOverlayHandler getInstance() {
        return INSTANCE;
    }

    public String getModId() {
        return "minihud";
    }

    public IDataSyncer getDataSyncer() {
        if (this.syncer == null) {
            this.syncer = EntitiesDataManager.getInstance();
        }
        return this.syncer;
    }

    public void setDataSyncer(IDataSyncer syncer) {
        this.syncer = syncer;
    }

    public InventoryOverlay.Refresher getRefreshHandler() {
        if (this.refresher == null) {
            this.refresher = new Refresher();
        }
        return this.refresher;
    }

    public boolean isEmpty() {
        return this.context == null;
    }

    @Nullable
    public InventoryOverlay.Context getRenderContextNullable() {
        return this.context;
    }

    @Nullable
    public InventoryOverlay.Context getRenderContext(GuiGraphics drawContext, ProfilerFiller profiler, Minecraft mc) {
        profiler.push(this.getClass().getName() + "_inventory_overlay");
        this.getTargetInventory(mc);
        if (!this.isEmpty()) {
            this.renderInventoryOverlay(drawContext, this.getRenderContextNullable(), mc, Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue(), Configs.Generic.INVENTORY_PREVIEW_VILLAGER_BG_COLOR.getBooleanValue());
        }
        profiler.pop();
        return this.getRenderContextNullable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public InventoryOverlay.Context getTargetInventory(Minecraft mc) {
        Player serverPlayer;
        Level world = WorldUtils.getBestWorld((Minecraft)mc);
        Entity cameraEntity = EntityUtils.getCameraEntity();
        this.context = null;
        if (mc.player == null || world == null || mc.level == null) {
            return null;
        }
        if (cameraEntity == mc.player && world instanceof ServerLevel && (serverPlayer = world.getPlayerByUUID(mc.player.getUUID())) != null) {
            cameraEntity = serverPlayer;
        }
        if (cameraEntity == null) {
            return null;
        }
        HitResult trace = cameraEntity != mc.player ? RayTraceUtils.getRayTraceFromEntity((Level)mc.level, (Entity)cameraEntity, (ClipContext.Fluid)ClipContext.Fluid.NONE) : mc.hitResult;
        CompoundTag nbt = new CompoundTag();
        if (trace == null || trace.getType() == HitResult.Type.MISS) {
            return null;
        }
        if (trace.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)trace).getBlockPos();
            BlockState state = world.getBlockState(pos);
            Block blockTmp = state.getBlock();
            BlockEntity be = null;
            if (!(blockTmp instanceof EntityBlock)) return null;
            if (world instanceof ServerLevel) {
                be = world.getChunkAt(pos).getBlockEntity(pos);
                if (be != null) {
                    nbt = be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
                }
            } else {
                Pair pair = this.requestBlockEntityAt(world, pos);
                if (pair != null) {
                    nbt = (CompoundTag)pair.getRight();
                    be = (BlockEntity)pair.getLeft();
                }
            }
            InventoryOverlay.Context ctx = this.getTargetInventoryFromBlock(world, pos, be, nbt);
            if (this.lastBlockEntityContext != null && !((BlockPos)this.lastBlockEntityContext.getLeft()).equals((Object)pos)) {
                this.lastBlockEntityContext = null;
            }
            if (ctx != null && ctx.inv() != null) {
                this.lastBlockEntityContext = Pair.of((Object)pos, (Object)ctx);
                this.context = ctx;
                return this.context;
            }
            if (this.lastBlockEntityContext == null || !((BlockPos)this.lastBlockEntityContext.getLeft()).equals((Object)pos)) return null;
            this.context = (InventoryOverlay.Context)this.lastBlockEntityContext.getRight();
            return this.context;
        }
        if (trace.getType() != HitResult.Type.ENTITY) return null;
        Entity entity = ((EntityHitResult)trace).getEntity();
        if (world instanceof ServerLevel) {
            if ((entity = world.getEntity(entity.getId())) == null) return null;
            nbt = NbtEntityUtils.invokeEntityNbtDataNoPassengers((Entity)entity, (int)entity.getId());
        } else {
            Pair pair = this.getDataSyncer().requestEntity(world, entity.getId());
            if (pair != null) {
                nbt = (CompoundTag)pair.getRight();
                entity = (Entity)pair.getLeft();
            }
        }
        InventoryOverlay.Context ctx = this.getTargetInventoryFromEntity(world.getEntity(entity.getId()), nbt);
        if (this.lastEntityContext != null && ((Integer)this.lastEntityContext.getLeft()).intValue() != entity.getId()) {
            this.lastEntityContext = null;
        }
        if (ctx != null && ctx.inv() != null && !ctx.inv().isEmpty()) {
            this.lastEntityContext = Pair.of((Object)entity.getId(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (ctx != null && ctx.inv() != null && ctx.inv().isEmpty() && ctx.nbt() != null && ctx.nbt().contains("Offers")) {
            this.lastEntityContext = Pair.of((Object)entity.getId(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (ctx != null && ctx.inv() == null && (ctx.type() == InventoryOverlay.InventoryRenderType.WOLF || ctx.type() == InventoryOverlay.InventoryRenderType.VILLAGER || ctx.type() == InventoryOverlay.InventoryRenderType.HORSE || ctx.type() == InventoryOverlay.InventoryRenderType.PLAYER || ctx.type() == InventoryOverlay.InventoryRenderType.ARMOR_STAND || ctx.type() == InventoryOverlay.InventoryRenderType.LIVING_ENTITY)) {
            this.lastEntityContext = Pair.of((Object)entity.getId(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (this.lastEntityContext != null && ((Integer)this.lastEntityContext.getLeft()).intValue() == entity.getId() && ctx != null && ctx.inv() != null && ctx.inv().isEmpty() && (ctx.type() == InventoryOverlay.InventoryRenderType.VILLAGER || ctx.type() == InventoryOverlay.InventoryRenderType.HORSE || ctx.type() == InventoryOverlay.InventoryRenderType.PLAYER)) {
            this.context = (InventoryOverlay.Context)this.lastEntityContext.getRight();
            return this.context;
        }
        if (this.lastEntityContext == null || ((Integer)this.lastEntityContext.getLeft()).intValue() != entity.getId()) return null;
        this.context = (InventoryOverlay.Context)this.lastEntityContext.getRight();
        return this.context;
    }

    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromBlock(Level world, BlockPos pos, @Nullable BlockEntity be, CompoundTag nbt) {
        Player player;
        BlockEntityType beType;
        Container inv;
        if (world == null) {
            return null;
        }
        if (be != null) {
            if (nbt.isEmpty()) {
                nbt = be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
            }
            inv = InventoryUtils.getInventory((Level)world, (BlockPos)pos);
        } else {
            Pair pair;
            if (nbt.isEmpty() && (pair = this.requestBlockEntityAt(world, pos)) != null) {
                nbt = (CompoundTag)pair.getRight();
                be = (BlockEntity)pair.getLeft();
            }
            inv = this.getDataSyncer().getBlockInventory(world, pos, false);
        }
        BlockEntityType blockEntityType = beType = nbt != null ? NbtBlockUtils.getBlockEntityTypeFromNbt((CompoundTag)nbt) : null;
        if ((beType != null && beType.equals(BlockEntityType.ENDER_CHEST) || be instanceof EnderChestBlockEntity) && Minecraft.getInstance().player != null && (player = world.getPlayerByUUID(Minecraft.getInstance().player.getUUID())) != null) {
            Pair enderPair = this.getDataSyncer().requestEntity(world, player.getId());
            PlayerEnderChestContainer enderItems = null;
            if (enderPair != null && enderPair.getRight() != null && ((CompoundTag)enderPair.getRight()).contains("EnderItems")) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromNbt((CompoundTag)((CompoundTag)enderPair.getRight()), (RegistryAccess)world.registryAccess());
            } else if (world instanceof ServerLevel) {
                enderItems = player.getEnderChestInventory();
            }
            if (enderItems != null) {
                inv = enderItems;
            }
        }
        if (nbt != null && !nbt.isEmpty()) {
            Container inv2 = InventoryUtils.getNbtInventory((CompoundTag)nbt, (int)(inv != null ? inv.getContainerSize() : -1), (RegistryAccess)world.registryAccess());
            if (inv == null) {
                inv = inv2;
            }
        }
        if (inv == null || nbt == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(InventoryOverlay.getBestInventoryType((Container)inv, (CompoundTag)nbt), inv, be != null ? be : world.getBlockEntity(pos), null, nbt, this.getRefreshHandler());
        return this.context;
    }

    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromEntity(Entity entity, CompoundTag nbt) {
        Container inv = null;
        LivingEntity entityLivingBase = null;
        if (entity instanceof LivingEntity) {
            entityLivingBase = (LivingEntity)entity;
        }
        if (entity instanceof Container) {
            inv = (Container)entity;
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            inv = new SimpleContainer((ItemStack[])player.getInventory().getNonEquipmentItems().toArray((Object[])new ItemStack[36]));
        } else if (entity instanceof Villager) {
            inv = ((Villager)entity).getInventory();
        } else if (entity instanceof AbstractHorse) {
            inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
        } else if (entity instanceof Piglin) {
            inv = ((IMixinPiglinEntity)entity).malilib_getInventory();
        }
        if (!nbt.isEmpty()) {
            Container inv2;
            if (inv != null && nbt.contains("Items") && nbt.getListOrEmpty("Items").size() > 1) {
                inv2 = entity instanceof AbstractHorse ? InventoryUtils.getNbtInventoryHorseFix((CompoundTag)nbt, (int)inv.getContainerSize(), (RegistryAccess)entity.registryAccess()) : InventoryUtils.getNbtInventory((CompoundTag)nbt, (int)inv.getContainerSize(), (RegistryAccess)entity.registryAccess());
                inv = null;
            } else if (inv != null && nbt.contains("equipment") && nbt.contains("EatingHaystack")) {
                inv2 = InventoryUtils.getNbtInventoryHorseFix((CompoundTag)nbt, (int)inv.getContainerSize(), (RegistryAccess)entity.registryAccess());
                inv = null;
            } else if (inv != null && inv.getContainerSize() == 8 && nbt.contains("Inventory") && !nbt.getListOrEmpty("Inventory").isEmpty()) {
                inv2 = InventoryUtils.getNbtInventory((CompoundTag)nbt, (int)8, (RegistryAccess)entity.registryAccess());
                inv = null;
            } else {
                inv2 = InventoryUtils.getNbtInventory((CompoundTag)nbt, (int)(inv != null ? inv.getContainerSize() : -1), (RegistryAccess)entity.registryAccess());
                if (inv2 != null) {
                    inv = null;
                }
            }
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(inv != null ? InventoryOverlay.getBestInventoryType((Container)inv, (CompoundTag)nbt) : InventoryOverlay.getInventoryType((CompoundTag)nbt), inv, null, entityLivingBase, nbt, this.getRefreshHandler());
        return this.context;
    }

    private static void dumpContext(InventoryOverlay.Context ctx) {
        System.out.print("Context Dump --> ");
        if (ctx == null) {
            System.out.print("NULL!\n");
            return;
        }
        System.out.printf("\nTYPE: [%s]\n", ctx.type().name());
        System.out.printf("BE  : [%s]\n", ctx.be() != null ? BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)ctx.be().getType()) : "<NULL>");
        System.out.printf("ENT : [%s]\n", ctx.entity() != null ? BuiltInRegistries.ENTITY_TYPE.getKey((Object)ctx.entity().getType()) : "<NULL>");
        System.out.printf("INV : [%s]\n", ctx.inv() != null ? "size: " + ctx.inv().getContainerSize() + "/ empty: " + ctx.inv().isEmpty() : "<NULL>");
        System.out.printf("NBT : [%s]\n", ctx.nbt() != null ? ctx.nbt().toString() : "<NULL>");
        System.out.print("--> EOF\n");
    }

    public static class Refresher
    implements InventoryOverlay.Refresher {
        public InventoryOverlay.Context onContextRefresh(InventoryOverlay.Context data, Level world) {
            if (data.be() != null) {
                InventoryOverlayHandler.getInstance().requestBlockEntityAt(world, data.be().getBlockPos());
                data = InventoryOverlayHandler.getInstance().getTargetInventoryFromBlock(data.be().getLevel(), data.be().getBlockPos(), data.be(), data.nbt());
            } else if (data.entity() != null) {
                InventoryOverlayHandler.getInstance().getDataSyncer().requestEntity(world, data.entity().getId());
                data = InventoryOverlayHandler.getInstance().getTargetInventoryFromEntity((Entity)data.entity(), data.nbt());
            }
            return data;
        }
    }
}

