/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public abstract class OverlayRendererBase
implements IOverlayRenderer {
    protected final List<RenderObjectVbo> renderObjects = new ArrayList<RenderObjectVbo>();
    protected boolean renderThrough = false;
    protected boolean useCulling = false;
    protected float glLineWidth = 1.0f;
    @Nullable
    protected BlockPos lastUpdatePos = BlockPos.ZERO;
    private Vec3 updateCameraPos = Vec3.ZERO;
    protected boolean shouldResort = false;

    protected void clearBuffers() {
        if (!this.renderObjects.isEmpty()) {
            this.resetBuffers();
            this.renderObjects.clear();
        }
    }

    protected void allocateBuffers() {
        this.allocateBuffers(true);
    }

    protected void allocateBuffers(boolean useOutlines) {
        this.clearBuffers();
        this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + "/Quads", MaLiLibPipelines.MINIHUD_SHAPE_OFFSET));
        if (useOutlines) {
            this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + "/Outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH));
        }
    }

    protected void resetBuffers() {
        this.renderObjects.forEach(RenderObjectVbo::reset);
    }

    @Override
    public final Vec3 getUpdatePosition() {
        return this.updateCameraPos;
    }

    @Override
    public final void setUpdatePosition(Vec3 cameraPosition) {
        this.updateCameraPos = cameraPosition;
    }

    protected int getTopYOverTerrain(Level world, BlockPos pos, int range) {
        int minX = pos.getX() - range;
        int minZ = pos.getZ() - range;
        int maxX = pos.getX() + range;
        int maxZ = pos.getZ() + range;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        int maxY = 0;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                LevelChunk chunk = world.getChunk(cx, cz);
                int height = WorldUtils.getHighestSectionYOffset((ChunkAccess)chunk) + 15;
                if (height <= maxY) continue;
                maxY = height;
            }
        }
        return maxY + 4;
    }

    @Override
    public void draw(Vec3 cameraPos) {
        for (RenderObjectVbo obj : this.renderObjects) {
            if (!obj.isStarted() || !obj.isUploaded()) continue;
            if (this.shouldResort && obj.shouldResort()) {
                obj.resortTranslucent(obj.createVertexSorter(cameraPos));
            }
            if (obj.getDrawMode() == VertexFormat.Mode.LINES || obj.getDrawMode() == VertexFormat.Mode.DEBUG_LINES) {
                obj.lineWidth(this.glLineWidth);
                obj.drawPost(null, false, true);
                continue;
            }
            obj.drawPost(null, false, false);
        }
    }

    @Override
    public void reset() {
        this.resetBuffers();
        this.glLineWidth = 1.0f;
        this.lastUpdatePos = BlockPos.ZERO;
        this.updateCameraPos = Vec3.ZERO;
    }

    public void setRenderThrough(boolean renderThrough) {
        this.renderThrough = renderThrough;
    }

    public String getSaveId() {
        return "";
    }

    @Nullable
    public JsonObject toJson() {
        return null;
    }

    public void fromJson(JsonObject obj) {
    }
}

