/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.block.IMixinBeaconBlockEntity;
import fi.dy.masa.minihud.renderer.BaseBlockRangeOverlay;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererBeaconRange
extends BaseBlockRangeOverlay<BeaconBlockEntity> {
    public static final OverlayRendererBeaconRange INSTANCE = new OverlayRendererBeaconRange();
    private final HashMap<BlockPos, Integer> positions;

    public OverlayRendererBeaconRange() {
        super((IConfigBoolean)RendererToggle.OVERLAY_BEACON_RANGE, BlockEntityType.BEACON, BeaconBlockEntity.class);
        this.useCulling = false;
        this.positions = new HashMap();
    }

    @Override
    public String getName() {
        return "BeaconRange";
    }

    @Override
    protected void updateBlockRange(Level world, BlockPos pos, BeaconBlockEntity be, Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        List<BeaconBeamOwner.Section> segments = ((IMixinBeaconBlockEntity)be).minihud_getBeamEmitter();
        Holder<MobEffect> primary = ((IMixinBeaconBlockEntity)be).minihud_getPrimary();
        int level = ((IMixinBeaconBlockEntity)be).minihud_getLevel();
        if (segments.isEmpty() || level == 0) {
            this.positions.remove(pos);
        } else if (level >= 1 && level <= 4 && primary != null) {
            this.positions.put(pos, level);
        } else {
            this.positions.remove(pos);
        }
    }

    @Override
    protected void renderBlockRange(Level world, Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.renderThrough = false;
        if (!this.positions.isEmpty()) {
            this.allocateBuffers(true);
            this.renderQuads(world, cameraPos, mc, profiler);
            this.renderOutlines(world, cameraPos, mc, profiler);
        } else {
            this.clearBuffers();
        }
    }

    @Override
    protected void resetBlockRange() {
        this.positions.clear();
    }

    private void renderQuads(Level world, Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        double camX = cameraPos.x;
        double camY = cameraPos.y;
        double camZ = cameraPos.z;
        profiler.push("beacon_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:beacon/quads", this.renderThrough ? MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL : MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1);
        this.positions.forEach((pos, level) -> {
            double x = (double)pos.getX() - camX;
            double y = (double)pos.getY() - camY;
            double z = (double)pos.getZ() - camZ;
            Color4f color = OverlayRendererBeaconRange.getColorForLevel(level);
            int range = level * 10 + 10;
            double minX = x - (double)range;
            double minY = y - (double)range;
            double minZ = z - (double)range;
            double maxX = x + (double)range + 1.0;
            double maxY = this.getTopYOverTerrain(world, (BlockPos)pos, range);
            double maxZ = z + (double)range + 1.0;
            RenderUtils.drawBoxAllSidesBatchedQuads((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)color, (BufferBuilder)builder);
        });
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererBeaconRange#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    private void renderOutlines(Level world, Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        double camX = cameraPos.x;
        double camY = cameraPos.y;
        double camZ = cameraPos.z;
        profiler.push("beacon_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:beacon/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        this.positions.forEach((pos, level) -> {
            double x = (double)pos.getX() - camX;
            double y = (double)pos.getY() - camY;
            double z = (double)pos.getZ() - camZ;
            Color4f color = OverlayRendererBeaconRange.getColorForLevel(level);
            int range = level * 10 + 10;
            double minX = x - (double)range;
            double minY = y - (double)range;
            double minZ = z - (double)range;
            double maxX = x + (double)range + 1.0;
            double maxY = this.getTopYOverTerrain(world, (BlockPos)pos, range);
            double maxZ = z + (double)range + 1.0;
            RenderUtils.drawBoxAllEdgesBatchedLines((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)Color4f.fromColor((int)color.intValue, (float)1.0f), (BufferBuilder)builder);
        });
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererBeaconRange#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    public static Color4f getColorForLevel(int level) {
        return switch (level) {
            case 1 -> Configs.Colors.BEACON_RANGE_LVL1_OVERLAY_COLOR.getColor();
            case 2 -> Configs.Colors.BEACON_RANGE_LVL2_OVERLAY_COLOR.getColor();
            case 3 -> Configs.Colors.BEACON_RANGE_LVL3_OVERLAY_COLOR.getColor();
            default -> Configs.Colors.BEACON_RANGE_LVL4_OVERLAY_COLOR.getColor();
        };
    }
}

