/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.SubChunkPos;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererBiomeBorders
extends OverlayRendererBase {
    public static final OverlayRendererBiomeBorders INSTANCE = new OverlayRendererBiomeBorders();
    private final Object2ObjectOpenHashMap<SubChunkPos, List<ColoredQuad>> quads = new Object2ObjectOpenHashMap();
    private final Object2IntOpenHashMap<Biome> biomeMapping = new Object2IntOpenHashMap();
    private final Int2ObjectOpenHashMap<Color4f> biomeColorsMap = new Int2ObjectOpenHashMap();
    private final ObjectOpenHashSet<SubChunkPos> scheduledChunks = new ObjectOpenHashSet();
    private final Color4f fixedColor = Color4f.fromColor((int)0x30F030, (float)0.25f);
    private Color4f[] biomeColorsArray = new Color4f[0];
    private IntFunction<Color4f> colorRetriever = id -> this.biomeColorsArray[id];
    private Vec3 cameraPosition = Vec3.ZERO;
    private boolean needsUpdate;
    private boolean needsRenderUpdate;
    private List<ColoredQuad> renderQuads = new ArrayList<ColoredQuad>();
    private boolean hasData = false;

    private OverlayRendererBiomeBorders() {
        this.useCulling = true;
        this.renderThrough = false;
    }

    @Override
    public String getName() {
        return "BiomeBorders";
    }

    public void setNeedsUpdate() {
        if (RendererToggle.OVERLAY_BIOME_BORDER.getBooleanValue()) {
            this.cameraPosition = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            this.needsUpdate = true;
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object2ObjectOpenHashMap<SubChunkPos, List<ColoredQuad>> object2ObjectOpenHashMap = this.quads;
        synchronized (object2ObjectOpenHashMap) {
            MiniHUD.debugLog("Clearing Biome Border Overlay data...", new Object[0]);
            this.quads.clear();
            this.scheduledChunks.clear();
            this.biomeMapping.clear();
            this.cameraPosition = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        }
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_BIOME_BORDER.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity cameraEntity, Minecraft mc) {
        int updateDistance = 16;
        return this.needsUpdate || this.needsRenderUpdate || this.lastUpdatePos == null || Math.abs(cameraEntity.getX() - (double)this.lastUpdatePos.getX()) > (double)updateDistance || Math.abs(cameraEntity.getY() - (double)this.lastUpdatePos.getY()) > (double)updateDistance || Math.abs(cameraEntity.getZ() - (double)this.lastUpdatePos.getZ()) > (double)updateDistance;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        List<SubChunkPos> chunks = this.getSubChunksWithinRange(mc.getCameraEntity(), mc);
        BlockPos cameraBlockPos = BlockPos.containing((Position)cameraPos);
        this.scheduleTasksForMissingChunks(chunks, cameraBlockPos, (Level)mc.level);
        this.renderQuads = this.getQuadsToRender(chunks);
        if (!this.renderQuads.isEmpty()) {
            this.hasData = true;
            this.render(cameraPos, mc, profiler);
        }
        this.setUpdatePosition(this.cameraPosition);
        this.needsUpdate = false;
        this.needsRenderUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.renderQuads.isEmpty();
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        double inset = 1.0E-4;
        profiler.push("biome_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:biome/quads", MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1);
        for (ColoredQuad quad : this.renderQuads) {
            Color4f color = this.getColor(quad.biomeId);
            RenderUtils.renderInsetQuad(quad.start, quad.width, quad.height, quad.side, inset, color, cameraPos, builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererBiomeBorders#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    private void renderOutlines(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        double inset = 1.0E-4;
        profiler.push("biome_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:biome/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        for (ColoredQuad quad : this.renderQuads) {
            Color4f color = this.getColor(quad.biomeId);
            RenderUtils.renderBiomeBorderLines(quad.start, quad.width, quad.height, quad.side, inset, color, cameraPos, builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererBiomeBorders#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.renderQuads.clear();
        this.hasData = false;
    }

    protected List<SubChunkPos> getSubChunksWithinRange(Entity cameraEntity, Minecraft mc) {
        if (mc.level == null) {
            return new ArrayList<SubChunkPos>();
        }
        ClientLevel world = mc.level;
        int viewDistance = Math.min(Configs.Generic.BIOME_OVERLAY_RANGE.getIntegerValue(), (Integer)mc.options.renderDistance().get());
        int viewDistanceVertical = Math.min(Configs.Generic.BIOME_OVERLAY_RANGE_VERTICAL.getIntegerValue(), (Integer)mc.options.renderDistance().get());
        int chunkX = Mth.floor((double)cameraEntity.getX()) >> 4;
        int chunkY = Mth.floor((double)cameraEntity.getY()) >> 4;
        int chunkZ = Mth.floor((double)cameraEntity.getZ()) >> 4;
        int minCY = Math.max(world.getMinY() >> 4, chunkY - viewDistanceVertical);
        int maxCY = Math.min(world.getMaxY() >> 4, chunkY + viewDistanceVertical);
        ArrayList<SubChunkPos> chunks = new ArrayList<SubChunkPos>();
        for (int cz = chunkZ - viewDistance; cz <= chunkZ + viewDistance; ++cz) {
            for (int cx = chunkX - viewDistance; cx <= chunkX + viewDistance; ++cx) {
                for (int cy = minCY; cy <= maxCY; ++cy) {
                    chunks.add(new SubChunkPos(cx, cy, cz));
                }
            }
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ColoredQuad> getQuadsToRender(List<SubChunkPos> chunks) {
        ArrayList<ColoredQuad> quads = new ArrayList<ColoredQuad>();
        Object2ObjectOpenHashMap<SubChunkPos, List<ColoredQuad>> object2ObjectOpenHashMap = this.quads;
        synchronized (object2ObjectOpenHashMap) {
            for (SubChunkPos pos : chunks) {
                List tmp = (List)this.quads.get((Object)pos);
                if (tmp == null) continue;
                quads.addAll(tmp);
            }
        }
        return quads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTasksForMissingChunks(List<SubChunkPos> chunks, BlockPos cameraBlockPos, Level world) {
        Object2ObjectOpenHashMap<SubChunkPos, List<ColoredQuad>> object2ObjectOpenHashMap = this.quads;
        synchronized (object2ObjectOpenHashMap) {
            if (this.biomeMapping.isEmpty()) {
                this.createBiomeMapping(world);
            }
            if (this.quads.size() > 32000) {
                this.quads.clear();
            }
            chunks = new ArrayList<SubChunkPos>(chunks);
            chunks.removeAll((Collection<?>)this.scheduledChunks);
            chunks.removeAll((Collection<?>)this.quads.keySet());
        }
        for (SubChunkPos pos : chunks) {
            LevelChunk chunk = (LevelChunk)world.getChunk(pos.getX(), pos.getZ(), ChunkStatus.FULL, false);
            if (chunk == null) continue;
            Runnable task = () -> {
                ArrayList<ColoredQuad> quadsOut = new ArrayList<ColoredQuad>();
                OverlayRendererBiomeBorders.readBiomesAndFindEdges(chunk, pos, quadsOut, this.biomeMapping);
                Object2ObjectOpenHashMap<SubChunkPos, List<ColoredQuad>> object2ObjectOpenHashMap = this.quads;
                synchronized (object2ObjectOpenHashMap) {
                    this.quads.put((Object)pos, quadsOut);
                    this.scheduledChunks.remove((Object)pos);
                    this.needsRenderUpdate = true;
                }
            };
            Object2ObjectOpenHashMap<SubChunkPos, List<ColoredQuad>> object2ObjectOpenHashMap2 = this.quads;
            synchronized (object2ObjectOpenHashMap2) {
                this.scheduledChunks.add((Object)pos);
            }
            DataStorage.getInstance().addTask(task, chunk.getPos(), (Vec3i)cameraBlockPos);
        }
        this.needsUpdate = false;
    }

    private static int readBiomesAndFindEdges(LevelChunk chunk, SubChunkPos subChunkPos, List<ColoredQuad> quadsOut, Object2IntOpenHashMap<Biome> biomeMapping) {
        int startX = (subChunkPos.getX() << 4) - 1;
        int startY = (subChunkPos.getY() << 4) - 1;
        int startZ = (subChunkPos.getZ() << 4) - 1;
        Biome[][][] biomes = new Biome[18][18][18];
        BiomeSource biomeSource = OverlayRendererBiomeBorders.getBiomeSourceForChunk(chunk);
        for (int y = 0; y < 18; ++y) {
            for (int z = 0; z < 18; ++z) {
                for (int x = 0; x < 18; ++x) {
                    biomes[x][y][z] = biomeSource.getBiome(startX + x, startY + y, startZ + z);
                }
            }
        }
        return OverlayRendererBiomeBorders.buildQuadsFromBiomeData(startX, startY, startZ, biomes, quadsOut, biomeMapping);
    }

    private static int buildQuadsFromBiomeData(int minX, int minY, int minZ, Biome[][][] biomes, List<ColoredQuad> quadsOut, Object2IntOpenHashMap<Biome> biomeMapping) {
        Biome biome;
        Biome lastBiome;
        int y;
        ArrayList<EdgeStrip> stripList = new ArrayList<EdgeStrip>();
        EdgeStrip[][][][] strips = new EdgeStrip[16][16][16][6];
        Direction[] sides = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP};
        int[] startPos = new int[6];
        BlockPos minCorner = new BlockPos(minX, minY, minZ);
        Direction.Axis axis = Direction.Axis.X;
        for (y = 1; y < 17; ++y) {
            for (int z = 1; z < 17; ++z) {
                Arrays.fill(startPos, -1);
                lastBiome = null;
                for (int x = 1; x < 17; ++x) {
                    biome = biomes[x][y][z];
                    OverlayRendererBiomeBorders.buildStrips(x, y, z, axis, minCorner, biome, lastBiome, startPos, biomes, sides, strips, stripList, biomeMapping);
                    lastBiome = biome;
                }
                OverlayRendererBiomeBorders.endStrips(17, y, z, axis, minCorner, lastBiome, startPos, sides, strips, stripList, biomeMapping);
            }
        }
        sides = new Direction[]{Direction.WEST, Direction.EAST};
        axis = Direction.Axis.Z;
        for (y = 1; y < 17; ++y) {
            for (int x = 1; x < 17; ++x) {
                Arrays.fill(startPos, -1);
                lastBiome = null;
                for (int z = 1; z < 17; ++z) {
                    biome = biomes[x][y][z];
                    OverlayRendererBiomeBorders.buildStrips(x, y, z, axis, minCorner, biome, lastBiome, startPos, biomes, sides, strips, stripList, biomeMapping);
                    lastBiome = biome;
                }
                OverlayRendererBiomeBorders.endStrips(x, y, 17, axis, minCorner, lastBiome, startPos, sides, strips, stripList, biomeMapping);
            }
        }
        return OverlayRendererBiomeBorders.buildStripsToQuads(strips, stripList, quadsOut);
    }

    private static void buildStrips(int x, int y, int z, Direction.Axis axis, BlockPos minCorner, Biome biome, @Nullable Biome lastBiome, int[] startPos, Biome[][][] biomes, Direction[] sides, EdgeStrip[][][][] strips, ArrayList<EdgeStrip> stripList, Object2IntOpenHashMap<Biome> biomeMapping) {
        int biomeId = -1;
        int pos = axis == Direction.Axis.X ? x : z;
        int stripX = minCorner.getX() + x;
        int stripY = minCorner.getY() + y;
        int stripZ = minCorner.getZ() + z;
        for (Direction side : sides) {
            Biome adjBiome = biomes[x + side.getStepX()][y + side.getStepY()][z + side.getStepZ()];
            int sideIndex = side.get3DDataValue();
            int stripStart = startPos[sideIndex];
            if (stripStart >= 0 && lastBiome != null && (biome != lastBiome || biome == adjBiome)) {
                EdgeStrip strip;
                if (biomeId == -1) {
                    biomeId = biomeMapping.getInt((Object)lastBiome);
                }
                if (axis == Direction.Axis.X) {
                    stripX = minCorner.getX() + stripStart;
                } else if (axis == Direction.Axis.Z) {
                    stripZ = minCorner.getZ() + stripStart;
                } else if (axis == Direction.Axis.Y) {
                    stripY = minCorner.getY() + stripStart;
                }
                long packedPos = OverlayRendererBiomeBorders.getPackedCoordinate(stripX, stripY, stripZ);
                strips[stripX & 0xF][stripY & 0xF][stripZ & 0xF][sideIndex] = strip = new EdgeStrip(packedPos, side, pos - stripStart, biomeId);
                stripList.add(strip);
                stripStart = -1;
                startPos[sideIndex] = -1;
            }
            if (biome == adjBiome || stripStart >= 0) continue;
            startPos[sideIndex] = pos;
        }
    }

    private static void endStrips(int x, int y, int z, Direction.Axis axis, BlockPos minCorner, Biome lastBiome, int[] startPos, Direction[] sides, EdgeStrip[][][][] strips, ArrayList<EdgeStrip> stripList, Object2IntOpenHashMap<Biome> biomeMapping) {
        int biomeId = -1;
        int stripX = minCorner.getX() + x;
        int stripY = minCorner.getY() + y;
        int stripZ = minCorner.getZ() + z;
        for (Direction side : sides) {
            EdgeStrip strip;
            int sideIndex = side.get3DDataValue();
            int stripStart = startPos[sideIndex];
            if (stripStart < 0) continue;
            if (biomeId == -1) {
                biomeId = biomeMapping.getInt((Object)lastBiome);
            }
            if (axis == Direction.Axis.X) {
                stripX = minCorner.getX() + stripStart;
            } else if (axis == Direction.Axis.Z) {
                stripZ = minCorner.getZ() + stripStart;
            } else if (axis == Direction.Axis.Y) {
                stripY = minCorner.getY() + stripStart;
            }
            long packedPos = OverlayRendererBiomeBorders.getPackedCoordinate(stripX, stripY, stripZ);
            strips[stripX & 0xF][stripY & 0xF][stripZ & 0xF][sideIndex] = strip = new EdgeStrip(packedPos, side, 16 - stripStart + 1, biomeId);
            stripList.add(strip);
            startPos[sideIndex] = -1;
        }
    }

    private static int buildStripsToQuads(EdgeStrip[][][][] strips, ArrayList<EdgeStrip> stripList, List<ColoredQuad> quadsOut) {
        byte[][][] handled = new byte[16][16][16];
        for (EdgeStrip strip : stripList) {
            int tmpZ;
            int tmpY;
            int tmpX;
            EdgeStrip nextStrip;
            int z;
            int y;
            Direction side = strip.side;
            int sideIndex = side.get3DDataValue();
            long startPos = strip.startPosLong;
            int x = OverlayRendererBiomeBorders.unpackX(startPos) & 0xF;
            if ((handled[x][y = OverlayRendererBiomeBorders.unpackY(startPos) & 0xF][z = OverlayRendererBiomeBorders.unpackZ(startPos) & 0xF] & 1 << sideIndex) != 0) continue;
            Direction scanDir = side.getAxis() != Direction.Axis.Y ? Direction.UP : Direction.SOUTH;
            int length = strip.length;
            int biomeId = strip.biomeId;
            int limit = 16 - (side.getAxis() != Direction.Axis.Y ? y : z);
            int count = 1;
            byte[] byArray = handled[x][y];
            int n = z;
            byArray[n] = (byte)(byArray[n] | (byte)(1 << sideIndex));
            for (int i = 1; i < limit && (nextStrip = strips[tmpX = x + scanDir.getStepX() * i][tmpY = y + scanDir.getStepY() * i][tmpZ = z + scanDir.getStepZ() * i][sideIndex]) != null && nextStrip.length == length && nextStrip.biomeId == biomeId; ++i) {
                byte[] byArray2 = handled[tmpX][tmpY];
                int n2 = tmpZ;
                byArray2[n2] = (byte)(byArray2[n2] | (byte)(1 << sideIndex));
                ++count;
            }
            quadsOut.add(OverlayRendererBiomeBorders.makeColoredQuad(startPos, length, count, side, strip.biomeId));
        }
        return quadsOut.size();
    }

    protected static ColoredQuad makeColoredQuad(long startPos, int stripLength, int stripCount, Direction side, int biomeId) {
        int x1 = OverlayRendererBiomeBorders.unpackX(startPos);
        int y1 = OverlayRendererBiomeBorders.unpackY(startPos);
        int z1 = OverlayRendererBiomeBorders.unpackZ(startPos);
        return new ColoredQuad(new Vec3i(x1, y1, z1), stripLength, stripCount, side, biomeId);
    }

    protected static int unpackX(long packedCoordinate) {
        return (int)(packedCoordinate << 40 >> 40);
    }

    protected static int unpackY(long packedCoordinate) {
        return (int)(packedCoordinate >> 48);
    }

    protected static int unpackZ(long packedCoordinate) {
        return (int)(packedCoordinate << 16 >> 40);
    }

    protected static long getPackedCoordinate(int x, int y, int z) {
        return ((long)y & 0xFFFFL) << 48 | ((long)z & 0xFFFFFFL) << 24 | (long)x & 0xFFFFFFL;
    }

    protected static long getPackedCoordinate(BlockPos.MutableBlockPos pos) {
        return OverlayRendererBiomeBorders.getPackedCoordinate(pos.getX(), pos.getY(), pos.getZ());
    }

    private void createBiomeMapping(Level world) {
        this.biomeMapping.clear();
        this.biomeColorsMap.clear();
        this.biomeColorsArray = new Color4f[0];
        if (Configs.Generic.BIOME_OVERLAY_SINGLE_COLOR.getBooleanValue()) {
            this.colorRetriever = id -> this.fixedColor;
        } else {
            Registry registry = world.registryAccess().lookupOrThrow(Registries.BIOME);
            int count = 0;
            int maxId = 0;
            for (Biome biome : registry) {
                int id2 = registry.getId((Object)biome);
                this.biomeMapping.put((Object)biome, id2);
                ++count;
                if (id2 <= maxId) continue;
                maxId = id2;
            }
            int hueInc = 360 / count;
            int hue = 0;
            if (maxId <= 65535) {
                this.biomeColorsArray = new Color4f[maxId + 1];
                this.colorRetriever = id -> this.biomeColorsArray[id];
                IntIterator intIterator = this.biomeMapping.values().iterator();
                while (intIterator.hasNext()) {
                    int id3 = (Integer)intIterator.next();
                    this.biomeColorsArray[id3] = Color4f.fromColor((int)OverlayRendererBiomeBorders.getColorFromHue(hue), (float)0.25f);
                    hue += hueInc;
                }
            } else {
                this.colorRetriever = arg_0 -> this.biomeColorsMap.get(arg_0);
                IntIterator intIterator = this.biomeMapping.values().iterator();
                while (intIterator.hasNext()) {
                    int id4 = (Integer)intIterator.next();
                    this.biomeColorsMap.put(id4, (Object)Color4f.fromColor((int)OverlayRendererBiomeBorders.getColorFromHue(hue), (float)0.25f));
                    hue += hueInc;
                }
            }
            this.addCustomColorMappings((Registry<Biome>)registry);
        }
    }

    private void addCustomColorMappings(Registry<Biome> registry) {
        ColorRegistry reg = this.biomeColorsArray.length > 0 ? (biomeId, color) -> this.assignColor(biomeId, color, (id, c) -> {
            this.biomeColorsArray[id] = c;
        }, registry) : (biomeId, color) -> this.assignColor(biomeId, color, (arg_0, arg_1) -> this.biomeColorsMap.put(arg_0, arg_1), registry);
        reg.set("minecraft:badlands", 16760896);
        reg.set("minecraft:badlands_plateau", 16760896);
        reg.set("minecraft:bamboo_jungle", 5308176);
        reg.set("minecraft:bamboo_jungle_hills", 5308176);
        reg.set("minecraft:basalt_deltas", 0x888888);
        reg.set("minecraft:beach", 15921090);
        reg.set("minecraft:birch_forest", 4576923);
        reg.set("minecraft:birch_forest_hills", 4576923);
        reg.set("minecraft:cold_ocean", 461291);
        reg.set("minecraft:crimson_forest", 16713491);
        reg.set("minecraft:dark_forest", 37633);
        reg.set("minecraft:dark_forest_hills", 7186300);
        reg.set("minecraft:deep_cold_ocean", 2498484);
        reg.set("minecraft:deep_frozen_ocean", 2058676);
        reg.set("minecraft:deep_lukewarm_ocean", 2077620);
        reg.set("minecraft:deep_ocean", 1917412);
        reg.set("minecraft:deep_warm_ocean", 1951204);
        reg.set("minecraft:desert", 15920641);
        reg.set("minecraft:desert_hills", 15906817);
        reg.set("minecraft:desert_lakes", 12644865);
        reg.set("minecraft:dripstone_caves", 11702888);
        reg.set("minecraft:end_barrens", 13815732);
        reg.set("minecraft:end_highlands", 15778102);
        reg.set("minecraft:end_midlands", 15200310);
        reg.set("minecraft:eroded_badlands", 14842025);
        reg.set("minecraft:flower_forest", 7464843);
        reg.set("minecraft:forest", 2203965);
        reg.set("minecraft:frozen_ocean", 7981036);
        reg.set("minecraft:frozen_river", 0xBDDEED);
        reg.set("minecraft:giant_spruce_taiga", 13332747);
        reg.set("minecraft:giant_spruce_taiga_hills", 12011029);
        reg.set("minecraft:giant_tree_taiga", 12754501);
        reg.set("minecraft:giant_tree_taiga_hills", 12298879);
        reg.set("minecraft:gravelly_mountains", 9670792);
        reg.set("minecraft:ice_spikes", 2423807);
        reg.set("minecraft:jungle", 7532381);
        reg.set("minecraft:jungle_edge", 4055702);
        reg.set("minecraft:jungle_hills", 2534767);
        reg.set("minecraft:lukewarm_ocean", 2284006);
        reg.set("minecraft:lush_caves", 4902471);
        reg.set("minecraft:modified_badlands_plateau", 8354593);
        reg.set("minecraft:modified_gravelly_mountains", 6786980);
        reg.set("minecraft:modified_jungle", 10479969);
        reg.set("minecraft:modified_jungle_edge", 6929443);
        reg.set("minecraft:modified_wooded_badlands_plateau", 12367395);
        reg.set("minecraft:mountain_edge", 0x818181);
        reg.set("minecraft:mountains", 0xC5C5C5);
        reg.set("minecraft:mushroom_field_shore", 15499102);
        reg.set("minecraft:mushroom_fields", 15560969);
        reg.set("minecraft:nether_wastes", 8956604);
        reg.set("minecraft:ocean", 599789);
        reg.set("minecraft:plains", 2007336);
        reg.set("minecraft:river", 2977498);
        reg.set("minecraft:savanna", 12499809);
        reg.set("minecraft:savanna_plateau", 15459379);
        reg.set("minecraft:shattered_savanna", 15447091);
        reg.set("minecraft:shattered_savanna_plateau", 11640175);
        reg.set("minecraft:small_end_islands", 12635395);
        reg.set("minecraft:snowy_beach", 14736789);
        reg.set("minecraft:snowy_mountains", 0xDDDDDD);
        reg.set("minecraft:snowy_taiga", 13234117);
        reg.set("minecraft:snowy_taiga_hills", 5222467);
        reg.set("minecraft:snowy_taiga_mountains", 10599401);
        reg.set("minecraft:snowy_tundra", 6463834);
        reg.set("minecraft:soul_sand_valley", 9392395);
        reg.set("minecraft:stone_shore", 0xABABAB);
        reg.set("minecraft:sunflower_plains", 9690905);
        reg.set("minecraft:swamp", 2594315);
        reg.set("minecraft:swamp_hills", 9032295);
        reg.set("minecraft:taiga", 157952);
        reg.set("minecraft:taiga_hills", 4217919);
        reg.set("minecraft:taiga_mountains", 7706741);
        reg.set("minecraft:tall_birch_forest", 5678173);
        reg.set("minecraft:tall_birch_hills", 8186245);
        reg.set("minecraft:the_end", 13099056);
        reg.set("minecraft:the_void", 15866099);
        reg.set("minecraft:warm_ocean", 1613556);
        reg.set("minecraft:warped_forest", 8107738);
        reg.set("minecraft:wooded_badlands_plateau", 13347389);
        reg.set("minecraft:wooded_hills", 3910704);
        reg.set("minecraft:wooded_mountains", 9943444);
    }

    private void assignColor(String biomeId, int color, ColorSetter setter, Registry<Biome> registry) {
        try {
            int id;
            Optional optional = registry.get(ResourceLocation.tryParse((String)biomeId));
            if (optional.isPresent() && (id = this.biomeMapping.getInt(((Holder.Reference)optional.get()).value())) >= 0) {
                setter.set(id, Color4f.fromColor((int)color, (float)0.25f));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Color4f getColor(int biomeId) {
        return this.colorRetriever.apply(biomeId);
    }

    public static int getColorFromHue(int hue) {
        return 0xFF000000 | Color.HSBtoRGB((float)(hue % 360) / 360.0f, 1.0f, 1.0f) & 0xFFFFFF;
    }

    private static BiomeSource getBiomeSourceForChunk(LevelChunk chunk) {
        BiomeManager biomeAccess = chunk.getLevel().getBiomeManager();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BiomeSource biomeSource = (x, y, z) -> (Biome)biomeAccess.getBiome((BlockPos)mutablePos.set(x, y, z)).value();
        return biomeSource;
    }

    protected record ColoredQuad(Vec3i start, int width, int height, Direction side, int biomeId) {
        @Override
        public String toString() {
            return "ColoredQuad{start=" + String.valueOf(this.start) + ", width=" + this.width + ", height=" + this.height + ", side=" + String.valueOf(this.side) + ", biomeId=" + this.biomeId + "}";
        }
    }

    private static interface BiomeSource {
        public Biome getBiome(int var1, int var2, int var3);
    }

    protected static class EdgeStrip {
        public final long startPosLong;
        public final Direction side;
        public final int length;
        public final int biomeId;

        public EdgeStrip(long startPosLong, Direction side, int length, int biomeId) {
            this.startPosLong = startPosLong;
            this.side = side;
            this.length = length;
            this.biomeId = biomeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdgeStrip edgeStrip = (EdgeStrip)o;
            if (this.startPosLong != edgeStrip.startPosLong) {
                return false;
            }
            return this.side == edgeStrip.side;
        }

        public int hashCode() {
            int result = (int)(this.startPosLong ^ this.startPosLong >>> 32);
            result = 31 * result + this.side.hashCode();
            return result;
        }

        public String toString() {
            return String.format("EdgeStrip{startPosLong=%08X, side=%s, length=%d, biomeId=%d}", this.startPosLong, this.side, this.length, this.biomeId);
        }
    }

    private static interface ColorRegistry {
        public void set(String var1, int var2);
    }

    private static interface ColorSetter {
        public void set(int var1, Color4f var2);
    }
}

