/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.BaseBlockRangeOverlay;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ConduitExtra;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererConduitRange
extends BaseBlockRangeOverlay<ConduitBlockEntity> {
    public static final OverlayRendererConduitRange INSTANCE = new OverlayRendererConduitRange();
    private final ShapeRenderType renderType;
    private final LayerRange layerRange;
    private final Direction.Axis quadAxis = Direction.UP.getAxis();
    private boolean combineQuads;
    private Color4f colorLines;
    private final List<Entry> conduits;

    public OverlayRendererConduitRange() {
        super((IConfigBoolean)RendererToggle.OVERLAY_CONDUIT_RANGE, BlockEntityType.CONDUIT, ConduitBlockEntity.class);
        this.renderType = ShapeRenderType.OUTER_EDGE;
        this.layerRange = new LayerRange(null);
        this.conduits = new ArrayList<Entry>();
    }

    @Override
    public String getName() {
        return "ConduitRange";
    }

    @Override
    protected void updateBlockRange(Level world, BlockPos pos, ConduitBlockEntity be, Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (!be.isActive()) {
            return;
        }
        this.colorLines = Configs.Colors.CONDUIT_RANGE_OUTLINES.getColor();
        this.combineQuads = Configs.Generic.CONDUIT_RANGE_OVERLAY_COMBINE_QUADS.getBooleanValue();
        this.renderThrough = Configs.Generic.CONDUIT_RANGE_OVERLAY_RENDER_THROUGH.getBooleanValue();
        this.addOrReplaceEntry(this.calculateEach(pos, ((ConduitExtra)be).minihud$getStoredActivatingBlockCount() / 7 * 16));
    }

    private Entry calculateEach(BlockPos pos, int range) {
        Entry entry = new Entry(pos, range);
        Consumer<BlockPos.MutableBlockPos> positionCollector = p -> entry.addPosition(p.asLong());
        entry.setTest(this.getPositionTest(pos, entry.range));
        SphereUtils.collectSpherePositions(positionCollector, entry.getTest(), pos, entry.range);
        if (this.combineQuads) {
            entry.setQuads(SphereUtils.buildSphereShellToQuads(entry.getPositions(), this.quadAxis, entry.getTest(), this.renderType, this.layerRange));
        }
        return entry;
    }

    private void addOrReplaceEntry(Entry entry) {
        AtomicBoolean replaced = new AtomicBoolean(false);
        this.conduits.forEach(e -> {
            if (e.pos.compareTo((Vec3i)entry.pos) == 0) {
                e.clear();
                e.range = entry.range;
                e.positions.addAll((LongCollection)entry.getPositions());
                e.setTest(entry.getTest());
                e.setQuads(entry.getQuads());
                replaced.set(true);
            }
        });
        if (!replaced.get()) {
            this.conduits.add(entry);
        }
    }

    @Override
    protected void renderBlockRange(Level world, Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        boolean outlines = Configs.Generic.CONDUIT_RANGE_OVERLAY_RENDER_OUTLINES.getBooleanValue();
        this.allocateBuffers(outlines);
        this.renderQuads(cameraPos, mc, profiler);
        if (outlines) {
            this.renderOutlines(cameraPos, mc, profiler);
        }
    }

    @Override
    protected void resetBlockRange() {
        this.conduits.forEach(Entry::clear);
        this.conduits.clear();
    }

    private void renderQuads(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        Color4f color = Configs.Colors.CONDUIT_RANGE_OVERLAY_COLOR.getColor();
        profiler.push("conduit_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:conduit/quads", this.renderThrough ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET);
        this.conduits.forEach(entry -> {
            if (this.combineQuads) {
                RenderUtils.renderQuads(entry.getQuads(), color, 0.0, cameraPos, builder);
            } else {
                RenderUtils.renderCircleBlockPositions(entry.getPositions(), PositionUtils.ALL_DIRECTIONS, entry.getTest(), this.renderType, this.layerRange, color, 0.0, cameraPos, builder);
            }
        });
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererConduitRange#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    private void renderOutlines(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null || !Configs.Generic.CONDUIT_RANGE_OVERLAY_RENDER_OUTLINES.getBooleanValue()) {
            return;
        }
        profiler.push("conduit_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:conduit/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        this.conduits.forEach(entry -> {
            if (this.combineQuads) {
                RenderUtils.renderQuadLines(entry.getQuads(), this.colorLines, 0.0, cameraPos, builder);
            } else {
                RenderUtils.renderCircleBlockOutlines(entry.getPositions(), PositionUtils.ALL_DIRECTIONS, entry.getTest(), this.renderType, this.layerRange, this.colorLines, 0.0, cameraPos, builder);
            }
        });
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererConduitRange#renderBlockRange(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.conduits.forEach(Entry::clear);
        this.conduits.clear();
    }

    protected SphereUtils.RingPositionTest getPositionTest(BlockPos centerPos, int range) {
        Vec3 center = new Vec3((double)centerPos.getX() + 0.5, (double)centerPos.getY() + 0.5, (double)centerPos.getZ() + 0.5);
        double squareRange = range * range;
        return (x, y, z, dir) -> SphereUtils.isPositionInsideOrClosestToRadiusOnBlockRing(x, y, z, center, squareRange, Direction.EAST);
    }

    public static class Entry {
        BlockPos pos;
        int range;
        private final LongOpenHashSet positions;
        @Nullable
        private SphereUtils.RingPositionTest test;
        private final List<SideQuad> quads;

        Entry(BlockPos pos, int range) {
            this.pos = pos;
            this.range = range;
            this.positions = new LongOpenHashSet();
            this.test = null;
            this.quads = new ArrayList<SideQuad>();
        }

        public void addPosition(long pos) {
            this.positions.add(pos);
        }

        public LongOpenHashSet getPositions() {
            return this.positions;
        }

        public void setTest(@Nullable SphereUtils.RingPositionTest test) {
            this.test = test;
        }

        @Nullable
        public SphereUtils.RingPositionTest getTest() {
            return this.test;
        }

        public void setQuads(List<SideQuad> quads) {
            this.quads.clear();
            this.quads.addAll(quads);
        }

        public List<SideQuad> getQuads() {
            return this.quads;
        }

        public void clear() {
            this.positions.clear();
            this.quads.clear();
            this.test = null;
        }
    }
}

