/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.util.LightLevelMarkerMode;
import fi.dy.masa.minihud.util.LightLevelNumberMode;
import fi.dy.masa.minihud.util.LightLevelRenderCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class OverlayRendererLightLevel
extends OverlayRendererBase {
    public static final OverlayRendererLightLevel INSTANCE = new OverlayRendererLightLevel();
    private static final ResourceLocation TEXTURE_NUMBERS = ResourceLocation.fromNamespaceAndPath((String)"minihud", (String)"textures/misc/light_level_numbers.png");
    private final List<LightLevelInfo> lightInfos = new ArrayList<LightLevelInfo>();
    private BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private Direction lastDirection = Direction.NORTH;
    private boolean tagsBroken;
    private boolean needsUpdate;
    private boolean hasData = false;

    protected OverlayRendererLightLevel() {
    }

    @Override
    public String getName() {
        return "LightLevel";
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
        this.clearBuffers();
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_LIGHT_LEVEL.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(entity.getX() - (double)this.lastUpdatePos.getX()) > 4.0 || Math.abs(entity.getY() - (double)this.lastUpdatePos.getY()) > 4.0 || Math.abs(entity.getZ() - (double)this.lastUpdatePos.getZ()) > 4.0 || Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() && this.lastDirection != entity.getDirection();
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null) {
            this.needsUpdate = false;
            return;
        }
        BlockPos pos = PositionUtils.getEntityBlockPos((Entity)entity);
        this.hasData = this.updateLightLevels((Level)mc.level, pos);
        this.renderThrough = Configs.Generic.LIGHT_LEVEL_RENDER_THROUGH.getBooleanValue();
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
        this.lastUpdatePos = pos;
        this.lastDirection = entity.getDirection();
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.lightInfos.isEmpty();
    }

    @Override
    public void allocateBuffers() {
        if (this.renderObjects.isEmpty()) {
            this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Quads", MaLiLibPipelines.POSITION_TEX_COLOR_MASA_LEQUAL_DEPTH));
            this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Lines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH));
        }
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.allocateBuffers();
        this.renderTexQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderTexQuads(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("light_level_quads");
        int safeThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_SAFE.getIntegerValue();
        int dimThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_DIM.getIntegerValue();
        Direction numberFacing = Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() ? mc.player.getDirection() : Direction.NORTH;
        boolean useColoredNumbers = Configs.Generic.LIGHT_LEVEL_COLORED_NUMBERS.getBooleanValue();
        LightLevelNumberMode numberMode = (LightLevelNumberMode)Configs.Generic.LIGHT_LEVEL_NUMBER_MODE.getOptionListValue();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:light_level/tex_quads", this.renderThrough ? MaLiLibPipelines.POSITION_TEX_COLOR_MASA_NO_DEPTH_NO_CULL : MaLiLibPipelines.POSITION_TEX_COLOR_MASA_LEQUAL_DEPTH);
        PoseStack matrices = new PoseStack();
        try {
            ctx.bindTexture(TEXTURE_NUMBERS, 0, 256, 256);
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("bindTexture Exception: {}", (Object)err.getMessage());
            return;
        }
        matrices.pushPose();
        PoseStack.Pose e = matrices.last();
        if (numberMode == LightLevelNumberMode.BLOCK || numberMode == LightLevelNumberMode.BOTH) {
            this.renderNumbers(cameraPos, LightLevelNumberMode.BLOCK, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_X, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_Y, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_LIT, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_DIM, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_DARK, useColoredNumbers, safeThreshold, dimThreshold, numberFacing, builder, e);
        }
        if (numberMode == LightLevelNumberMode.SKY || numberMode == LightLevelNumberMode.BOTH) {
            this.renderNumbers(cameraPos, LightLevelNumberMode.SKY, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_X, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_Y, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_LIT, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_DIM, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_DARK, useColoredNumbers, safeThreshold, dimThreshold, numberFacing, builder, e);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererLightLevel#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        matrices.popPose();
        profiler.pop();
    }

    private void renderOutlines(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("light_level_outlines");
        int safeThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_SAFE.getIntegerValue();
        int dimThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_DIM.getIntegerValue();
        LightLevelMarkerMode markerMode = (LightLevelMarkerMode)Configs.Generic.LIGHT_LEVEL_MARKER_MODE.getOptionListValue();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:light_level/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        if (markerMode == LightLevelMarkerMode.SQUARE) {
            this.renderMarkers(this::renderLightLevelSquare, cameraPos, safeThreshold, dimThreshold, builder);
        } else if (markerMode == LightLevelMarkerMode.CROSS) {
            this.renderMarkers(this::renderLightLevelCross, cameraPos, safeThreshold, dimThreshold, builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererLightLevel#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.tagsBroken = false;
        this.lightInfos.clear();
        this.mutablePos = new BlockPos.MutableBlockPos();
        this.lastDirection = Direction.NORTH;
        this.hasData = false;
    }

    private void renderNumbers(Vec3 cameraPos, LightLevelNumberMode mode, IConfigDouble cfgOffX, IConfigDouble cfgOffZ, ConfigColor cfgColorLit, ConfigColor cfgColorDim, ConfigColor cfgColorDark, boolean useColoredNumbers, int safeThreshold, int dimThreshold, Direction numberFacing, BufferBuilder buffer, PoseStack.Pose e) {
        Color4f colorDark;
        Color4f colorDim;
        Color4f colorLit;
        double tmpX;
        double ox = cfgOffX.getDoubleValue();
        double oz = cfgOffZ.getDoubleValue();
        double offsetY = Configs.Generic.LIGHT_LEVEL_RENDER_OFFSET.getDoubleValue();
        double tmpZ = switch (numberFacing) {
            case Direction.NORTH -> {
                tmpX = -ox;
                yield -oz;
            }
            case Direction.SOUTH -> {
                tmpX = ox;
                yield oz;
            }
            case Direction.WEST -> {
                tmpX = -oz;
                yield ox;
            }
            case Direction.EAST -> {
                tmpX = oz;
                yield -ox;
            }
            default -> {
                tmpX = -ox;
                yield -oz;
            }
        };
        if (useColoredNumbers) {
            colorLit = cfgColorLit.getColor();
            colorDim = cfgColorDim.getColor();
            colorDark = cfgColorDark.getColor();
        } else {
            colorDim = colorLit = Color4f.fromColor((int)-1);
            colorDark = colorLit;
        }
        this.renderLightLevelNumbers(tmpX + cameraPos.x, cameraPos.y - offsetY, tmpZ + cameraPos.z, numberFacing, safeThreshold, dimThreshold, mode, colorLit, colorDim, colorDark, buffer, e);
    }

    private void renderMarkers(IMarkerRenderer renderer, Vec3 cameraPos, int safeThreshold, int dimThreshold, BufferBuilder buffer) {
        Color4f colorBlockLit = Configs.Colors.LIGHT_LEVEL_MARKER_BLOCK_LIT.getColor();
        Color4f colorDim = Configs.Colors.LIGHT_LEVEL_MARKER_DIM.getColor();
        Color4f colorSkyLit = Configs.Colors.LIGHT_LEVEL_MARKER_SKY_LIT.getColor();
        Color4f colorDark = Configs.Colors.LIGHT_LEVEL_MARKER_DARK.getColor();
        LightLevelRenderCondition condition = (LightLevelRenderCondition)Configs.Generic.LIGHT_LEVEL_MARKER_CONDITION.getOptionListValue();
        double markerSize = Configs.Generic.LIGHT_LEVEL_MARKER_SIZE.getDoubleValue();
        double offsetX = cameraPos.x;
        double offsetY = cameraPos.y - Configs.Generic.LIGHT_LEVEL_RENDER_OFFSET.getDoubleValue();
        double offsetZ = cameraPos.z;
        double offset1 = (1.0 - markerSize) / 2.0;
        double offset2 = 1.0 - offset1;
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        for (LightLevelInfo info : this.lightInfos) {
            if (!condition.shouldRender(info.block, dimThreshold, safeThreshold)) continue;
            long pos = info.pos;
            double x = (double)BlockPos.getX((long)pos) - offsetX;
            double y = (double)(autoHeight ? info.y : (float)BlockPos.getY((long)pos)) - offsetY;
            double z = (double)BlockPos.getZ((long)pos) - offsetZ;
            Color4f color = info.block < safeThreshold ? (info.sky >= safeThreshold ? colorSkyLit : colorDark) : (info.block > dimThreshold ? colorBlockLit : colorDim);
            renderer.render((float)x, (float)y, (float)z, color, (float)offset1, (float)offset2, buffer);
        }
    }

    private void renderLightLevelNumbers(double dx, double dy, double dz, Direction facing, int safeThreshold, int dimThreshold, LightLevelNumberMode numberMode, Color4f colorLit, Color4f colorDim, Color4f colorDark, BufferBuilder buffer, PoseStack.Pose e) {
        LightLevelRenderCondition condition = (LightLevelRenderCondition)Configs.Generic.LIGHT_LEVEL_NUMBER_CONDITION.getOptionListValue();
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        for (LightLevelInfo info : this.lightInfos) {
            byte lightLevel;
            if (!condition.shouldRender(info.block, dimThreshold, safeThreshold)) continue;
            long pos = info.pos;
            double x = (double)BlockPos.getX((long)pos) - dx;
            double y = (double)(autoHeight ? info.y : (float)BlockPos.getY((long)pos)) - dy;
            double z = (double)BlockPos.getZ((long)pos) - dz;
            byte by = lightLevel = numberMode == LightLevelNumberMode.BLOCK ? info.block : info.sky;
            Color4f color = lightLevel < safeThreshold ? colorDark : (lightLevel > dimThreshold ? colorLit : colorDim);
            this.renderLightLevelTextureColor((float)x, (float)y, (float)z, facing, lightLevel, color, buffer, e);
        }
    }

    private void renderLightLevelTextureColor(float x, float y, float z, Direction facing, int lightLevel, Color4f color, BufferBuilder buffer, PoseStack.Pose e) {
        float w = 0.25f;
        float u = (float)(lightLevel & 3) * w;
        float v = (float)(lightLevel >> 2) * w;
        y += 0.005f;
        Matrix4f m = e.pose();
        switch (facing) {
            case NORTH: {
                buffer.addVertex(m, x, y, z).setUv(u, v).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x, y, z + 1.0f).setUv(u, v + w).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x + 1.0f, y, z + 1.0f).setUv(u + w, v + w).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x + 1.0f, y, z).setUv(u + w, v).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case SOUTH: {
                buffer.addVertex(m, x + 1.0f, y, z + 1.0f).setUv(u, v).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x + 1.0f, y, z).setUv(u, v + w).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x, y, z).setUv(u + w, v + w).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x, y, z + 1.0f).setUv(u + w, v).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case EAST: {
                buffer.addVertex(m, x + 1.0f, y, z).setUv(u, v).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x, y, z).setUv(u, v + w).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x, y, z + 1.0f).setUv(u + w, v + w).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x + 1.0f, y, z + 1.0f).setUv(u + w, v).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case WEST: {
                buffer.addVertex(m, x, y, z + 1.0f).setUv(u, v).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x + 1.0f, y, z + 1.0f).setUv(u, v + w).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x + 1.0f, y, z).setUv(u + w, v + w).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(m, x, y, z).setUv(u + w, v).setColor(color.r, color.g, color.b, color.a);
                break;
            }
        }
    }

    private void renderLightLevelCross(float x, float y, float z, Color4f color, float offset1, float offset2, BufferBuilder buffer) {
        buffer.addVertex(x + offset1, y += 0.005f, z + offset1).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset2, y, z + offset2).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset1, y, z + offset2).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset2, y, z + offset1).setColor(color.r, color.g, color.b, color.a);
    }

    private void renderLightLevelSquare(float x, float y, float z, Color4f color, float offset1, float offset2, BufferBuilder buffer) {
        buffer.addVertex(x + offset1, y += 0.005f, z + offset1).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset1, y, z + offset2).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset1, y, z + offset2).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset2, y, z + offset2).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset2, y, z + offset2).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset2, y, z + offset1).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset2, y, z + offset1).setColor(color.r, color.g, color.b, color.a);
        buffer.addVertex(x + offset1, y, z + offset1).setColor(color.r, color.g, color.b, color.a);
    }

    private boolean updateLightLevels(Level world, BlockPos center) {
        this.lightInfos.clear();
        int radius = Configs.Generic.LIGHT_LEVEL_RANGE.getIntegerValue();
        int minX = center.getX() - radius;
        int minY = center.getY() - radius;
        int minZ = center.getZ() - radius;
        int maxX = center.getX() + radius;
        int maxY = center.getY() + radius;
        int maxZ = center.getZ() + radius;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        LevelLightEngine lightingProvider = world.getChunkSource().getLightEngine();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int worldTopHeight = world.getMaxY() + 1;
        boolean collisionCheck = Configs.Generic.LIGHT_LEVEL_COLLISION_CHECK.getBooleanValue();
        boolean underWater = Configs.Generic.LIGHT_LEVEL_UNDER_WATER.getBooleanValue();
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        boolean skipBlockCheck = Configs.Generic.LIGHT_LEVEL_SKIP_BLOCK_CHECK.getBooleanValue();
        for (int cx = minCX; cx <= maxCX; ++cx) {
            int startX = Math.max(cx << 4, minX);
            int endX = Math.min((cx << 4) + 15, maxX);
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                int startZ = Math.max(cz << 4, minZ);
                int endZ = Math.min((cz << 4) + 15, maxZ);
                LevelChunk chunk = world.getChunk(cx, cz);
                int startY = Math.max(minY, world.getMinY());
                int endY = Math.min(maxY, WorldUtils.getHighestSectionYOffset((ChunkAccess)chunk) + 15 + 1);
                for (int y = startY; y <= endY; ++y) {
                    LevelChunkSection section;
                    if (y > startY && (section = chunk.getSection(chunk.getSectionIndex(y - 1))).hasOnlyAir()) continue;
                    for (int x = startX; x <= endX; ++x) {
                        for (int z = startZ; z <= endZ; ++z) {
                            if (!this.canSpawnAtWrapper(x, y, z, (ChunkAccess)chunk, world, skipBlockCheck)) continue;
                            mutablePos.set(x, y, z);
                            BlockState state = chunk.getBlockState((BlockPos)mutablePos);
                            if (collisionCheck && !state.getCollisionShape((BlockGetter)chunk, (BlockPos)mutablePos).isEmpty() || !underWater && !state.getFluidState().isEmpty()) continue;
                            int block = y < worldTopHeight ? lightingProvider.getLayerListener(LightLayer.BLOCK).getLightValue((BlockPos)mutablePos) : 0;
                            int sky = y < worldTopHeight ? lightingProvider.getLayerListener(LightLayer.SKY).getLightValue((BlockPos)mutablePos) : 15;
                            double topY = state.getShape((BlockGetter)chunk, (BlockPos)mutablePos).max(Direction.Axis.Y);
                            if (autoHeight && !(topY < 1.0)) continue;
                            float posY = topY >= 0.0 ? (float)y + (float)topY : (float)y;
                            this.lightInfos.add(new LightLevelInfo(mutablePos.asLong(), posY, block, sky));
                        }
                    }
                }
            }
        }
        return !this.lightInfos.isEmpty();
    }

    private boolean canSpawnAtWrapper(int x, int y, int z, ChunkAccess chunk, Level world, boolean skipBlockCheck) {
        try {
            return this.canSpawnAt(x, y, z, chunk, world, skipBlockCheck);
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"This dimension seems to have missing block tag data, the light level will not use the normal block spawnability checks in this dimension. This is known to happen on some Waterfall/BungeeCord/ViaVersion/whatever setups that have an older MC version at the back end.", (Object[])new Object[0]);
            this.tagsBroken = true;
            return false;
        }
    }

    private boolean canSpawnAt(int x, int y, int z, ChunkAccess chunk, Level world, boolean skipBlockCheck) {
        this.mutablePos.set(x, y - 1, z);
        BlockState stateDown = chunk.getBlockState((BlockPos)this.mutablePos);
        if (skipBlockCheck && !stateDown.isAir() && !(stateDown.getBlock() instanceof LiquidBlock) || stateDown.isValidSpawn((BlockGetter)world, (BlockPos)this.mutablePos, EntityType.CREEPER)) {
            this.mutablePos.set(x, y, z);
            BlockState state = chunk.getBlockState((BlockPos)this.mutablePos);
            if (this.isClearForSpawnWrapper((BlockGetter)world, (BlockPos)this.mutablePos, state, state.getFluidState(), EntityType.WITHER_SKELETON)) {
                this.mutablePos.set(x, y + 1, z);
                BlockState stateUp1 = chunk.getBlockState((BlockPos)this.mutablePos);
                return this.isClearForSpawnWrapper((BlockGetter)world, (BlockPos)this.mutablePos, stateUp1, state.getFluidState(), EntityType.WITHER_SKELETON);
            }
            if (state.getFluidState().is(FluidTags.WATER)) {
                this.mutablePos.set(x, y + 1, z);
                BlockState stateUp1 = chunk.getBlockState((BlockPos)this.mutablePos);
                return stateUp1.getFluidState().is(FluidTags.WATER) && !chunk.getBlockState((BlockPos)this.mutablePos.set(x, y + 2, z)).isRedstoneConductor((BlockGetter)world, (BlockPos)this.mutablePos);
            }
        }
        return false;
    }

    public boolean isClearForSpawnWrapper(BlockGetter blockView, BlockPos pos, BlockState state, FluidState fluidState, EntityType<?> entityType) {
        return this.tagsBroken ? OverlayRendererLightLevel.isClearForSpawnStripped(blockView, pos, state, fluidState, entityType) : NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)blockView, (BlockPos)pos, (BlockState)state, (FluidState)fluidState, entityType);
    }

    public static boolean isClearForSpawnStripped(BlockGetter blockView, BlockPos pos, BlockState state, FluidState fluidState, EntityType<?> entityType) {
        return !state.isCollisionShapeFullBlock(blockView, pos) && !state.isSignalSource() && fluidState.isEmpty();
    }

    private static interface IMarkerRenderer {
        public void render(float var1, float var2, float var3, Color4f var4, float var5, float var6, BufferBuilder var7);
    }

    public static class LightLevelInfo {
        public long pos;
        public byte block;
        public byte sky;
        public float y;

        public LightLevelInfo(long pos, float y, int block, int sky) {
            this.pos = pos;
            this.y = y;
            this.block = (byte)block;
            this.sky = (byte)sky;
        }
    }
}

