/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererRandomTickableChunks
extends OverlayRendererBase {
    public static final OverlayRendererRandomTickableChunks INSTANCE_FIXED = new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_FIXED);
    public static final OverlayRendererRandomTickableChunks INSTANCE_PLAYER = new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER);
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    protected boolean needsUpdate = true;
    @Nullable
    public Vec3 newPos;
    protected RendererToggle toggle;
    protected Vec3 pos = Vec3.ZERO;
    protected double minX;
    protected double minZ;
    protected double maxX;
    protected double maxZ;
    private final HashMap<ChunkPos, List<AABB>> chunkMap;
    private Entity cameraEntity;
    private boolean hasData;

    protected OverlayRendererRandomTickableChunks(RendererToggle toggle) {
        this.toggle = toggle;
        this.useCulling = true;
        this.renderThrough = false;
        this.chunkMap = new HashMap();
        this.cameraEntity = null;
        this.hasData = false;
    }

    @Override
    public String getName() {
        return "RandomTickableChunks";
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    public void setNewPos(@Nullable Vec3 pos) {
        this.newPos = pos;
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return this.toggle.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        if (this.needsUpdate) {
            return true;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            return this.newPos != null;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            return entity.getX() != this.pos.x || entity.getZ() != this.pos.z;
        }
        return false;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            this.pos = entity.position();
        } else if (this.newPos != null) {
            this.pos = this.newPos;
            this.newPos = null;
        }
        this.chunkMap.clear();
        Set<ChunkPos> chunks = this.getRandomTickableChunks(this.pos);
        this.cameraEntity = entity;
        for (ChunkPos pos : chunks) {
            ArrayList<AABB> boxes = new ArrayList<AABB>();
            for (Direction side : HORIZONTALS) {
                AABB bb;
                ChunkPos posAdj = new ChunkPos(pos.x + side.getStepX(), pos.z + side.getStepZ());
                if (chunks.contains(posAdj) || (bb = this.calculateChunkEdge(pos, side, entity.level())) == null) continue;
                boxes.add(bb);
            }
            if (boxes.isEmpty()) continue;
            this.chunkMap.put(pos, boxes);
            this.hasData = true;
        }
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.chunkMap.isEmpty() && this.cameraEntity != null;
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("random_tick_quads");
        Color4f color = this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER ? Configs.Colors.RANDOM_TICKS_PLAYER_OVERLAY_COLOR.getColor() : Configs.Colors.RANDOM_TICKS_FIXED_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:random_tick/quads", MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1);
        this.chunkMap.forEach((pos, boxes) -> {
            for (AABB bb : boxes) {
                RenderUtils.renderWallQuads(bb, cameraPos, color, builder);
            }
        });
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererRandomTickableChunks#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    private void renderOutlines(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("random_tick_outlines");
        Color4f color = this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER ? Configs.Colors.RANDOM_TICKS_PLAYER_OVERLAY_COLOR.getColor() : Configs.Colors.RANDOM_TICKS_FIXED_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:random_tick/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        this.chunkMap.forEach((pos, boxes) -> {
            for (AABB bb : boxes) {
                RenderUtils.renderWallOutlines(bb, 16.0, 16.0, true, cameraPos, color, builder);
            }
        });
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererRandomTickableChunks#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.chunkMap.clear();
        this.cameraEntity = null;
        this.hasData = false;
    }

    protected Set<ChunkPos> getRandomTickableChunks(Vec3 posCenter) {
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        int centerChunkX = (int)Math.floor(posCenter.x) >> 4;
        int centerChunkZ = (int)Math.floor(posCenter.z) >> 4;
        double maxRange = 16384.0;
        int r = 9;
        for (int cz = centerChunkZ - 9; cz <= centerChunkZ + 9; ++cz) {
            for (int cx = centerChunkX - 9; cx <= centerChunkX + 9; ++cx) {
                double dx = (double)(cx * 16 + 8) - posCenter.x;
                double dz = (double)(cz * 16 + 8) - posCenter.z;
                if (!(dx * dx + dz * dz < 16384.0)) continue;
                set.add(new ChunkPos(cx, cz));
            }
        }
        if (!set.isEmpty()) {
            this.hasData = true;
        }
        return set;
    }

    @Nullable
    private AABB calculateChunkEdge(ChunkPos pos, Direction side, Level world) {
        float maxZ;
        float maxX;
        float minZ;
        float minX;
        switch (side) {
            case NORTH: {
                minX = pos.x << 4;
                minZ = pos.z << 4;
                maxX = (float)((double)(pos.x << 4) + 16.0);
                maxZ = pos.z << 4;
                break;
            }
            case SOUTH: {
                minX = pos.x << 4;
                minZ = (float)((double)(pos.z << 4) + 16.0);
                maxX = (float)((double)(pos.x << 4) + 16.0);
                maxZ = (float)((double)(pos.z << 4) + 16.0);
                break;
            }
            case WEST: {
                minX = pos.x << 4;
                minZ = pos.z << 4;
                maxX = pos.x << 4;
                maxZ = (float)((double)(pos.z << 4) + 16.0);
                break;
            }
            case EAST: {
                minX = (float)((double)(pos.x << 4) + 16.0);
                minZ = pos.z << 4;
                maxX = (float)((double)(pos.x << 4) + 16.0);
                maxZ = (float)((double)(pos.z << 4) + 16.0);
                break;
            }
            default: {
                return null;
            }
        }
        int minY = world != null ? world.getMinY() : -64;
        int maxY = world != null ? world.getMaxY() + 1 : 320;
        return new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @Override
    public String getSaveId() {
        return this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED ? "random_tickable_chunks" : "";
    }

    @Override
    @Nullable
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("pos", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.pos));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        Vec3 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"pos");
        if (pos != null && this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            this.newPos = pos;
        }
    }
}

