/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererSlimeChunks
extends OverlayRendererBase {
    public static final OverlayRendererSlimeChunks INSTANCE = new OverlayRendererSlimeChunks();
    public double overlayTopY;
    protected boolean needsUpdate = true;
    protected boolean wasSeedKnown = false;
    protected long seed = -1L;
    protected double topY = 40.0;
    private final List<AABB> slimeChunks = new ArrayList<AABB>();
    private boolean hasData;

    protected OverlayRendererSlimeChunks() {
        this.useCulling = true;
        this.hasData = false;
    }

    @Override
    public String getName() {
        return "SlimeChunks";
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    public void setOverlayTopY(double y) {
        this.overlayTopY = y;
    }

    public void incrementOverlayTopY(double y) {
        this.overlayTopY += y;
    }

    public void onEnabled() {
        if (Configs.Generic.SLIME_CHUNK_TOP_TO_PLAYER.getBooleanValue()) {
            Entity entity = EntityUtils.getCameraEntity();
            if (entity != null) {
                this.overlayTopY = entity.getY();
            }
        } else {
            this.overlayTopY = 40.0;
        }
        this.setNeedsUpdate();
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getBooleanValue() && mc.level != null && HudDataManager.getInstance().isWorldSeedKnown((Level)mc.level) && MiscUtils.isOverworld((Level)mc.level);
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        if (this.needsUpdate) {
            return true;
        }
        Level world = entity.level();
        boolean isSeedKnown = HudDataManager.getInstance().isWorldSeedKnown(world);
        long seed = HudDataManager.getInstance().getWorldSeed(world);
        if (this.topY != this.overlayTopY || this.wasSeedKnown != isSeedKnown || this.seed != seed) {
            return true;
        }
        int ex = (int)Math.floor(entity.getX());
        int ez = (int)Math.floor(entity.getZ());
        int lx = this.lastUpdatePos.getX();
        int lz = this.lastUpdatePos.getZ();
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        this.calculateChunks(entity, mc);
        this.renderThrough = Configs.Generic.SLIME_CHUNK_RENDER_THROUGH.getBooleanValue();
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.slimeChunks.isEmpty();
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        Color4f colorSides = Configs.Colors.SLIME_CHUNKS_OVERLAY_COLOR.getColor();
        profiler.push("slime_chunk_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:slime_chunk/quads", this.renderThrough ? MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL : MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1);
        PoseStack matrices = new PoseStack();
        matrices.pushPose();
        for (AABB bb : this.slimeChunks) {
            float x1 = (float)(bb.minX - cameraPos.x);
            float y1 = (float)(bb.minY - cameraPos.y);
            float z1 = (float)(bb.minZ - cameraPos.z);
            float x2 = (float)(bb.maxX - cameraPos.x);
            float y2 = (float)(bb.maxY - cameraPos.y);
            float z2 = (float)(bb.maxZ - cameraPos.z);
            RenderUtils.drawBoxAllSidesBatchedQuads((float)x1, (float)y1, (float)z1, (float)x2, (float)y2, (float)z2, (Color4f)colorSides, (BufferBuilder)builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSlimeChunks#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        matrices.popPose();
        profiler.pop();
    }

    private void renderOutlines(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        Color4f colorLines = Color4f.fromColor((int)Configs.Colors.SLIME_CHUNKS_OVERLAY_COLOR.getColor().getIntValue(), (float)1.0f);
        profiler.push("slime_chunk_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:slime_chunk/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        for (AABB bb : this.slimeChunks) {
            float x1 = (float)(bb.minX - cameraPos.x);
            float y1 = (float)(bb.minY - cameraPos.y);
            float z1 = (float)(bb.minZ - cameraPos.z);
            float x2 = (float)(bb.maxX - cameraPos.x);
            float y2 = (float)(bb.maxY - cameraPos.y);
            float z2 = (float)(bb.maxZ - cameraPos.z);
            RenderUtils.drawBoxAllEdgesBatchedLines((float)x1, (float)y1, (float)z1, (float)x2, (float)y2, (float)z2, (Color4f)colorLines, (BufferBuilder)builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSlimeChunks#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.slimeChunks.clear();
        this.wasSeedKnown = false;
        this.seed = -1L;
        this.topY = 40.0;
        this.hasData = false;
    }

    private void calculateChunks(Entity entity, Minecraft mc) {
        HudDataManager data = HudDataManager.getInstance();
        Level world = entity.level();
        int centerX = Mth.floor((double)entity.getX()) >> 4;
        int centerZ = Mth.floor((double)entity.getZ()) >> 4;
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        this.topY = this.overlayTopY;
        this.wasSeedKnown = data.isWorldSeedKnown(world);
        this.seed = data.getWorldSeed(world);
        this.hasData = false;
        if (this.wasSeedKnown) {
            int r = Mth.clamp((int)Configs.Generic.SLIME_CHUNK_OVERLAY_RADIUS.getIntegerValue(), (int)-1, (int)40);
            if (r == -1) {
                r = (Integer)mc.options.renderDistance().get();
            }
            int minY = world != null ? world.getMinY() : -64;
            int topY = (int)Math.floor(this.topY);
            int count = 0;
            for (int xOff = -r; xOff <= r; ++xOff) {
                for (int zOff = -r; zOff <= r; ++zOff) {
                    int cx = centerX + xOff;
                    int cz = centerZ + zOff;
                    if (!MiscUtils.canSlimeSpawnInChunk(cx, cz, this.seed)) continue;
                    pos1.set(cx << 4, minY, cz << 4);
                    pos2.set((cx << 4) + 15, topY, (cz << 4) + 15);
                    AABB bb = AABB.encapsulatingFullBlocks((BlockPos)pos1, (BlockPos)pos2);
                    if (!this.slimeChunks.contains(bb)) {
                        this.slimeChunks.add(bb);
                    }
                    ++count;
                }
            }
            if (count > 0) {
                this.hasData = true;
            }
        }
    }

    @Override
    public String getSaveId() {
        return "slime_chunks";
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("y_top", (JsonElement)new JsonPrimitive((Number)this.overlayTopY));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        this.overlayTopY = JsonUtils.getFloat((JsonObject)obj, (String)"y_top");
    }
}

