/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererSpawnChunks
extends OverlayRendererBase
implements AutoCloseable {
    public static final OverlayRendererSpawnChunks INSTANCE_PLAYER = new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER);
    public static final OverlayRendererSpawnChunks INSTANCE_REAL = new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL);
    protected final RendererToggle toggle;
    protected final boolean isPlayerFollowing;
    protected boolean needsUpdate = true;
    protected List<AABB> boxesBrown;
    protected List<AABB> boxesRed;
    protected List<AABB> boxesYellow;
    protected List<AABB> boxesGreen;
    protected BlockPos center;
    private boolean hasData;

    protected OverlayRendererSpawnChunks(RendererToggle toggle) {
        this.toggle = toggle;
        this.isPlayerFollowing = toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER;
        this.boxesBrown = new ArrayList<AABB>();
        this.boxesRed = new ArrayList<AABB>();
        this.boxesYellow = new ArrayList<AABB>();
        this.boxesGreen = new ArrayList<AABB>();
        this.center = BlockPos.ZERO;
        this.hasData = false;
    }

    @Override
    public String getName() {
        return "SpawnChunks";
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return this.toggle.getBooleanValue() && (this.isPlayerFollowing || mc.level != null && HudDataManager.getInstance().isWorldSpawnKnown());
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        if (this.needsUpdate) {
            return true;
        }
        if (mc.player == null) {
            return false;
        }
        Object object = entity = this.isPlayerFollowing ? mc.player : entity;
        if (this.lastUpdatePos == null) {
            this.lastUpdatePos = entity.blockPosition();
            return true;
        }
        int ex = (int)Math.floor(entity.getX());
        int ey = (int)Math.floor(entity.getY());
        int ez = (int)Math.floor(entity.getZ());
        int lx = this.lastUpdatePos.getX();
        int ly = this.lastUpdatePos.getY();
        int lz = this.lastUpdatePos.getZ();
        if (this.isPlayerFollowing) {
            return ex != lx || ez != lz || Math.abs(ey - ly) > 16;
        }
        int range = (Integer)mc.options.renderDistance().get() * 16;
        return Math.abs(lx - ex) > range || Math.abs(ey - ly) > 16 || Math.abs(lz - ez) > range;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        boolean yellowEnabled;
        boolean brownEnabled;
        int brown;
        int green;
        int yellow;
        int red;
        if (mc.level == null || mc.player == null || !RenderSystem.isOnRenderThread()) {
            return;
        }
        entity = this.isPlayerFollowing ? mc.player : entity;
        HudDataManager data = HudDataManager.getInstance();
        if (this.isPlayerFollowing) {
            this.center = PositionUtils.getEntityBlockPos((Entity)entity);
            int spawnChunkRadius = this.getSimulationDistance();
            red = spawnChunkRadius + 1;
            yellow = spawnChunkRadius;
            green = spawnChunkRadius - 1;
            brown = red + 11;
            brownEnabled = Configs.Generic.SPAWN_PLAYER_OUTER_OVERLAY_ENABLED.getBooleanValue();
            yellowEnabled = Configs.Generic.SPAWN_PLAYER_REDSTONE_OVERLAY_ENABLED.getBooleanValue();
        } else if (data.isSpawnChunkRadiusKnown() && data.getSpawnChunkRadius() > 0 && data.getWorldSpawn().dimension().equals(mc.level.dimension())) {
            this.center = data.getWorldSpawn().pos();
            int spawnChunkRadius = data.getSpawnChunkRadius();
            red = spawnChunkRadius + 1;
            yellow = spawnChunkRadius;
            green = spawnChunkRadius - 1;
            brown = red + 11;
            brownEnabled = Configs.Generic.SPAWN_REAL_OUTER_OVERLAY_ENABLED.getBooleanValue();
            yellowEnabled = Configs.Generic.SPAWN_REAL_REDSTONE_OVERLAY_ENABLED.getBooleanValue();
        } else if (data.getWorldSpawn().dimension().equals(mc.level.dimension())) {
            this.center = data.getWorldSpawn().pos();
            red = 0;
            yellow = 0;
            green = 0;
            brown = 0;
            brownEnabled = false;
            yellowEnabled = false;
        } else {
            this.hasData = false;
            this.needsUpdate = false;
            return;
        }
        if (this.isPlayerFollowing || data.isSpawnChunkRadiusKnown()) {
            Pair<BlockPos, BlockPos> corners;
            if (brownEnabled) {
                corners = this.getSpawnChunkCorners(this.center, brown, (Level)mc.level);
                this.boxesBrown = RenderUtils.calculateBoxes((BlockPos)corners.getLeft(), (BlockPos)corners.getRight());
            }
            corners = this.getSpawnChunkCorners(this.center, red, (Level)mc.level);
            this.boxesRed = RenderUtils.calculateBoxes((BlockPos)corners.getLeft(), (BlockPos)corners.getRight());
            if (yellowEnabled) {
                corners = this.getSpawnChunkCorners(this.center, yellow, (Level)mc.level);
                this.boxesYellow = RenderUtils.calculateBoxes((BlockPos)corners.getLeft(), (BlockPos)corners.getRight());
            }
            corners = this.getSpawnChunkCorners(this.center, green, (Level)mc.level);
            this.boxesGreen = RenderUtils.calculateBoxes((BlockPos)corners.getLeft(), (BlockPos)corners.getRight());
        }
        this.hasData = true;
        this.render(cameraPos, mc, profiler);
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && this.center != null;
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("spawn_chunk_quads");
        Color4f colorEntity = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getColor();
        Color4f colorRedstone = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_REDSTONE_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_REDSTONE_OVERLAY_COLOR.getColor();
        Color4f colorLazy = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getColor();
        Color4f colorOuter = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_OUTER_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:spawn_chunk/quads", MaLiLibPipelines.MINIHUD_SHAPE_OFFSET);
        fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxSidesBatchedQuads((BlockPos)this.center, (Vec3)cameraPos, (Color4f)colorEntity, (double)0.001, (BufferBuilder)builder);
        if (this.isPlayerFollowing || HudDataManager.getInstance().isSpawnChunkRadiusKnown()) {
            for (AABB entry : this.boxesBrown) {
                RenderUtils.renderWallQuads(entry, cameraPos, colorOuter, builder);
            }
            for (AABB entry : this.boxesRed) {
                RenderUtils.renderWallQuads(entry, cameraPos, colorLazy, builder);
            }
            for (AABB entry : this.boxesYellow) {
                RenderUtils.renderWallQuads(entry, cameraPos, colorRedstone, builder);
            }
            for (AABB entry : this.boxesGreen) {
                RenderUtils.renderWallQuads(entry, cameraPos, colorEntity, builder);
            }
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSpawnChunks#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    private void renderOutlines(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("spawn_chunk_outlines");
        Color4f colorEntity = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getColor();
        Color4f colorRedstone = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_REDSTONE_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_REDSTONE_OVERLAY_COLOR.getColor();
        Color4f colorLazy = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getColor();
        Color4f colorOuter = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_OUTER_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:spawn_chunk/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((BlockPos)this.center, (Vec3)cameraPos, (Color4f)Color4f.WHITE, (double)0.001, (BufferBuilder)builder);
        if (this.isPlayerFollowing || HudDataManager.getInstance().isSpawnChunkRadiusKnown()) {
            for (AABB entry : this.boxesBrown) {
                RenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, colorOuter, builder);
            }
            for (AABB entry : this.boxesRed) {
                RenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, colorLazy, builder);
            }
            for (AABB entry : this.boxesYellow) {
                RenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, colorRedstone, builder);
            }
            for (AABB entry : this.boxesGreen) {
                RenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, colorEntity, builder);
            }
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSpawnChunks#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.boxesBrown.clear();
        this.boxesRed.clear();
        this.boxesYellow.clear();
        this.boxesGreen.clear();
        this.center = null;
        this.hasData = false;
    }

    @Override
    public void close() {
        this.reset();
    }

    protected Pair<BlockPos, BlockPos> getSpawnChunkCorners(BlockPos worldSpawn, int chunkRange, Level world) {
        int cx = worldSpawn.getX() >> 4;
        int cz = worldSpawn.getZ() >> 4;
        int minY = this.getMinY(world, worldSpawn, cx, cz);
        int maxY = world != null ? world.getMaxY() + 1 : 320;
        BlockPos pos1 = new BlockPos(cx - chunkRange << 4, minY, cz - chunkRange << 4);
        BlockPos pos2 = new BlockPos((cx + chunkRange << 4) + 15, maxY, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }

    private int getMinY(Level world, BlockPos pos, int cx, int cz) {
        int minY;
        Minecraft mc = Minecraft.getInstance();
        if (world != null && mc.player != null) {
            int ws = world.getChunk(cx, cz).getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ());
            minY = mc.player.blockPosition().getY() >= world.getSeaLevel() ? Math.min(world.getSeaLevel(), ws) : Math.min(Math.max(world.getMinSectionY(), ws), mc.player.blockPosition().getY() - 16);
        } else {
            minY = world != null ? world.getMinY() : -64;
        }
        return minY;
    }

    protected int getSimulationDistance() {
        if (DataStorage.getInstance().isSimulationDistanceKnown()) {
            return DataStorage.getInstance().getSimulationDistance();
        }
        return 10;
    }
}

