/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererSpawnableColumnHeights
extends OverlayRendererBase {
    public static final OverlayRendererSpawnableColumnHeights INSTANCE = new OverlayRendererSpawnableColumnHeights();
    private final Set<Long> DIRTY_CHUNKS = new HashSet<Long>();
    private final BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
    private long lastCheckTime;
    private final List<AABB> boxes = new ArrayList<AABB>();

    protected OverlayRendererSpawnableColumnHeights() {
        this.renderThrough = false;
        this.useCulling = true;
    }

    @Override
    public String getName() {
        return "SpawnableColumnHeights";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChunkChanged(int cx, int cz) {
        if (RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue()) {
            Set<Long> set = this.DIRTY_CHUNKS;
            synchronized (set) {
                this.DIRTY_CHUNKS.add(ChunkPos.asLong((int)cx, (int)cz));
            }
        }
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        int ex = (int)Math.floor(entity.getX());
        int ez = (int)Math.floor(entity.getZ());
        int lx = this.lastUpdatePos.getX();
        int lz = this.lastUpdatePos.getZ();
        if (Math.abs(lx - ex) > 8 || Math.abs(lz - ez) > 8) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastCheckTime > 1000L) {
            int radius = Mth.clamp((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
            int xStart = (int)entity.getX() - radius >> 4;
            int zStart = (int)entity.getZ() - radius >> 4;
            int xEnd = (int)entity.getX() + radius >> 4;
            int zEnd = (int)entity.getZ() + radius >> 4;
            Set<Long> set = this.DIRTY_CHUNKS;
            synchronized (set) {
                for (int cx = xStart; cx <= xEnd; ++cx) {
                    for (int cz = zStart; cz <= zEnd; ++cz) {
                        if (!this.DIRTY_CHUNKS.contains(ChunkPos.asLong((int)cx, (int)cz))) continue;
                        return true;
                    }
                }
            }
            this.lastCheckTime = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        this.calculateChunks(cameraPos, entity, mc);
        this.lastCheckTime = System.currentTimeMillis();
        Set<Long> set = this.DIRTY_CHUNKS;
        synchronized (set) {
            this.DIRTY_CHUNKS.clear();
        }
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
    }

    @Override
    public boolean hasData() {
        return !this.boxes.isEmpty();
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        Color4f color = Configs.Colors.SPAWNABLE_COLUMNS_OVERLAY_COLOR.getColor();
        profiler.push("column_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:spawnable_column/quads", MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH);
        for (AABB bb : this.boxes) {
            RenderUtils.drawBoxHorizontalSidesBatchedQuads((float)((float)bb.minX), (float)((float)bb.minY), (float)((float)bb.minZ), (float)((float)bb.maxX), (float)((float)bb.maxY), (float)((float)bb.maxZ), (Color4f)color, (BufferBuilder)builder);
            RenderUtils.drawBoxTopBatchedQuads((float)((float)bb.minX), (float)((float)bb.minZ), (float)((float)bb.maxX), (float)((float)bb.maxY), (float)((float)bb.maxZ), (Color4f)color, (BufferBuilder)builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSpawnableColumnHeights#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    private void renderOutlines(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        Color4f color = Configs.Colors.SPAWNABLE_COLUMNS_OVERLAY_COLOR.getColor();
        profiler.push("column_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:spawnable_column/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        for (AABB bb : this.boxes) {
            RenderUtils.drawBoxAllEdgesBatchedLines((float)((float)bb.minX), (float)((float)bb.minY), (float)((float)bb.minZ), (float)((float)bb.maxX), (float)((float)bb.maxY), (float)((float)bb.maxZ), (Color4f)color, (BufferBuilder)builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSpawnableColumnHeights#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    private void calculateChunks(Vec3 cameraPos, Entity entity, Minecraft mc) {
        if (mc.level == null) {
            return;
        }
        int radius = Mth.clamp((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
        int xStart = (int)entity.getX() - radius;
        int zStart = (int)entity.getZ() - radius;
        int xEnd = (int)entity.getX() + radius;
        int zEnd = (int)entity.getZ() + radius;
        ClientLevel world = mc.level;
        this.boxes.clear();
        for (int x = xStart; x <= xEnd; ++x) {
            double minX = (double)x + 0.25 - cameraPos.x;
            double maxX = minX + 0.5;
            for (int z = zStart; z <= zEnd; ++z) {
                int height = world.getChunkAt((BlockPos)this.posMutable.set(x, 0, z)).getHeight(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
                double minY = (double)height - cameraPos.y;
                double maxY = minY + 0.09375;
                double minZ = (double)z + 0.25 - cameraPos.z;
                double maxZ = minZ + 0.5;
                this.boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        this.boxes.clear();
        this.lastCheckTime = -1L;
        Set<Long> set = this.DIRTY_CHUNKS;
        synchronized (set) {
            this.DIRTY_CHUNKS.clear();
        }
    }
}

