/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.config.StructureToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererStructures
extends OverlayRendererBase {
    public static final OverlayRendererStructures INSTANCE = new OverlayRendererStructures();
    private List<StructureData> structures = new ArrayList<StructureData>();
    private boolean hasData = false;

    private OverlayRendererStructures() {
    }

    @Override
    public String getName() {
        return "Structures";
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return false;
        }
        for (StructureType type : StructureType.VALUES) {
            if (!type.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        int hysteresis = 16;
        return DataStorage.getInstance().structureRendererNeedsUpdate() || Math.abs(entity.getX() - (double)this.lastUpdatePos.getX()) > (double)hysteresis || Math.abs(entity.getY() - (double)this.lastUpdatePos.getY()) > (double)hysteresis || Math.abs(entity.getZ() - (double)this.lastUpdatePos.getZ()) > (double)hysteresis;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        int maxRange = ((Integer)mc.options.renderDistance().get() + 4) * 16;
        this.structures = this.getStructuresToRender(this.lastUpdatePos, maxRange);
        this.hasData = !this.structures.isEmpty();
        this.renderThrough = Configs.Generic.STRUCTURES_RENDER_THROUGH.getBooleanValue();
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.structures.isEmpty();
    }

    @Override
    protected void allocateBuffers(boolean useOutlines) {
        this.clearBuffers();
        this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Main Quads", MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_LEQUAL_DEPTH_OFFSET_1));
        this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + " Components", MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH));
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        this.allocateBuffers();
        this.renderStructureMain(cameraPos, mc, profiler);
        this.renderStructureComponents(cameraPos, mc, profiler);
    }

    private void renderStructureMain(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("structure main");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        BufferBuilder builder = ctx.start(() -> "minihud:structure/main_quads", this.renderThrough ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET);
        for (StructureData structure : this.structures) {
            StructureToggle toggle = structure.getStructureType().getToggle();
            Color4f mainColor = toggle.getColorMain().getColor();
            IntBoundingBox bb = structure.getBoundingBox();
            RenderUtils.drawBoxNoOutlines(bb, cameraPos, mainColor, builder);
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererStructures#renderStructureMain(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    private void renderStructureComponents(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
        if (mc.level == null || mc.player == null) {
            return;
        }
        profiler.push("structure components");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        BufferBuilder builder = ctx.start(() -> "minihud:structure/component_quads", this.renderThrough ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET);
        for (StructureData structure : this.structures) {
            StructureToggle toggle = structure.getStructureType().getToggle();
            Color4f componentColor = toggle.getColorComponents().getColor();
            ImmutableList<IntBoundingBox> components = structure.getComponents();
            if (components.isEmpty() || components.size() <= 1 && MiscUtils.areBoxesEqual((IntBoundingBox)components.getFirst(), structure.getBoundingBox())) continue;
            for (IntBoundingBox bb : components) {
                RenderUtils.drawBoxNoOutlines(bb, cameraPos, componentColor, builder);
            }
        }
        try {
            MeshData meshData = builder.build();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererStructures#renderStructureComponents(): Exception; {}", (Object)err.getMessage());
        }
        profiler.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.structures.clear();
    }

    private List<StructureData> getStructuresToRender(BlockPos playerPos, int maxRange) {
        ArrayListMultimap<StructureType, StructureData> structures = DataStorage.getInstance().getCopyOfStructureDataWithinRange(playerPos, maxRange);
        ArrayList<StructureData> data = new ArrayList<StructureData>();
        for (StructureType type : structures.keySet()) {
            if (!type.isEnabled()) continue;
            data.addAll(structures.get((Object)type));
        }
        return data;
    }
}

