/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinMerchantEntity;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.mixin.entity.IMixinZombieVillagerEntity;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.util.EntityUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererVillagerInfo
extends OverlayRendererBase
implements IClientTickHandler {
    public static final OverlayRendererVillagerInfo INSTANCE = new OverlayRendererVillagerInfo();
    private final ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> recentEntityData = new ConcurrentHashMap();
    private long lastTick = System.currentTimeMillis();

    protected OverlayRendererVillagerInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(boolean isLogout) {
        if (!isLogout) {
            MiniHUD.debugLog("OverlayRendererVillagerInfo#reset() - dimension change or log-in", new Object[0]);
            long now = System.currentTimeMillis();
            this.lastTick = -(this.getCacheTimeout() + 5000L);
            this.tickCache(now);
            this.lastTick = now;
        } else {
            MiniHUD.debugLog("OverlayRendererVillagerInfo#reset() - log-out", new Object[0]);
        }
        ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> concurrentHashMap = this.recentEntityData;
        synchronized (concurrentHashMap) {
            this.recentEntityData.clear();
        }
    }

    public void onClientTick(Minecraft mc) {
        long now = System.currentTimeMillis();
        if (now - this.lastTick > 50L) {
            this.lastTick = now;
            if (RendererToggle.OVERLAY_VILLAGER_INFO.getBooleanValue()) {
                this.tickCache(now);
            } else if (!this.recentEntityData.isEmpty()) {
                this.recentEntityData.clear();
            }
        }
    }

    private long getCacheTimeout() {
        return EntitiesDataManager.getInstance().getCacheTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickCache(long now) {
        long timeout = this.getCacheTimeout();
        ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> concurrentHashMap = this.recentEntityData;
        synchronized (concurrentHashMap) {
            this.recentEntityData.forEach((integer, longPair) -> {
                if (now - (Long)longPair.getLeft() > timeout || (Long)longPair.getLeft() > now) {
                    this.recentEntityData.remove(integer);
                }
            });
        }
    }

    private boolean isNbtValid(CompoundTag nbt) {
        if (nbt.contains("Offers")) {
            return true;
        }
        return nbt.contains("ConversionTime") && nbt.getIntOr("ConversionTime", -1) > 0 || nbt.contains("ConversionPlayer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Pair<Entity, CompoundTag> getVillagerData(Level world, int entityId) {
        Pair<Entity, CompoundTag> pair = EntitiesDataManager.getInstance().requestEntity(world, entityId);
        if (pair != null && pair.getRight() != null && !((CompoundTag)pair.getRight()).isEmpty() && this.isNbtValid((CompoundTag)pair.getRight())) {
            long now = System.currentTimeMillis();
            ConcurrentHashMap<Integer, Pair<Long, Pair<Entity, CompoundTag>>> concurrentHashMap = this.recentEntityData;
            synchronized (concurrentHashMap) {
                this.recentEntityData.put(entityId, (Pair<Long, Pair<Entity, CompoundTag>>)Pair.of((Object)now, pair));
            }
            return pair;
        }
        if (this.recentEntityData.containsKey(entityId)) {
            return (Pair)this.recentEntityData.get(entityId).getRight();
        }
        return null;
    }

    @Nullable
    private MerchantOffers getTrades(Level world, Villager villager) {
        if (world == null || villager == null) {
            return null;
        }
        Pair<Entity, CompoundTag> pair = this.getVillagerData(world, villager.getId());
        MerchantOffers list = null;
        if (pair != null) {
            Object object;
            if (pair.getRight() != null && !((CompoundTag)pair.getRight()).isEmpty()) {
                list = NbtEntityUtils.getTradeOffersFromNbt((CompoundTag)((CompoundTag)pair.getRight()), (RegistryAccess)world.registryAccess());
            } else if (pair.getLeft() != null && (object = pair.getLeft()) instanceof Villager) {
                Villager entity = (Villager)object;
                list = ((IMixinMerchantEntity)entity).malilib_offers();
            }
        }
        return list;
    }

    private int getConversionTime(Level world, ZombieVillager villager) {
        if (world == null || villager == null) {
            return -1;
        }
        Pair<Entity, CompoundTag> pair = this.getVillagerData(world, villager.getId());
        int conversionTime = -1;
        if (pair != null) {
            Object object;
            if (pair.getRight() != null && !((CompoundTag)pair.getRight()).isEmpty()) {
                Pair zombiePair = NbtEntityUtils.getZombieConversionTimerFromNbt((CompoundTag)((CompoundTag)pair.getRight()));
                if (zombiePair != null && (Integer)zombiePair.getLeft() > -1) {
                    conversionTime = (Integer)zombiePair.getLeft();
                }
            } else if (pair.getLeft() != null && (object = pair.getLeft()) instanceof ZombieVillager) {
                ZombieVillager zombert = (ZombieVillager)object;
                conversionTime = ((IMixinZombieVillagerEntity)zombert).minihud_conversionTimer();
            }
        }
        return conversionTime;
    }

    @Override
    public String getName() {
        return "VillagerInfo";
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_VILLAGER_INFO.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        return true;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        AABB box = entity.getBoundingBox().inflate(30.0, 10.0, 30.0);
        Level world = WorldUtils.getBestWorld((Minecraft)mc);
        if (world == null) {
            return;
        }
        if (Configs.Generic.VILLAGER_OFFER_ENCHANTMENT_BOOKS.getBooleanValue()) {
            MerchantOffers offers;
            List<Villager> librarians = EntityUtils.getEntitiesByClass(mc, Villager.class, box, villager -> villager.getVillagerData().profession().is(VillagerProfession.LIBRARIAN));
            HashMap<Object2IntMap.Entry, Integer> lowestPrices = new HashMap<Object2IntMap.Entry, Integer>();
            if (Configs.Generic.VILLAGER_OFFER_LOWEST_PRICE_NEARBY.getBooleanValue()) {
                for (Villager librarian : librarians) {
                    offers = this.getTrades(world, librarian);
                    if (offers == null || offers.isEmpty()) continue;
                    for (MerchantOffer tradeOffer : offers) {
                        if (tradeOffer.getResult().getItem() != Items.ENCHANTED_BOOK || tradeOffer.getItemCostA().item().value() != Items.EMERALD) continue;
                        for (Object2IntMap.Entry entry : ((ItemEnchantments)tradeOffer.getResult().getOrDefault(DataComponents.STORED_ENCHANTMENTS, null)).entrySet()) {
                            int emeraldCost = tradeOffer.getItemCostA().count();
                            if (lowestPrices.containsKey(entry)) {
                                if (emeraldCost >= (Integer)lowestPrices.get(entry)) continue;
                                lowestPrices.put(entry, emeraldCost);
                                continue;
                            }
                            lowestPrices.put(entry, emeraldCost);
                        }
                    }
                }
            }
            for (Villager librarian : librarians) {
                offers = this.getTrades(world, librarian);
                if (offers == null || offers.isEmpty()) continue;
                ArrayList<String> overlay = new ArrayList<String>();
                for (MerchantOffer tradeOffer : offers) {
                    if (tradeOffer.getResult().getItem() != Items.ENCHANTED_BOOK) continue;
                    for (Object2IntMap.Entry entry : ((ItemEnchantments)tradeOffer.getResult().getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet()) {
                        StringBuilder sb = new StringBuilder();
                        if (((Enchantment)((Holder)entry.getKey()).value()).getMaxLevel() == entry.getIntValue()) {
                            sb.append(GuiBase.TXT_GOLD);
                        } else if (Configs.Generic.VILLAGER_OFFER_HIGHEST_LEVEL_ONLY.getBooleanValue()) continue;
                        sb.append(Enchantment.getFullname((Holder)((Holder)entry.getKey()), (int)entry.getIntValue()).getString());
                        sb.append(GuiBase.TXT_RST);
                        if (tradeOffer.getItemCostA().item().value() == Items.EMERALD) {
                            sb.append(" ");
                            int emeraldCost = tradeOffer.getItemCostA().count();
                            if (Configs.Generic.VILLAGER_OFFER_LOWEST_PRICE_NEARBY.getBooleanValue() && emeraldCost > lowestPrices.getOrDefault(entry, Integer.MAX_VALUE)) continue;
                            int lowest = 2 + 3 * entry.getIntValue();
                            int highest = 6 + 13 * entry.getIntValue();
                            if (((Holder)entry.getKey()).is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
                                lowest *= 2;
                                highest *= 2;
                            }
                            if ((double)emeraldCost > Mth.lerp((double)Configs.Generic.VILLAGER_OFFER_PRICE_THRESHOLD.getDoubleValue(), (double)lowest, (double)highest)) continue;
                            if ((double)emeraldCost < Mth.lerp((double)0.3333333333333333, (double)lowest, (double)highest)) {
                                sb.append(GuiBase.TXT_GREEN);
                            }
                            if ((double)emeraldCost > Mth.lerp((double)0.6666666666666666, (double)lowest, (double)highest)) {
                                sb.append(GuiBase.TXT_RED);
                            }
                            sb.append(emeraldCost);
                            if (Configs.Generic.VILLAGER_OFFER_PRICE_RANGE.getBooleanValue()) {
                                sb.append(' ').append('(').append(lowest).append('-').append(highest).append(')');
                            }
                            sb.append(GuiBase.TXT_RST);
                        }
                        overlay.add(sb.toString());
                    }
                }
                this.renderAtEntity(overlay, entity, (Entity)librarian);
            }
        }
        if (Configs.Generic.VILLAGER_CONVERSION_TICKS.getBooleanValue()) {
            List<ZombieVillager> zombieVillagers = EntityUtils.getEntitiesByClass(mc, ZombieVillager.class, box, e -> true);
            for (ZombieVillager villager2 : zombieVillagers) {
                int conversionTimer = this.getConversionTime(world, villager2);
                if (conversionTimer <= 0) continue;
                this.renderAtEntity(List.of(String.format("%ds", Math.round((float)conversionTimer / 20.0f))), entity, (Entity)villager2);
            }
        }
    }

    @Override
    public boolean hasData() {
        return false;
    }

    @Override
    public void render(Vec3 cameraPos, Minecraft mc, ProfilerFiller profiler) {
    }

    @Override
    public void reset() {
        super.reset();
    }

    private void renderAtEntity(List<String> texts, Entity entity, Entity targetEntity) {
        BlockPos pos;
        LivingEntity living;
        Optional jobSite;
        float delta = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
        Vec3 cameraPos = entity.getPosition(delta);
        Vec3 targetPos = targetEntity.getPosition(delta);
        double hypot = Mth.length((double)(cameraPos.x() - targetPos.x()), (double)(cameraPos.z() - targetPos.z()));
        double distance = 0.8;
        double x = targetPos.x() + (cameraPos.x() - targetPos.x()) / hypot * distance;
        double z = targetPos.z() + (cameraPos.z() - targetPos.z()) / hypot * distance;
        double y = targetPos.y() + 1.5 + 0.1 * (double)texts.size();
        if (targetEntity instanceof LivingEntity && (jobSite = (living = (LivingEntity)targetEntity).getBrain().getMemoryInternal(MemoryModuleType.JOB_SITE)) != null && jobSite.isPresent() && targetPos.distanceTo((pos = ((GlobalPos)jobSite.get()).pos()).getCenter()) < 1.7) {
            x = (double)pos.getX() + 0.5;
            z = (double)pos.getZ() + 0.5;
        }
        for (String line : texts) {
            RenderUtils.drawTextPlate(List.of(line), (double)x, (double)y, (double)z, (float)0.02f);
            y -= 0.2;
        }
    }
}

