/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererBlockGrid;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererHandheldBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererRandomTickableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererRegion;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import fi.dy.masa.minihud.renderer.OverlayRendererVillagerInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class RenderContainer {
    public static final RenderContainer INSTANCE = new RenderContainer();
    private final List<OverlayRendererBase> renderers = new ArrayList<OverlayRendererBase>();
    protected int countActive;

    private RenderContainer() {
        this.addRenderer(OverlayRendererBeaconRange.INSTANCE);
        this.addRenderer(OverlayRendererBiomeBorders.INSTANCE);
        this.addRenderer(OverlayRendererBlockGrid.INSTANCE);
        this.addRenderer(OverlayRendererConduitRange.INSTANCE);
        this.addRenderer(OverlayRendererLightLevel.INSTANCE);
        this.addRenderer(OverlayRendererHandheldBeaconRange.INSTANCE);
        this.addRenderer(OverlayRendererRandomTickableChunks.INSTANCE_FIXED);
        this.addRenderer(OverlayRendererRandomTickableChunks.INSTANCE_PLAYER);
        this.addRenderer(OverlayRendererRegion.INSTANCE);
        this.addRenderer(OverlayRendererSlimeChunks.INSTANCE);
        this.addRenderer(OverlayRendererSpawnableColumnHeights.INSTANCE);
        this.addRenderer(OverlayRendererSpawnChunks.INSTANCE_PLAYER);
        this.addRenderer(OverlayRendererSpawnChunks.INSTANCE_REAL);
        this.addRenderer(OverlayRendererStructures.INSTANCE);
        this.addRenderer(OverlayRendererVillagerInfo.INSTANCE);
    }

    public void addRenderer(OverlayRendererBase renderer) {
        this.renderers.add(renderer);
    }

    public void removeRenderer(OverlayRendererBase renderer) {
        this.renderers.remove(renderer);
    }

    public void render(Entity entity, Matrix4f posMatrix, Matrix4f projMatrix, Minecraft mc, Camera camera, Frustum frustum, ProfilerFiller profiler) {
        profiler.push("render_container");
        this.update(camera.getPosition(), entity, mc, profiler);
        this.draw(camera.getPosition(), profiler);
        profiler.pop();
    }

    protected void update(Vec3 cameraPos, Entity entity, Minecraft mc, ProfilerFiller profiler) {
        profiler.popPush("render_update");
        this.countActive = 0;
        for (OverlayRendererBase renderer : this.renderers) {
            profiler.push("update_" + renderer.getName());
            if (renderer.shouldRender(mc)) {
                if (renderer.needsUpdate(entity, mc)) {
                    renderer.lastUpdatePos = PositionUtils.getEntityBlockPos((Entity)entity);
                    renderer.update(cameraPos, entity, mc, profiler);
                    renderer.setUpdatePosition(cameraPos);
                }
                ++this.countActive;
            } else {
                renderer.reset();
            }
            profiler.pop();
        }
    }

    protected void draw(Vec3 cameraPos, ProfilerFiller profiler) {
        profiler.popPush("render_draw");
        if (this.countActive > 0) {
            Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
            for (IOverlayRenderer iOverlayRenderer : this.renderers) {
                profiler.push("draw_" + iOverlayRenderer.getName());
                if (iOverlayRenderer.hasData()) {
                    Vec3 updatePos = iOverlayRenderer.getUpdatePosition();
                    matrix4fstack.pushMatrix();
                    matrix4fstack.translate((float)(updatePos.x - cameraPos.x), (float)(updatePos.y - cameraPos.y), (float)(updatePos.z - cameraPos.z));
                    iOverlayRenderer.draw(cameraPos);
                    matrix4fstack.popMatrix();
                } else {
                    iOverlayRenderer.reset();
                }
                profiler.pop();
            }
        }
    }

    protected void reset() {
        for (OverlayRendererBase renderer : this.renderers) {
            renderer.reset();
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (OverlayRendererBase renderer : this.renderers) {
            String id = renderer.getSaveId();
            if (id.isEmpty()) continue;
            obj.add(id, (JsonElement)renderer.toJson());
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        for (OverlayRendererBase renderer : this.renderers) {
            String id = renderer.getSaveId();
            if (id.isEmpty() || !JsonUtils.hasObject((JsonObject)obj, (String)id)) continue;
            renderer.fromJson(obj.get(id).getAsJsonObject());
        }
    }
}

