/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.systems.ScissorState;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.mixin.render.IMixinAbstractTexture;
import fi.dy.masa.malilib.mixin.render.IMixinBufferBuilder;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.minihud.MiniHUD;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class RenderObjectVbo {
    private Supplier<String> name;
    private RenderPipeline shader;
    private GpuBuffer vertexBuffer;
    @Nullable
    private GpuBuffer indexBuffer;
    private RenderSystem.AutoStorageIndexBuffer shapeIndex;
    private VertexFormat.IndexType indexType;
    private ByteBufferBuilder alloc;
    private BufferBuilder builder;
    private VertexFormat format;
    private VertexFormat.Mode drawMode;
    private SimpleTexture texture;
    private AbstractTexture directTexture;
    @Nullable
    private MeshData.SortState sortState;
    private int textureId;
    private float[] offset;
    private float lineWidth;
    private int color;
    private boolean started;
    private boolean uploaded;
    private int indexCount;

    protected RenderObjectVbo(Supplier<String> name, RenderPipeline shader) {
        this.name = name;
        this.alloc = new ByteBufferBuilder(shader.getVertexFormat().getVertexSize() * 4);
        this.builder = new BufferBuilder(this.alloc, shader.getVertexFormatMode(), shader.getVertexFormat());
        this.shapeIndex = RenderSystem.getSequentialBuffer((VertexFormat.Mode)shader.getVertexFormatMode());
        this.indexType = this.shapeIndex.type();
        this.format = shader.getVertexFormat();
        this.drawMode = shader.getVertexFormatMode();
        this.shader = shader;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.sortState = null;
        this.indexCount = -1;
        this.textureId = -1;
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.lineWidth = 1.0f;
        this.started = true;
        this.uploaded = false;
    }

    public BufferBuilder start(Supplier<String> name, RenderPipeline shader) {
        this.reset();
        this.name = name;
        this.alloc = new ByteBufferBuilder(shader.getVertexFormat().getVertexSize() * 4);
        this.builder = new BufferBuilder(this.alloc, shader.getVertexFormatMode(), shader.getVertexFormat());
        this.shapeIndex = RenderSystem.getSequentialBuffer((VertexFormat.Mode)shader.getVertexFormatMode());
        this.indexType = this.shapeIndex.type();
        this.format = shader.getVertexFormat();
        this.drawMode = shader.getVertexFormatMode();
        this.shader = shader;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.sortState = null;
        this.indexCount = -1;
        this.textureId = -1;
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.lineWidth = 1.0f;
        this.started = true;
        this.uploaded = false;
        return this.builder;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected boolean isUploaded() {
        return this.uploaded;
    }

    public String getName() {
        return this.name.get();
    }

    protected BufferBuilder getBuilder() {
        return this.builder;
    }

    public VertexFormat getVertexFormat() {
        return this.format;
    }

    public VertexFormat.Mode getDrawMode() {
        return this.drawMode;
    }

    public VertexFormat getShaderFormat() {
        if (this.shader != null) {
            return this.shader.getVertexFormat();
        }
        return this.format;
    }

    public VertexFormat.Mode getShaderDrawMode() {
        if (this.shader != null) {
            return this.shader.getVertexFormatMode();
        }
        return this.drawMode;
    }

    protected RenderObjectVbo setBuilder(BufferBuilder builder) throws RuntimeException {
        this.ensureBuilding(builder);
        this.builder = builder;
        return this;
    }

    protected RenderObjectVbo lineWidth(float width) {
        this.lineWidth = Math.clamp(width, 0.0f, 25.0f);
        return this;
    }

    protected RenderObjectVbo offset(float[] value) {
        if (value.length != 3) {
            value = new float[]{0.0f, 0.0f, 0.0f};
        }
        this.offset[0] = value[0];
        this.offset[1] = value[1];
        this.offset[2] = value[2];
        return this;
    }

    protected RenderObjectVbo color(int color) {
        this.color = color;
        return this;
    }

    protected void upload() throws RuntimeException {
        this.upload(false);
    }

    protected void upload(boolean shouldResort) throws RuntimeException {
        block7: {
            this.ensureSafeNoShader();
            this.ensureBuilding(this.builder);
            try (MeshData meshData = this.builder.build();){
                if (meshData != null) {
                    this.upload(meshData, shouldResort);
                    break block7;
                }
                throw new RuntimeException("Empty Mesh Data!");
            }
        }
    }

    protected void upload(BufferBuilder builder) throws RuntimeException {
        this.upload(builder, false);
    }

    protected void upload(BufferBuilder builder, boolean shouldResort) throws RuntimeException {
        block7: {
            this.ensureSafeNoShader();
            this.ensureBuilding(builder);
            this.builder = builder;
            try (MeshData meshData = this.builder.build();){
                if (meshData != null) {
                    this.upload(meshData, shouldResort);
                    break block7;
                }
                throw new RuntimeException("Empty Mesh Data!");
            }
        }
    }

    public void upload(MeshData meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoShader();
        if (RenderSystem.isOnRenderThread() && meshData != null) {
            int expectedSize = meshData.vertexBuffer().remaining();
            if (this.vertexBuffer != null) {
                this.vertexBuffer.close();
            }
            if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            if (this.vertexBuffer == null) {
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " VertexBuffer", 40, expectedSize);
            } else if (this.vertexBuffer.size() < expectedSize) {
                this.vertexBuffer.close();
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " VertexBuffer", 40, expectedSize);
            }
            CommandEncoder encoder = RenderSystem.getDevice().createCommandEncoder();
            if (this.vertexBuffer.isClosed()) {
                throw new RuntimeException("Vertex Buffer is closed!");
            }
            encoder.writeToBuffer(this.vertexBuffer.slice(), meshData.vertexBuffer());
            if (shouldResort && meshData.indexBuffer() != null) {
                if (this.indexBuffer != null && this.indexBuffer.size() >= meshData.indexBuffer().remaining()) {
                    if (!this.indexBuffer.isClosed()) {
                        encoder.writeToBuffer(this.indexBuffer.slice(), meshData.indexBuffer());
                    }
                } else {
                    if (this.indexBuffer != null) {
                        this.indexBuffer.close();
                    }
                    this.indexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " IndexBuffer", 72, meshData.indexBuffer());
                }
            } else if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            this.indexCount = meshData.drawState().indexCount();
            this.indexType = meshData.drawState().indexType();
            this.uploaded = true;
        }
    }

    protected VertexSorting createVertexSorter(float x, float y, float z) {
        return VertexSorting.byDistance((float)x, (float)y, (float)z);
    }

    public VertexSorting createVertexSorter(Vec3 pos) {
        return this.createVertexSorter(pos, BlockPos.ZERO);
    }

    protected VertexSorting createVertexSorter(Camera camera) {
        return this.createVertexSorter(camera.getPosition(), BlockPos.ZERO);
    }

    protected VertexSorting createVertexSorter(Camera camera, BlockPos origin) {
        return this.createVertexSorter(camera.getPosition(), origin);
    }

    protected VertexSorting createVertexSorter(Vec3 pos, BlockPos origin) {
        return VertexSorting.byDistance((float)((float)(pos.x - (double)origin.getX())), (float)((float)(pos.y - (double)origin.getY())), (float)((float)(pos.z - (double)origin.getZ())));
    }

    public void startResorting(@Nonnull MeshData meshData, @Nonnull VertexSorting sorter) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            this.sortState = meshData.sortQuads(this.alloc, sorter);
            this.resortTranslucent(sorter);
        }
    }

    protected boolean shouldResort() {
        return this.sortState != null;
    }

    protected void resortTranslucent(@Nonnull VertexSorting sorter) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            if (this.sortState == null) {
                throw new RuntimeException("Sort State is empty!");
            }
            ByteBufferBuilder.Result result = this.sortState.buildSortedIndexBuffer(this.alloc, sorter);
            if (result != null) {
                this.uploadIndex(result);
                result.close();
            } else {
                throw new RuntimeException("Unable to Store Sorting Data in Result Buffer!");
            }
        }
    }

    protected void uploadIndex(@Nonnull ByteBufferBuilder.Result buffer) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            GpuDevice device = RenderSystem.tryGetDevice();
            if (device == null) {
                MaLiLib.LOGGER.warn("RenderContext#uploadIndex: GpuDevice is null for renderer '{}'", (Object)this.name.get());
                return;
            }
            if (this.indexBuffer == null) {
                this.indexBuffer = device.createBuffer(() -> this.name.get() + " IndexBuffer", 72, buffer.byteBuffer());
            } else if (!this.indexBuffer.isClosed()) {
                device.createCommandEncoder().writeToBuffer(this.indexBuffer.slice(), buffer.byteBuffer());
            } else {
                throw new RuntimeException("Index Buffer is closed!");
            }
        }
    }

    protected void bindTexture(ResourceLocation id, int textureId, int width, int height) throws Exception {
        this.ensureSafeNoBuffer();
        if (textureId < 0 || textureId > 12) {
            throw new RuntimeException("Invalid textureId of: " + textureId + " for texture: " + id.toString());
        }
        try {
            while (!this.isTextureValid(width, height)) {
                this.texture = (SimpleTexture)RenderUtils.tex().getTexture(id);
                if (!this.isTextureValid(width, height)) continue;
                if (this.texture != null) {
                    this.texture.setFilter(false, false);
                    RenderSystem.setShaderTexture((int)textureId, (GpuTextureView)this.texture.getTextureView());
                }
                break;
            }
        }
        catch (Exception err) {
            throw new RuntimeException("Exception reading Texture [" + id.toString() + "]: " + err.getMessage());
        }
        if (this.texture != null) {
            this.textureId = textureId;
            RenderSystem.setShaderTexture((int)this.textureId, (GpuTextureView)this.texture.getTextureView());
            return;
        }
        MiniHUD.LOGGER.error("bindTexture: Error uploading texture [{}]", (Object)id.toString());
        if (this.texture != null) {
            this.texture.close();
        }
        this.texture = null;
        this.textureId = -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTextureValid(int width, int height) {
        if (this.texture == null) {
            return false;
        }
        try (TextureContents content = this.texture.loadContents(RenderUtils.mc().getResourceManager());){
            NativeImage image = content.image();
            if (image == null || image.getWidth() != width || image.getHeight() != height) {
                this.texture.close();
                this.texture = null;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            this.texture.close();
            this.texture = null;
            return false;
        }
        if (((IMixinAbstractTexture)this.texture).malilib_getGlTextureView() != null) {
            if (!this.texture.getTextureView().isClosed()) return true;
        }
        this.texture.close();
        this.texture = null;
        return false;
    }

    public boolean bindTextureDirect(@Nonnull AbstractTexture texture, int textureId) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (textureId < 0 || textureId > 12) {
            throw new RuntimeException("Invalid textureId of: " + textureId);
        }
        this.directTexture = texture;
        this.textureId = textureId;
        if (((IMixinAbstractTexture)this.directTexture).malilib_getGlTextureView() == null || this.directTexture.getTextureView().isClosed()) {
            this.directTexture.close();
            this.directTexture = null;
            return false;
        }
        RenderSystem.setShaderTexture((int)this.textureId, (GpuTextureView)this.directTexture.getTextureView());
        return true;
    }

    protected void unbindTexture(@Nullable ResourceLocation id) {
        if (id != null) {
            RenderUtils.tex().release(id);
        }
        if (this.texture != null) {
            RenderUtils.tex().release(this.texture.resourceId());
        }
        RenderSystem.setShaderTexture((int)0, null);
    }

    protected void draw() throws RuntimeException {
        this.draw(false);
    }

    protected void draw(boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.ensureBuilding(this.builder);
        MeshData meshData = this.builder.build();
        if (meshData != null) {
            this.draw(meshData, shouldResort);
            meshData.close();
        }
    }

    protected void draw(MeshData meshData) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, false, false, false, false, false);
    }

    protected void draw(MeshData meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, false, false, false, false);
    }

    protected void draw(MeshData meshData, boolean shouldResort, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, false, setLineWidth, false, false);
    }

    protected void draw(MeshData meshData, boolean shouldResort, boolean setColor, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, setColor, setLineWidth, false, false);
    }

    protected void draw(MeshData meshData, boolean shouldResort, boolean setColor, boolean setLineWidth, boolean useOffset) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, setColor, setLineWidth, useOffset, false);
    }

    protected void draw(MeshData meshData, boolean shouldResort, boolean setColor, boolean setLineWidth, boolean useOffset, boolean useLightmapTex) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, setColor, setLineWidth, useOffset, useLightmapTex);
    }

    protected void draw(@Nullable RenderTarget otherFb, MeshData meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(otherFb, meshData, shouldResort, false, false, false, false);
    }

    protected void draw(@Nullable RenderTarget otherFb, MeshData meshData, boolean shouldResort, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(otherFb, meshData, shouldResort, false, setLineWidth, false, false);
    }

    protected void draw(@Nullable RenderTarget otherFb, MeshData meshData, boolean shouldResort, boolean setColor, boolean setLineWidth, boolean useOffset, boolean useLightmapTex) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            if (meshData == null) {
                this.indexCount = 0;
            } else if (this.indexCount < 1) {
                this.upload(meshData, shouldResort);
            }
            if (this.indexCount > 0) {
                float[] rgba = new float[]{ARGB.redFloat((int)this.color), ARGB.greenFloat((int)this.color), ARGB.blueFloat((int)this.color), ARGB.alphaFloat((int)this.color)};
                this.drawInternal(otherFb, rgba, setColor, setLineWidth, useOffset, useLightmapTex);
            }
        }
    }

    protected void drawPost() throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(null, false, false, false, false);
    }

    protected void drawPost(boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(null, false, setLineWidth, false, false);
    }

    protected void drawPost(boolean setColor, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(null, setColor, setLineWidth, false, false);
    }

    protected void drawPost(@Nullable RenderTarget otherFb, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(otherFb, false, setLineWidth, false, false);
    }

    protected void drawPost(@Nullable RenderTarget otherFb, boolean setColor, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(otherFb, setColor, setLineWidth, false, false);
    }

    protected void drawPost(@Nullable RenderTarget otherFb, boolean setColor, boolean setLineWidth, boolean useOffset, boolean useLightmapTex) throws RuntimeException {
        this.ensureSafeNoTexture();
        if (this.indexCount > 0) {
            float[] rgba = new float[]{ARGB.redFloat((int)this.color), ARGB.greenFloat((int)this.color), ARGB.blueFloat((int)this.color), ARGB.alphaFloat((int)this.color)};
            this.drawInternal(otherFb, rgba, setColor, useOffset, setLineWidth, useLightmapTex);
        }
    }

    private void drawInternal(@Nullable RenderTarget otherFb, float[] rgba, boolean setColor, boolean setLineWidth, boolean useOffset, boolean useLightmapTex) throws RuntimeException {
        this.ensureSafeNoTexture();
        if (RenderSystem.isOnRenderThread()) {
            GpuTextureView texture2;
            GpuTextureView texture1;
            GpuDevice device;
            Vector4f colorMod = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
            Vector3f modelOffset = new Vector3f();
            Matrix4f texMatrix = new Matrix4f();
            float line = 0.0f;
            if (setColor) {
                colorMod.set(rgba);
            }
            if (setLineWidth) {
                float f = line = this.lineWidth > 0.0f ? this.lineWidth : RenderSystem.getShaderLineWidth();
            }
            if (useOffset) {
                modelOffset.set(this.offset);
            }
            if ((device = RenderSystem.getDevice()) == null) {
                MiniHUD.LOGGER.warn("RenderContext#drawInternal: GpuDevice is null for renderer '{}'", (Object)this.name.get());
                return;
            }
            RenderTarget mainFb = RenderUtils.fb();
            if (otherFb != null) {
                texture1 = otherFb.getColorTextureView();
                texture2 = otherFb.useDepth ? otherFb.getDepthTextureView() : null;
            } else {
                texture1 = mainFb.getColorTextureView();
                texture2 = mainFb.useDepth ? mainFb.getDepthTextureView() : null;
            }
            GpuBuffer indexBuffer = this.shapeIndex.getBuffer(this.indexCount);
            GpuBufferSlice gpuSlice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)colorMod, (Vector3fc)modelOffset, (Matrix4fc)texMatrix, line);
            try (RenderPass pass = device.createCommandEncoder().createRenderPass(this.name, texture1, OptionalInt.empty(), texture2, OptionalDouble.empty());){
                pass.setPipeline(this.shader);
                ScissorState scissorState = RenderSystem.getScissorStateForRenderTypeDraws();
                if (scissorState.enabled()) {
                    pass.enableScissor(scissorState.x(), scissorState.y(), scissorState.width(), scissorState.height());
                }
                RenderSystem.bindDefaultUniforms((RenderPass)pass);
                pass.setUniform("DynamicTransforms", gpuSlice);
                if (this.indexBuffer == null) {
                    pass.setIndexBuffer(indexBuffer, this.shapeIndex.type());
                } else {
                    pass.setIndexBuffer(this.indexBuffer, this.indexType);
                }
                pass.setVertexBuffer(0, this.vertexBuffer);
                if (this.textureId > -1 && this.textureId < 12) {
                    if (this.texture != null) {
                        pass.bindSampler("Sampler" + this.textureId, this.texture.getTextureView());
                    } else if (this.directTexture != null) {
                        pass.bindSampler("Sampler" + this.textureId, this.directTexture.getTextureView());
                    }
                }
                if (useLightmapTex) {
                    pass.bindSampler("Sampler2", RenderUtils.lightmap().getTextureView());
                }
                pass.drawIndexed(0, 0, this.indexCount, 1);
            }
        }
    }

    private void ensureBuilding(BufferBuilder builder) throws RuntimeException {
        if (!((IMixinBufferBuilder)builder).malilib_isBuilding()) {
            throw new RuntimeException("Buffer Builder is not building!");
        }
        if (((IMixinBufferBuilder)builder).malilib_getVertexCount() == 0) {
            throw new RuntimeException("Buffer Builder vertices are zero!");
        }
        if (((IMixinBufferBuilder)builder).malilib_getVertexPointer() == -1L) {
            throw new RuntimeException("Buffer Builder has no vertices!");
        }
    }

    private void ensureSafeNoShader() throws RuntimeException {
        if (!this.started) {
            throw new RuntimeException("Context not started!");
        }
        if (this.alloc == null) {
            throw new RuntimeException("Allocator not valid!");
        }
        if (this.builder == null) {
            throw new RuntimeException("Buffer Builder not valid!");
        }
        if (this.name.get().isEmpty()) {
            this.name = () -> "RenderObjectVbo";
        }
    }

    private void ensureSafeNoBuffer() throws RuntimeException {
        this.ensureSafeNoShader();
        if (this.shader == null) {
            throw new RuntimeException("Shader Pipeline not valid!");
        }
    }

    private void ensureSafeNoTexture() throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (this.vertexBuffer == null) {
            throw new RuntimeException("GpuBuffer not uploaded!");
        }
    }

    private void ensureSafe() {
        this.ensureSafeNoTexture();
        if (this.texture == null) {
            throw new RuntimeException("A Texture Object is expected to be bound");
        }
    }

    protected void reset() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
        if (this.sortState != null) {
            this.sortState = null;
        }
        if (this.builder != null) {
            if (((IMixinBufferBuilder)this.builder).malilib_isBuilding() && ((IMixinBufferBuilder)this.builder).malilib_getVertexCount() != 0) {
                try {
                    MeshData meshData = this.builder.build();
                    if (meshData != null) {
                        meshData.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.builder = null;
        }
        if (this.alloc != null) {
            this.alloc.close();
            this.alloc = null;
        }
        this.indexCount = -1;
        this.indexType = null;
        this.textureId = -1;
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.lineWidth = 1.0f;
        this.started = false;
        this.uploaded = false;
    }

    protected void close() {
        if (this.texture != null) {
            this.unbindTexture(this.texture.resourceId());
            this.texture.close();
            this.texture = null;
        }
        if (this.directTexture != null) {
            this.directTexture.close();
            this.directTexture = null;
        }
        this.reset();
    }
}

