/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.game.RayTraceUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.InventoryUtils;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RenderUtils {
    public static List<AABB> calculateBoxes(BlockPos posStart, BlockPos posEnd) {
        double minZ;
        double maxZ;
        double maxX;
        double minX;
        Entity entity = EntityUtils.getCameraEntity();
        if (entity == null) {
            return List.of();
        }
        int boxMinX = Math.min(posStart.getX(), posEnd.getX());
        int boxMinZ = Math.min(posStart.getZ(), posEnd.getZ());
        int boxMaxX = Math.max(posStart.getX(), posEnd.getX());
        int boxMaxZ = Math.max(posStart.getZ(), posEnd.getZ());
        int centerX = (int)Math.floor(entity.getX());
        int centerZ = (int)Math.floor(entity.getZ());
        int maxDist = (Integer)Minecraft.getInstance().options.renderDistance().get() * 32;
        int rangeMinX = centerX - maxDist;
        int rangeMinZ = centerZ - maxDist;
        int rangeMaxX = centerX + maxDist;
        int rangeMaxZ = centerZ + maxDist;
        double minY = Math.min(posStart.getY(), posEnd.getY());
        double maxY = Math.max(posStart.getY(), posEnd.getY()) + 1;
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        if (rangeMinX <= boxMaxX && rangeMaxX >= boxMinX) {
            minX = Math.max(boxMinX, rangeMinX);
            maxX = Math.min(boxMaxX, rangeMaxX) + 1;
            if (rangeMinZ <= boxMinZ && rangeMaxZ >= boxMinZ) {
                minZ = maxZ = (double)boxMinZ;
                boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
            if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMaxZ) {
                minZ = maxZ = (double)(boxMaxZ + 1);
                boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMinZ) {
            minZ = Math.max(boxMinZ, rangeMinZ);
            maxZ = Math.min(boxMaxZ, rangeMaxZ) + 1;
            if (rangeMinX <= boxMinX && rangeMaxX >= boxMinX) {
                minX = maxX = (double)boxMinX;
                boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
            if (rangeMinX <= boxMaxX && rangeMaxX >= boxMaxX) {
                minX = maxX = (double)(boxMaxX + 1);
                boxes.add(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
            }
        }
        return boxes;
    }

    public static void renderWallQuads(AABB box, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads) {
        double cx = cameraPos.x;
        double cy = cameraPos.y;
        double cz = cameraPos.z;
        bufferQuads.addVertex((float)(box.minX - cx), (float)(box.maxY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, color.a);
        bufferQuads.addVertex((float)(box.minX - cx), (float)(box.minY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, color.a);
        bufferQuads.addVertex((float)(box.maxX - cx), (float)(box.minY - cy), (float)(box.maxZ - cz)).setColor(color.r, color.g, color.b, color.a);
        bufferQuads.addVertex((float)(box.maxX - cx), (float)(box.maxY - cy), (float)(box.maxZ - cz)).setColor(color.r, color.g, color.b, color.a);
    }

    public static void renderWallOutlines(AABB box, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, Vec3 cameraPos, Color4f color, BufferBuilder bufferLines) {
        block4: {
            double lineX;
            double cz;
            double cy;
            double cx;
            block5: {
                double lineZ;
                cx = cameraPos.x;
                cy = cameraPos.y;
                cz = cameraPos.z;
                if (lineIntervalV > 0.0) {
                    double lineY;
                    double d = lineY = alignLinesToModulo ? RenderUtils.roundUp(box.minY, lineIntervalV) : box.minY;
                    while (lineY <= box.maxY) {
                        bufferLines.addVertex((float)(box.minX - cx), (float)(lineY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                        bufferLines.addVertex((float)(box.maxX - cx), (float)(lineY - cy), (float)(box.maxZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                        lineY += lineIntervalV;
                    }
                }
                if (!(lineIntervalH > 0.0)) break block4;
                if (box.minX != box.maxX) break block5;
                double d = lineZ = alignLinesToModulo ? RenderUtils.roundUp(box.minZ, lineIntervalH) : box.minZ;
                while (lineZ <= box.maxZ) {
                    bufferLines.addVertex((float)(box.minX - cx), (float)(box.minY - cy), (float)(lineZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                    bufferLines.addVertex((float)(box.minX - cx), (float)(box.maxY - cy), (float)(lineZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                    lineZ += lineIntervalH;
                }
                break block4;
            }
            if (box.minZ != box.maxZ) break block4;
            double d = lineX = alignLinesToModulo ? RenderUtils.roundUp(box.minX, lineIntervalH) : box.minX;
            while (lineX <= box.maxX) {
                bufferLines.addVertex((float)(lineX - cx), (float)(box.minY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                bufferLines.addVertex((float)(lineX - cx), (float)(box.maxY - cy), (float)(box.minZ - cz)).setColor(color.r, color.g, color.b, 1.0f);
                lineX += lineIntervalH;
            }
        }
    }

    public static void drawBoxNoOutlines(IntBoundingBox bb, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads) {
        float minX = (float)((double)bb.minX - cameraPos.x);
        float minY = (float)((double)bb.minY - cameraPos.y);
        float minZ = (float)((double)bb.minZ - cameraPos.z);
        float maxX = (float)((double)(bb.maxX + 1) - cameraPos.x);
        float maxY = (float)((double)(bb.maxY + 1) - cameraPos.y);
        float maxZ = (float)((double)(bb.maxZ + 1) - cameraPos.z);
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (BufferBuilder)bufferQuads);
    }

    public static void drawBlockSpaceSideBatchedQuads(long posLong, Direction side, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        int x = BlockPos.getX((long)posLong);
        int y = BlockPos.getY((long)posLong);
        int z = BlockPos.getZ((long)posLong);
        float offsetX = (float)((double)x - cameraPos.x);
        float offsetY = (float)((double)y - cameraPos.y);
        float offsetZ = (float)((double)z - cameraPos.z);
        float minX = (float)((double)offsetX - expand);
        float minY = (float)((double)offsetY - expand);
        float minZ = (float)((double)offsetZ - expand);
        float maxX = (float)((double)offsetX + expand + 1.0);
        float maxY = (float)((double)offsetY + expand + 1.0);
        float maxZ = (float)((double)offsetZ + expand + 1.0);
        switch (side) {
            case DOWN: {
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case UP: {
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case NORTH: {
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case SOUTH: {
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case WEST: {
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case EAST: {
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void drawBlockSpaceSideBatchedLines(long posLong, Direction side, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        int x = BlockPos.getX((long)posLong);
        int y = BlockPos.getY((long)posLong);
        int z = BlockPos.getZ((long)posLong);
        float offsetX = (float)((double)x - cameraPos.x);
        float offsetY = (float)((double)y - cameraPos.y);
        float offsetZ = (float)((double)z - cameraPos.z);
        float minX = (float)((double)offsetX - expand);
        float minY = (float)((double)offsetY - expand);
        float minZ = (float)((double)offsetZ - expand);
        float maxX = (float)((double)offsetX + expand + 1.0);
        float maxY = (float)((double)offsetY + expand + 1.0);
        float maxZ = (float)((double)offsetZ + expand + 1.0);
        switch (side) {
            case DOWN: {
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case UP: {
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case NORTH: {
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case SOUTH: {
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case WEST: {
                buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case EAST: {
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void renderCircleBlockOutlines(LongOpenHashSet positions, Direction[] sides, SphereUtils.RingPositionTest test, ShapeRenderType renderType, LayerRange range, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        boolean full = renderType == ShapeRenderType.FULL_BLOCK;
        boolean outer = renderType == ShapeRenderType.OUTER_EDGE;
        boolean inner = renderType == ShapeRenderType.INNER_EDGE;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (Direction side : sides) {
                long adjPosLong = BlockPos.offset((long)posLong, (Direction)side);
                if (positions.contains(adjPosLong)) continue;
                boolean render = full;
                if (!full) {
                    int adjX = BlockPos.getX((long)adjPosLong);
                    int adjY = BlockPos.getY((long)adjPosLong);
                    int adjZ = BlockPos.getZ((long)adjPosLong);
                    boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
                    boolean bl = render = outer && !onOrIn || inner && onOrIn;
                }
                if (!render) continue;
                RenderUtils.drawBlockSpaceSideBatchedLines(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderCircleBlockPositions(LongOpenHashSet positions, Direction[] sides, SphereUtils.RingPositionTest test, ShapeRenderType renderType, LayerRange range, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        boolean full = renderType == ShapeRenderType.FULL_BLOCK;
        boolean outer = renderType == ShapeRenderType.OUTER_EDGE;
        boolean inner = renderType == ShapeRenderType.INNER_EDGE;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (Direction side : sides) {
                long adjPosLong = BlockPos.offset((long)posLong, (Direction)side);
                if (positions.contains(adjPosLong)) continue;
                boolean render = full;
                if (!full) {
                    int adjX = BlockPos.getX((long)adjPosLong);
                    int adjY = BlockPos.getY((long)adjPosLong);
                    int adjZ = BlockPos.getZ((long)adjPosLong);
                    boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
                    boolean bl = render = outer && !onOrIn || inner && onOrIn;
                }
                if (!render) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderBlockPositions(LongOpenHashSet positions, LayerRange range, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (Direction side : PositionUtils.ALL_DIRECTIONS) {
                long adjPosLong = BlockPos.offset((long)posLong, (Direction)side);
                if (positions.contains(adjPosLong)) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderBlockPositionOutlines(LongOpenHashSet positions, LayerRange range, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (Direction side : PositionUtils.ALL_DIRECTIONS) {
                long adjPosLong = BlockPos.offset((long)posLong, (Direction)side);
                if (positions.contains(adjPosLong)) continue;
                RenderUtils.drawBlockSpaceSideBatchedLines(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderQuads(Collection<SideQuad> quads, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        for (SideQuad quad : quads) {
            RenderUtils.renderInsetQuad(quad.startPos(), quad.width(), quad.height(), quad.side(), -expand, color, cameraPos, buffer);
        }
    }

    public static void renderInsetQuad(Vec3i minPos, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        RenderUtils.renderInsetQuad(minPos.getX(), minPos.getY(), minPos.getZ(), width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(long minPos, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        int x = BlockPos.getX((long)minPos);
        int y = BlockPos.getY((long)minPos);
        int z = BlockPos.getZ((long)minPos);
        RenderUtils.renderInsetQuad(x, y, z, width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(int x, int y, int z, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        float minX = (float)((double)x - cameraPos.x);
        float minY = (float)((double)y - cameraPos.y);
        float minZ = (float)((double)z - cameraPos.z);
        float maxX = minX;
        float maxY = minY;
        float maxZ = minZ;
        if (side.getAxis() == Direction.Axis.Z) {
            maxX += (float)width;
            maxY += (float)height;
        } else if (side.getAxis() == Direction.Axis.X) {
            maxY += (float)height;
            maxZ += (float)width;
        } else if (side.getAxis() == Direction.Axis.Y) {
            maxX += (float)width;
            maxZ += (float)height;
        }
        switch (side) {
            case WEST: {
                buffer.addVertex(minX += (float)inset, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case EAST: {
                buffer.addVertex(maxX += (float)(1.0 - inset), minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case NORTH: {
                buffer.addVertex(minX, minY, minZ += (float)inset).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case SOUTH: {
                buffer.addVertex(minX, minY, maxZ += (float)(1.0 - inset)).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case DOWN: {
                buffer.addVertex(minX, minY += (float)inset, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case UP: {
                buffer.addVertex(minX, maxY += (float)(1.0 - inset), minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void renderQuadLines(Collection<SideQuad> quads, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        for (SideQuad quad : quads) {
            RenderUtils.renderInsetQuadLines(quad.startPos(), quad.width(), quad.height(), quad.side(), -expand, color, cameraPos, buffer);
        }
    }

    public static void renderInsetQuadLines(Vec3i minPos, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        RenderUtils.renderInsetQuadLines(minPos.getX(), minPos.getY(), minPos.getZ(), width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuadLines(long minPos, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        int x = BlockPos.getX((long)minPos);
        int y = BlockPos.getY((long)minPos);
        int z = BlockPos.getZ((long)minPos);
        RenderUtils.renderInsetQuadLines(x, y, z, width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuadLines(int x, int y, int z, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        float minX = (float)((double)x - cameraPos.x);
        float minY = (float)((double)y - cameraPos.y);
        float minZ = (float)((double)z - cameraPos.z);
        float maxX = minX;
        float maxY = minY;
        float maxZ = minZ;
        if (side.getAxis() == Direction.Axis.Z) {
            maxX += (float)width;
            maxY += (float)height;
        } else if (side.getAxis() == Direction.Axis.X) {
            maxY += (float)height;
            maxZ += (float)width;
        } else if (side.getAxis() == Direction.Axis.Y) {
            maxX += (float)width;
            maxZ += (float)height;
        }
        switch (side) {
            case WEST: {
                buffer.addVertex(minX += (float)inset, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case EAST: {
                buffer.addVertex(maxX += (float)(1.0 - inset), minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case NORTH: {
                buffer.addVertex(minX, minY, minZ += (float)inset).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case SOUTH: {
                buffer.addVertex(minX, minY, maxZ += (float)(1.0 - inset)).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case DOWN: {
                buffer.addVertex(minX, minY += (float)inset, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, minY, minZ).setColor(color.r, color.g, color.b, color.a);
                break;
            }
            case UP: {
                buffer.addVertex(minX, maxY += (float)(1.0 - inset), minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, minZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(maxX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
                buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, color.a);
            }
        }
    }

    public static void renderBiomeBorderLines(Vec3i minPos, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        float minX = (float)((double)minPos.getX() - cameraPos.x);
        float minY = (float)((double)minPos.getY() - cameraPos.y);
        float minZ = (float)((double)minPos.getZ() - cameraPos.z);
        switch (side) {
            case WEST: {
                minX += (float)inset;
                break;
            }
            case EAST: {
                minX += (float)(1.0 - inset);
                break;
            }
            case NORTH: {
                minZ += (float)inset;
                break;
            }
            case SOUTH: {
                minZ += (float)(1.0 - inset);
                break;
            }
            case DOWN: {
                minY += (float)inset;
                break;
            }
            case UP: {
                minY += (float)(1.0 - inset);
            }
        }
        float maxX = minX;
        float maxY = minY;
        float maxZ = minZ;
        if (side.getAxis() == Direction.Axis.Z) {
            maxX += (float)width;
            maxY += (float)height;
        } else if (side.getAxis() == Direction.Axis.X) {
            maxY += (float)height;
            maxZ += (float)width;
        } else if (side.getAxis() == Direction.Axis.Y) {
            maxX += (float)width;
            maxZ += (float)height;
        }
        if (side.getAxis() == Direction.Axis.Y) {
            buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, 1.0f);
            buffer.addVertex(minX, maxY, maxZ).setColor(color.r, color.g, color.b, 1.0f);
            float z = minZ;
            while ((double)z < (double)maxZ + 0.5) {
                buffer.addVertex(minX, minY, z).setColor(color.r, color.g, color.b, 1.0f);
                buffer.addVertex(maxX, maxY, z).setColor(color.r, color.g, color.b, 1.0f);
                z += 1.0f;
            }
        } else {
            buffer.addVertex(minX, minY, minZ).setColor(color.r, color.g, color.b, 1.0f);
            buffer.addVertex(minX, maxY, minZ).setColor(color.r, color.g, color.b, 1.0f);
            float y = minY;
            while ((double)y < (double)maxY + 0.5) {
                buffer.addVertex(minX, y, minZ).setColor(color.r, color.g, color.b, 1.0f);
                buffer.addVertex(maxX, y, maxZ).setColor(color.r, color.g, color.b, 1.0f);
                y += 1.0f;
            }
        }
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }

    public static void drawBoxAllSidesBatchedQuads(AABB bb, Color4f color, BufferBuilder buffer) {
        float minX = (float)bb.minX;
        float minY = (float)bb.minY;
        float minZ = (float)bb.minZ;
        float maxX = (float)bb.maxX;
        float maxY = (float)bb.maxY;
        float maxZ = (float)bb.maxZ;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    public static void drawBoxAllEdgesBatchedLines(AABB bb, Color4f color, BufferBuilder buffer) {
        float minX = (float)bb.minX;
        float minY = (float)bb.minY;
        float minZ = (float)bb.minZ;
        float maxX = (float)bb.maxX;
        float maxY = (float)bb.maxY;
        float maxZ = (float)bb.maxZ;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }

    @Deprecated
    public static void renderInventoryOverlay(Minecraft mc, GuiGraphics drawContext) {
        Player serverPlayer;
        Level world = WorldUtils.getBestWorld((Minecraft)mc);
        Entity cameraEntity = EntityUtils.getCameraEntity();
        if (mc.player == null || world == null || cameraEntity == null) {
            return;
        }
        if (cameraEntity == mc.player && world instanceof ServerLevel && (serverPlayer = world.getPlayerByUUID(mc.player.getUUID())) != null) {
            cameraEntity = serverPlayer;
        }
        HitResult trace = RayTraceUtils.getRayTraceFromEntity((Level)cameraEntity.level(), (Entity)cameraEntity, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = null;
        Container inv = null;
        ShulkerBoxBlock shulkerBoxBlock = null;
        CrafterBlock crafterBlock = null;
        LivingEntity entityLivingBase = null;
        if (trace.getType() == HitResult.Type.BLOCK) {
            pos = ((BlockHitResult)trace).getBlockPos();
            Block blockTmp = world.getBlockState(pos).getBlock();
            if (blockTmp instanceof ShulkerBoxBlock) {
                shulkerBoxBlock = (ShulkerBoxBlock)blockTmp;
            } else if (blockTmp instanceof CrafterBlock) {
                crafterBlock = (CrafterBlock)blockTmp;
            }
            inv = InventoryUtils.getInventory(world, pos);
        } else if (trace.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)trace).getEntity();
            if (entity.level().isClientSide() && Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue()) {
                EntitiesDataManager.getInstance().requestEntity(world, entity.getId());
            }
            if (entity instanceof LivingEntity) {
                entityLivingBase = (LivingEntity)entity;
            }
            if (entity instanceof Container) {
                inv = (Container)entity;
            } else if (entity instanceof Villager) {
                inv = ((Villager)entity).getInventory();
            } else if (entity instanceof AbstractHorse) {
                inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
            }
        }
        boolean isWolf = entityLivingBase instanceof Wolf;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        if (inv != null && inv.getContainerSize() > 0) {
            CrafterBlockEntity cbe;
            boolean isHorse = entityLivingBase instanceof AbstractHorse;
            int totalSlots = isHorse ? inv.getContainerSize() - 1 : inv.getContainerSize();
            int firstSlot = isHorse ? 1 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof Villager ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getInventoryType((Container)inv);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            Set lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if (crafterBlock != null && pos != null && (cbe = (CrafterBlockEntity)world.getChunkAt(pos).getBlockEntity(pos)) != null) {
                lockedSlots = BlockUtils.getDisabledSlots((CrafterBlockEntity)cbe);
            }
            fi.dy.masa.malilib.render.RenderUtils.setShulkerboxBackgroundTintColor((ShulkerBoxBlock)shulkerBoxBlock, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            if (isHorse) {
                SimpleContainer horseInv = new SimpleContainer(2);
                ItemStack horseArmor = ((AbstractHorse)entityLivingBase).getBodyArmorItem();
                horseInv.setItem(0, horseArmor != null && !horseArmor.isEmpty() ? horseArmor : ItemStack.EMPTY);
                horseInv.setItem(1, inv.getItem(0));
                InventoryOverlay.renderInventoryBackground((GuiGraphics)drawContext, (InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (Minecraft)mc);
                if (type == InventoryOverlay.InventoryRenderType.LLAMA) {
                    InventoryOverlay.renderLlamaArmorBackgroundSlots((GuiGraphics)drawContext, (Container)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY));
                } else {
                    InventoryOverlay.renderHorseArmorBackgroundSlots((GuiGraphics)drawContext, (Container)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY));
                }
                InventoryOverlay.renderInventoryStacks((GuiGraphics)drawContext, (InventoryOverlay.InventoryRenderType)type, (Container)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (Minecraft)mc);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground((GuiGraphics)drawContext, (InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)totalSlots, (Minecraft)mc);
                if (type == InventoryOverlay.InventoryRenderType.BREWING_STAND) {
                    InventoryOverlay.renderBrewerBackgroundSlots((GuiGraphics)drawContext, (Container)inv, (int)xInv, (int)yInv);
                }
                InventoryOverlay.renderInventoryStacks((GuiGraphics)drawContext, (InventoryOverlay.InventoryRenderType)type, (Container)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)firstSlot, (int)totalSlots, lockedSlots, (Minecraft)mc);
            }
        }
        if (isWolf) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.HORSE;
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)2);
            int rows = (int)Math.ceil(2.0 / (double)props.slotsPerRow);
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            x = xCenter - 55;
            int xInv = xCenter + 2;
            yInv = Math.min(yInv, yCenter - 92);
            SimpleContainer wolfInv = new SimpleContainer(2);
            ItemStack wolfArmor = ((Wolf)entityLivingBase).getBodyArmorItem();
            wolfInv.setItem(0, wolfArmor != null && !wolfArmor.isEmpty() ? wolfArmor : ItemStack.EMPTY);
            InventoryOverlay.renderInventoryBackground((GuiGraphics)drawContext, (InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (Minecraft)mc);
            InventoryOverlay.renderWolfArmorBackgroundSlots((GuiGraphics)drawContext, (Container)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY));
            InventoryOverlay.renderInventoryStacks((GuiGraphics)drawContext, (InventoryOverlay.InventoryRenderType)type, (Container)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (Minecraft)mc);
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground((GuiGraphics)drawContext, (int)x, (int)y, (LivingEntity)entityLivingBase);
            InventoryOverlay.renderEquipmentStacks((GuiGraphics)drawContext, (LivingEntity)entityLivingBase, (int)x, (int)y, (Minecraft)mc);
        }
    }
}

