/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBox;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class ShapeBlocky
extends ShapeBase {
    private BlockSnap snap = BlockSnap.CENTER;
    protected AABB renderPerimeter = ShapeBox.DEFAULT_BOX;
    private boolean combineQuads;

    public ShapeBlocky(ShapeType type, Color4f color) {
        super(type, color);
    }

    public BlockSnap getBlockSnap() {
        return this.snap;
    }

    public void setBlockSnap(BlockSnap snap) {
        this.snap = snap;
    }

    public boolean getCombineQuads() {
        return this.combineQuads;
    }

    public boolean toggleCombineQuads() {
        this.combineQuads = !this.combineQuads;
        this.setNeedsUpdate();
        return this.combineQuads;
    }

    protected void setRenderPerimeter(Vec3 center, double range) {
        this.renderPerimeter = new AABB(center.x - range, center.y - range, center.z - range, center.x + range, center.y + range, center.z + range);
    }

    protected Vec3 getBlockSnappedPosition(Vec3 pos) {
        BlockSnap snap = this.getBlockSnap();
        if (snap == BlockSnap.CENTER) {
            return new Vec3(Math.floor(pos.x) + 0.5, Math.floor(pos.y), Math.floor(pos.z) + 0.5);
        }
        if (snap == BlockSnap.CORNER) {
            return new Vec3(Math.floor(pos.x), Math.floor(pos.y), Math.floor(pos.z));
        }
        return pos;
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        Entity entity = EntityUtils.getCameraEntity();
        return super.shouldRender(mc) && entity != null && this.renderPerimeter.contains(entity.position());
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        BlockSnap snap = this.getBlockSnap();
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.block_snap", (Object[])new Object[]{snap.getDisplayName()}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("snap", (JsonElement)new JsonPrimitive(this.snap.getStringValue()));
        obj.add("combine_quads", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.combineQuads)));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        if (JsonUtils.hasString((JsonObject)obj, (String)"snap")) {
            this.snap = BlockSnap.fromStringStatic((String)JsonUtils.getString((JsonObject)obj, (String)"snap"));
        }
        this.combineQuads = JsonUtils.getBooleanOrDefault((JsonObject)obj, (String)"combine_quads", (boolean)false);
    }

    protected Consumer<BlockPos.MutableBlockPos> getPositionCollector(LongOpenHashSet positionsOut) {
        IntBoundingBox box = this.layerRange.getExpandedBox((Level)this.mc.level, 0);
        Consumer<BlockPos.MutableBlockPos> positionCollector = pos -> {
            if (box.containsPos((Vec3i)pos)) {
                positionsOut.add(pos.asLong());
            }
        };
        return positionCollector;
    }
}

