/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.renderer.shapes.ShapeBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public abstract class ShapeCircleBase
extends ShapeBlocky {
    private static final double DEFAULT_MAX_RADIUS = 1024.0;
    protected Direction mainAxis = Direction.UP;
    private double maxRadius = 1024.0;
    private double radius;
    private double radiusSq;
    private Vec3 center = Vec3.ZERO;
    private Vec3 effectiveCenter = Vec3.ZERO;

    public ShapeCircleBase(ShapeType type, Color4f color, double radius) {
        super(type, color);
        this.setRadius(radius);
        Entity entity = EntityUtils.getCameraEntity();
        if (entity != null) {
            Vec3 center = entity.position();
            center = new Vec3(Math.floor(center.x) + 0.5, Math.floor(center.y), Math.floor(center.z) + 0.5);
            this.setCenter(center);
        } else {
            this.setCenter(Vec3.ZERO);
        }
    }

    public Vec3 getCenter() {
        return this.center;
    }

    public Vec3 getEffectiveCenter() {
        return this.effectiveCenter;
    }

    public void setCenter(Vec3 center) {
        this.center = center;
        this.updateEffectiveCenter();
    }

    @Override
    public void moveToPosition(Vec3 pos) {
        this.setCenter(pos);
        InfoUtils.printActionbarMessage((String)String.format("Moved shape to %.1f %.1f %.1f", pos.x(), pos.y(), pos.z()), (Object[])new Object[0]);
    }

    public double getRadius() {
        return this.radius;
    }

    public double getSquaredRadius() {
        return this.radiusSq;
    }

    public void setRadius(double radius) {
        if (radius >= 0.0 && radius <= this.maxRadius) {
            this.radius = radius;
            this.radiusSq = radius * radius;
            this.setRenderPerimeter(this.effectiveCenter, this.radius + 512.0);
            this.setNeedsUpdate();
        }
    }

    public Direction getMainAxis() {
        return this.mainAxis;
    }

    public void setMainAxis(Direction mainAxis) {
        this.mainAxis = mainAxis;
        this.setNeedsUpdate();
    }

    protected BlockPos getCenterBlock() {
        return BlockPos.containing((Position)this.effectiveCenter);
    }

    @Override
    public void setBlockSnap(BlockSnap snap) {
        super.setBlockSnap(snap);
        this.updateEffectiveCenter();
    }

    protected void updateEffectiveCenter() {
        this.effectiveCenter = this.getBlockSnappedPosition(this.center);
        this.setRenderPerimeter(this.effectiveCenter, this.radius + 512.0);
        this.setNeedsUpdate();
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("center", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.center));
        obj.add("main_axis", (JsonElement)new JsonPrimitive(this.mainAxis.name()));
        obj.add("radius", (JsonElement)new JsonPrimitive((Number)this.getRadius()));
        if (this.maxRadius != 1024.0) {
            obj.add("max_radius", (JsonElement)new JsonPrimitive((Number)this.maxRadius));
        }
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        Vec3 center;
        double maxRadius;
        Direction facing;
        super.fromJson(obj);
        if (JsonUtils.hasString((JsonObject)obj, (String)"main_axis") && (facing = Direction.valueOf((String)obj.get("main_axis").getAsString())) != null) {
            this.setMainAxis(facing);
        }
        if (JsonUtils.hasDouble((JsonObject)obj, (String)"max_radius") && (maxRadius = JsonUtils.getDouble((JsonObject)obj, (String)"max_radius")) > 0.0 && maxRadius < 1000000.0) {
            this.maxRadius = maxRadius;
        }
        if (JsonUtils.hasDouble((JsonObject)obj, (String)"radius")) {
            this.setRadius(JsonUtils.getDouble((JsonObject)obj, (String)"radius"));
        }
        if ((center = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"center")) != null) {
            this.setCenter(center);
        }
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        BlockSnap snap = this.getBlockSnap();
        Vec3 c = this.center;
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.radius_value", (Object[])new Object[]{this.getRadius()}));
        lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.center_value", (Object[])new Object[]{ShapeCircleBase.d2(c.x), ShapeCircleBase.d2(c.y), ShapeCircleBase.d2(c.z)}));
        if (snap != BlockSnap.NONE) {
            c = this.effectiveCenter;
            lines.add(StringUtils.translate((String)"minihud.gui.hover.shape.effective_center_value", (Object[])new Object[]{ShapeCircleBase.d2(c.x), ShapeCircleBase.d2(c.y), ShapeCircleBase.d2(c.z)}));
        }
        return lines;
    }
}

