/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.malilib.util.time.TickUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.Reference;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.data.MobCapDataHandler;
import fi.dy.masa.minihud.mixin.server.IMixinMinecraftServer;
import fi.dy.masa.minihud.network.ServuxStructuresHandler;
import fi.dy.masa.minihud.network.ServuxStructuresPacket;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererBiomeBorders;
import fi.dy.masa.minihud.renderer.OverlayRendererConduitRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.renderer.worker.ChunkTask;
import fi.dy.masa.minihud.renderer.worker.ThreadWorker;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class DataStorage {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("MiniHUD Worker Thread %d").setDaemon(true).build();
    private static final Pattern PATTERN_CARPET_TPS = Pattern.compile("TPS: (?<tps>[0-9]+[\\.,][0-9]) MSPT: (?<mspt>[0-9]+[\\.,][0-9])");
    private static final DataStorage INSTANCE = new DataStorage();
    private final MobCapDataHandler mobCapData = new MobCapDataHandler();
    private static final ServuxStructuresHandler<ServuxStructuresPacket.Payload> HANDLER = ServuxStructuresHandler.getInstance();
    private boolean carpetServer = false;
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private boolean hasIntegratedServer = false;
    private int simulationDistance = -1;
    private int structureDataTimeout = 600;
    private boolean serverTPSValid;
    private boolean hasSyncedTime;
    private String servuxVersion;
    private int servuxTimeout;
    private boolean hasStructureDataFromServer;
    private boolean structureRendererNeedsUpdate;
    private boolean structuresNeedUpdating;
    private boolean shouldRegisterStructureChannel;
    private long lastServerTick;
    private long lastServerTimeUpdate;
    private BlockPos lastStructureUpdatePos;
    private double serverTPS;
    private double serverMSPT;
    private Vec3 distanceReferencePoint = Vec3.ZERO;
    private final int[] blockBreakCounter = new int[100];
    private final ArrayListMultimap<StructureType, StructureData> structures = ArrayListMultimap.create();
    private final Minecraft mc = Minecraft.getInstance();
    private IntegratedServer integratedServer;
    private RegistryAccess registryManager = RegistryAccess.EMPTY;
    private final PriorityBlockingQueue<ChunkTask> taskQueue = Queues.newPriorityBlockingQueue();
    private final Thread workerThread;
    private final ThreadWorker worker = new ThreadWorker();

    private DataStorage() {
        this.workerThread = THREAD_FACTORY.newThread(this.worker);
        this.workerThread.start();
    }

    public static DataStorage getInstance() {
        return INSTANCE;
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxStructuresPacket.Payload.ID, ServuxStructuresPacket.Payload.CODEC, 6);
    }

    public ResourceLocation getNetworkChannel() {
        return ServuxStructuresHandler.CHANNEL_ID;
    }

    public IPluginClientPlayHandler<ServuxStructuresPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public MobCapDataHandler getMobCapData() {
        return this.mobCapData;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.debugLog("DataStorage#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
            this.structureDataTimeout = 600;
            this.registryManager = RegistryAccess.EMPTY;
            this.carpetServer = false;
            this.setHasIntegratedServer(false, null);
        } else {
            MiniHUD.debugLog("DataStorage#reset() - dimension change or log-in", new Object[0]);
        }
        this.mobCapData.clear();
        this.serverTPSValid = false;
        this.hasSyncedTime = false;
        this.structuresNeedUpdating = true;
        this.hasStructureDataFromServer = false;
        this.structureRendererNeedsUpdate = true;
        this.lastStructureUpdatePos = null;
        this.structures.clear();
        this.clearTasks();
        this.servuxTimeout = -1;
        ShapeManager.INSTANCE.clear();
        OverlayRendererBeaconRange.INSTANCE.reset();
        OverlayRendererConduitRange.INSTANCE.reset();
        OverlayRendererBiomeBorders.INSTANCE.reset();
        OverlayRendererLightLevel.INSTANCE.reset();
    }

    public void clearTasks() {
        this.taskQueue.clear();
    }

    public ChunkTask getNextTask() throws InterruptedException {
        return this.taskQueue.take();
    }

    public void addTask(Runnable task, ChunkPos pos, Vec3i playerPos) {
        if (this.taskQueue.size() < 64000) {
            this.taskQueue.offer(new ChunkTask(task, pos, playerPos));
        }
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        if (this.hasInValidServux) {
            this.hasInValidServux = false;
        }
    }

    public void setServuxVersion(String ver) {
        this.servuxVersion = ver != null && !ver.isEmpty() ? ver : "unknown";
    }

    public String getServuxVersion() {
        if (this.hasServuxServer()) {
            return this.servuxVersion;
        }
        return "not_connected";
    }

    public boolean hasIntegratedServer() {
        return this.hasIntegratedServer;
    }

    public void setHasIntegratedServer(boolean toggle, @Nullable IntegratedServer server) {
        this.hasIntegratedServer = toggle;
        this.integratedServer = server;
    }

    public IntegratedServer getIntegratedServer() {
        return this.integratedServer;
    }

    public boolean isSinglePlayer() {
        if (this.mc != null) {
            return this.mc.isLocalServer();
        }
        return false;
    }

    public void onWorldPre() {
        if (!this.hasIntegratedServer) {
            HANDLER.registerPlayReceiver(ServuxStructuresPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
        MiniHUD.debugLog("DataStorage#onWorldJoin()", new Object[0]);
        OverlayRendererBeaconRange.INSTANCE.setNeedsUpdate();
        OverlayRendererConduitRange.INSTANCE.setNeedsUpdate();
        OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate();
        OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate();
        if (!this.hasIntegratedServer) {
            if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                this.registerStructureChannel();
                this.structuresNeedUpdating = true;
            } else {
                this.unregisterStructureChannel();
            }
        }
    }

    public void setWorldRegistryManager(RegistryAccess manager) {
        this.registryManager = manager != null && manager != RegistryAccess.EMPTY ? manager : RegistryAccess.EMPTY;
    }

    public RegistryAccess getWorldRegistryManager() {
        if (this.registryManager != RegistryAccess.EMPTY) {
            return this.registryManager;
        }
        return RegistryAccess.EMPTY;
    }

    public void setSimulationDistance(int distance) {
        if (distance >= 0) {
            if (this.simulationDistance != distance) {
                OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate();
                OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate();
            }
            this.simulationDistance = distance;
        } else {
            this.simulationDistance = -1;
        }
    }

    public boolean isSimulationDistanceKnown() {
        return this.simulationDistance >= 0;
    }

    public int getSimulationDistance() {
        if (this.simulationDistance > 0) {
            return this.simulationDistance;
        }
        return 10;
    }

    public boolean hasTPSData() {
        return this.serverTPSValid;
    }

    public boolean hasCarpetServer() {
        return this.carpetServer;
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public double getServerTPS() {
        return this.serverTPS;
    }

    public double getServerMSPT() {
        return this.serverMSPT;
    }

    public boolean structureRendererNeedsUpdate() {
        return this.structureRendererNeedsUpdate;
    }

    public void setStructuresNeedUpdating() {
        this.structuresNeedUpdating = true;
    }

    public void setStructureRendererNeedsUpdate() {
        this.structureRendererNeedsUpdate = true;
    }

    public Vec3 getDistanceReferencePoint() {
        return this.distanceReferencePoint;
    }

    public void setDistanceReferencePoint(Vec3 pos) {
        this.distanceReferencePoint = pos;
        String str = String.format("x: %.2f, y: %.2f, z: %.2f", pos.x, pos.y, pos.z);
        InfoUtils.printActionbarMessage((String)"minihud.message.distance_reference_point_set", (Object[])new Object[]{str});
    }

    public void markChunkForHeightmapCheck(int chunkX, int chunkZ) {
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (entity != null) {
            Vec3 pos = entity.position();
            if (Math.abs(pos.x - (double)(chunkX << 4) - 8.0) <= 48.0 || Math.abs(pos.z - (double)(chunkZ << 4) - 8.0) <= 48.0) {
                OverlayRendererSpawnableColumnHeights.INSTANCE.markChunkChanged(chunkX, chunkZ);
                OverlayRendererLightLevel.INSTANCE.setNeedsUpdate();
            }
        }
    }

    public void onClientTickPre(Minecraft mc) {
        if (mc.level != null && mc.level.getGameTime() > 0L) {
            int tick = (int)(mc.level.getGameTime() % (long)this.blockBreakCounter.length);
            this.blockBreakCounter[tick] = 0;
        }
    }

    public void onPlayerBlockBreak(Minecraft mc) {
        if (mc.level != null && mc.level.getGameTime() > 0L) {
            int tick;
            int n = tick = (int)(mc.level.getGameTime() % (long)this.blockBreakCounter.length);
            this.blockBreakCounter[n] = this.blockBreakCounter[n] + 1;
        }
    }

    public double getBlockBreakingSpeed() {
        return MiscUtils.intAverage(this.blockBreakCounter) * 20.0;
    }

    public boolean onSendChatMessage(String message) {
        String[] parts = message.split(" ");
        if (parts.length > 0 && (parts[0].equals("minihud-seed") || parts[0].equals("/minihud-seed"))) {
            if (parts.length == 2) {
                try {
                    HudDataManager.getInstance().setWorldSeed(Long.parseLong(parts[1]));
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{HudDataManager.getInstance().worldSeed()});
                }
                catch (NumberFormatException e) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_seed", (Object[])new Object[0]);
                }
            } else if (parts.length == 1) {
                if (HudDataManager.getInstance().hasStoredWorldSeed()) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_is", (Object[])new Object[]{HudDataManager.getInstance().worldSeed()});
                } else {
                    InfoUtils.printActionbarMessage((String)"minihud.message.no_seed", (Object[])new Object[0]);
                }
            }
            return true;
        }
        if (parts.length > 0 && (parts[0].equals("minihud-spawnchunkradius") || parts[0].equals("/minihud-spawnchunkradius"))) {
            block17: {
                if (parts.length == 2) {
                    try {
                        int radius = Integer.parseInt(parts[1]);
                        if (radius > 0 && radius <= 32) {
                            HudDataManager.getInstance().setSpawnChunkRadius(radius, true);
                            break block17;
                        }
                        HudDataManager.getInstance().setSpawnChunkRadius(-1, false);
                        InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_spawn_chunk_radius", (Object[])new Object[0]);
                    }
                    catch (NumberFormatException e) {
                        HudDataManager.getInstance().setSpawnChunkRadius(-1, false);
                        InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_spawn_chunk_radius", (Object[])new Object[0]);
                    }
                } else if (parts.length == 1) {
                    if (HudDataManager.getInstance().isSpawnChunkRadiusKnown()) {
                        int radius = HudDataManager.getInstance().getSpawnChunkRadius();
                        String strRadius = radius > 0 ? GuiBase.TXT_GREEN + String.format("%d", radius) + GuiBase.TXT_RST : GuiBase.TXT_RED + String.format("%d", radius) + GuiBase.TXT_RST;
                        InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"minihud.message.spawn_chunk_radius_is", (Object[])new Object[]{strRadius}), (Object[])new Object[0]);
                    } else {
                        InfoUtils.printActionbarMessage((String)"minihud.message.no_spawn_chunk_radius", (Object[])new Object[0]);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void onChatMessage(Component message) {
        MutableComponent mutableText;
        ComponentContents componentContents;
        if (message instanceof MutableComponent && (componentContents = (mutableText = (MutableComponent)message).getContents()) instanceof TranslatableContents) {
            TranslatableContents text = (TranslatableContents)componentContents;
            if ("commands.seed.success".equals(text.getKey()) && text.getArgs().length == 1) {
                try {
                    MutableComponent m = (MutableComponent)text.getArgs()[0];
                    TranslatableContents t = (TranslatableContents)m.getContents();
                    PlainTextContents.LiteralContents l = (PlainTextContents.LiteralContents)((MutableComponent)t.getArgs()[0]).getContents();
                    String str = l.text();
                    HudDataManager.getInstance().setWorldSeed(Long.parseLong(str));
                    MiniHUD.LOGGER.info("Received world seed from the vanilla /seed command: {}", (Object)HudDataManager.getInstance().worldSeed());
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{HudDataManager.getInstance().worldSeed()});
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.warn("Failed to read the world seed from '{}'", text.getArgs()[0]);
                }
            } else if ("jed.commands.seed.success".equals(text.getKey())) {
                try {
                    HudDataManager.getInstance().setWorldSeed(Long.parseLong(text.getArgs()[1].toString()));
                    MiniHUD.LOGGER.info("Received world seed from the JED '/jed seed' command: {}", (Object)HudDataManager.getInstance().worldSeed());
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{HudDataManager.getInstance().worldSeed()});
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.warn("Failed to read the world seed from '{}'", text.getArgs()[1], (Object)e);
                }
            } else if ("commands.setworldspawn.success".equals(text.getKey()) && text.getArgs().length == 4) {
                try {
                    Object[] o = text.getArgs();
                    int x = Integer.parseInt(o[0].toString());
                    int y = Integer.parseInt(o[1].toString());
                    int z = Integer.parseInt(o[2].toString());
                    ResourceKey key = this.mc.level != null ? this.mc.level.dimension() : Level.OVERWORLD;
                    GlobalPos newSpawn = new GlobalPos(key, new BlockPos(x, y, z));
                    HudDataManager.getInstance().setWorldSpawn(newSpawn);
                    String spawnStr = HudDataManager.getInstance().getWorldSpawnAsString(newSpawn);
                    MiniHUD.LOGGER.info("Received world spawn from the vanilla /setworldspawn command: {}", (Object)spawnStr);
                    InfoUtils.printActionbarMessage((String)"minihud.message.spawn_set", (Object[])new Object[]{spawnStr});
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.warn("Failed to read the world spawn point from '{}'", (Object)text.getArgs(), (Object)e);
                }
            }
        }
    }

    public void onServerTimeUpdate(long totalWorldTime) {
        if (!this.carpetServer && !this.mc.isLocalServer()) {
            long elapsedTicks;
            long currentTime = System.nanoTime();
            if (this.hasSyncedTime && (elapsedTicks = totalWorldTime - this.lastServerTick) > 0L) {
                this.serverMSPT = (double)(currentTime - this.lastServerTimeUpdate) / (double)elapsedTicks / 1000000.0;
                this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
                this.serverTPSValid = true;
            }
            this.lastServerTick = totalWorldTime;
            this.lastServerTimeUpdate = currentTime;
            this.hasSyncedTime = true;
        }
    }

    public void updateIntegratedServerTPS() {
        if (this.mc != null && this.mc.player != null && this.mc.getSingleplayerServer() != null) {
            this.serverMSPT = (double)MiscUtils.longAverage(this.mc.getSingleplayerServer().getTickTimesNanos()) / 1000000.0;
            this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
            this.serverTPSValid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayListMultimap<StructureType, StructureData> getCopyOfStructureData() {
        ArrayListMultimap copy = ArrayListMultimap.create();
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return copy;
        }
        ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
        synchronized (arrayListMultimap) {
            for (StructureType type : StructureType.VALUES) {
                List values = this.structures.get((Object)type);
                if (values.isEmpty()) continue;
                copy.putAll((Object)type, (Iterable)values);
            }
            this.structureRendererNeedsUpdate = false;
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayListMultimap<StructureType, StructureData> getCopyOfStructureDataWithinRange(BlockPos pos, int maxRange) {
        ArrayListMultimap copy = ArrayListMultimap.create();
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return copy;
        }
        ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
        synchronized (arrayListMultimap) {
            for (StructureType type : StructureType.VALUES) {
                List values = this.structures.get((Object)type);
                ArrayList<StructureData> valuesCopy = new ArrayList<StructureData>();
                if (values.isEmpty()) continue;
                for (StructureData structure : values) {
                    if (!MiscUtils.isStructureWithinRange(structure.getBoundingBox(), pos, maxRange)) continue;
                    valuesCopy.add(structure);
                }
                copy.putAll((Object)type, valuesCopy);
            }
            this.structureRendererNeedsUpdate = false;
        }
        return copy;
    }

    public void updateStructureData() {
        long currentTime;
        if (this.mc != null && this.mc.level != null && this.mc.player != null && (currentTime = this.mc.level.getGameTime()) % 20L == 0L) {
            if (this.mc.hasSingleplayerServer()) {
                if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                    BlockPos playerPos = PositionUtils.getEntityBlockPos((Entity)this.mc.player);
                    int maxRange = this.mc.options.getEffectiveRenderDistance() + 2;
                    int hysteresis = 16;
                    if (this.structuresNeedUpdating(playerPos, 16)) {
                        this.updateStructureDataFromIntegratedServer(playerPos, maxRange);
                    }
                }
            } else if (this.hasStructureDataFromServer) {
                this.removeExpiredStructures(currentTime, this.structureDataTimeout);
            } else if (this.shouldRegisterStructureChannel && this.mc.getConnection() != null) {
                if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                    this.registerStructureChannel();
                    this.structuresNeedUpdating = true;
                }
                this.shouldRegisterStructureChannel = false;
            }
        }
    }

    public void registerStructureChannel() {
        this.shouldRegisterStructureChannel = true;
        if (!(this.servuxServer || this.hasIntegratedServer || this.hasInValidServux)) {
            if (HANDLER.isPlayRegistered(this.getNetworkChannel())) {
                MiniHUD.debugLog("DataStorage#registerStructureChannel(): sending STRUCTURES_REGISTER to Servux", new Object[0]);
                CompoundTag nbt = new CompoundTag();
                nbt.putString("version", Reference.MOD_STRING);
                HANDLER.encodeStructuresPacket(new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_C2S_STRUCTURES_REGISTER, nbt));
            }
        } else {
            this.shouldRegisterStructureChannel = false;
        }
    }

    public boolean receiveServuxStrucutresMetadata(CompoundTag data) {
        if (!this.servuxServer && !this.hasIntegratedServer && this.shouldRegisterStructureChannel) {
            MiniHUD.debugLog("DataStorage#receiveServuxStrucutresMetadata(): received METADATA from Servux", new Object[0]);
            if (data.getIntOr("version", -1) != 2) {
                MiniHUD.LOGGER.warn("structureChannel: Mis-matched protocol version!");
            }
            this.servuxTimeout = data.getIntOr("timeout", 300);
            this.setServuxVersion(data.getStringOr("servux", "?"));
            if (data.contains("spawnPosX")) {
                HudDataManager.getInstance().setWorldSpawn(new GlobalPos(Level.OVERWORLD, new BlockPos(data.getIntOr("spawnPosX", 0), data.getIntOr("spawnPosY", 0), data.getIntOr("spawnPosZ", 0))));
            }
            if (data.contains("worldSeed")) {
                HudDataManager.getInstance().setWorldSeed(data.getLongOr("worldSeed", -1L));
            }
            this.setIsServuxServer();
            if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                this.registerStructureChannel();
                return true;
            }
            this.unregisterStructureChannel();
        }
        return false;
    }

    public void unregisterStructureChannel() {
        if (this.servuxServer || !RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            this.servuxServer = false;
            if (!this.hasInValidServux) {
                MiniHUD.debugLog("DataStorage#unregisterStructureChannel(): for {}", this.servuxVersion != null ? this.servuxVersion : "<unknown>");
                HANDLER.encodeStructuresPacket(new ServuxStructuresPacket(ServuxStructuresPacket.Type.PACKET_C2S_STRUCTURES_UNREGISTER, new CompoundTag()));
                HANDLER.reset(HANDLER.getPayloadChannel());
            }
        }
        this.shouldRegisterStructureChannel = false;
    }

    public void onPacketFailure() {
        this.shouldRegisterStructureChannel = false;
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    private boolean structuresNeedUpdating(BlockPos playerPos, int hysteresis) {
        return this.structuresNeedUpdating || this.lastStructureUpdatePos == null || Math.abs(playerPos.getX() - this.lastStructureUpdatePos.getX()) >= hysteresis || Math.abs(playerPos.getY() - this.lastStructureUpdatePos.getY()) >= hysteresis || Math.abs(playerPos.getZ() - this.lastStructureUpdatePos.getZ()) >= hysteresis;
    }

    public int getStrucutreCount() {
        return this.structures.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStructureDataFromIntegratedServer(BlockPos playerPos, int maxRange) {
        if (this.mc.player == null || this.mc.getSingleplayerServer() == null) {
            return;
        }
        ResourceKey worldId = this.mc.player.level().dimension();
        ServerLevel world = this.mc.getSingleplayerServer().getLevel(worldId);
        if (world != null) {
            IntegratedServer server = this.mc.getSingleplayerServer();
            ((IMixinMinecraftServer)server).minihud_send(new TickTask(server.getTickCount(), () -> {
                ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
                synchronized (arrayListMultimap) {
                    this.addStructureDataFromGenerator(world, playerPos, maxRange);
                }
            }));
        } else {
            ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
            synchronized (arrayListMultimap) {
                this.structures.clear();
            }
        }
        this.lastStructureUpdatePos = playerPos;
        this.structuresNeedUpdating = false;
    }

    public void addOrUpdateStructuresFromServer(ListTag structures, boolean isServux) {
        if (!isServux) {
            MiniHUD.debugLog("DataStorage#addOrUpdateStructuresFromServer(): Ignoring structure data when isServux is false", new Object[0]);
            return;
        }
        if (!structures.isEmpty()) {
            this.structureDataTimeout = this.servuxTimeout + 300;
            long currentTime = this.mc.level.getGameTime();
            int count = structures.size();
            int oldCount = this.structures.size();
            this.removeExpiredStructures(currentTime, this.structureDataTimeout);
            for (int i = 0; i < count; ++i) {
                CompoundTag tag = structures.getCompoundOrEmpty(i);
                StructureData data = StructureData.fromStructureStartTag(tag, currentTime);
                if (data == null) continue;
                if (this.structures.containsEntry((Object)data.getStructureType(), (Object)data)) {
                    this.structures.remove((Object)data.getStructureType(), (Object)data);
                }
                this.structures.put((Object)data.getStructureType(), (Object)data);
            }
            MiniHUD.debugLog("addOrUpdateStructuresFromServer: received {} structures // total size {} -> {}", count, oldCount, this.structures.size());
            this.structureRendererNeedsUpdate = true;
            this.hasStructureDataFromServer = true;
        }
    }

    private void removeExpiredStructures(long currentTime, int timeout) {
        int countBefore = this.structures.values().size();
        this.structures.values().removeIf(data -> currentTime > data.getRefreshTime() + (long)timeout);
        int countAfter = this.structures.values().size();
        if (countBefore != countAfter) {
            MiniHUD.debugLog("removeExpiredStructures: from server: {} -> {} structures", countBefore, countAfter);
        }
    }

    private void addStructureDataFromGenerator(ServerLevel world, BlockPos playerPos, int maxChunkRange) {
        int lastCount = this.structures.size();
        this.structures.clear();
        int minCX = (playerPos.getX() >> 4) - maxChunkRange;
        int minCZ = (playerPos.getZ() >> 4) - maxChunkRange;
        int maxCX = (playerPos.getX() >> 4) + maxChunkRange;
        int maxCZ = (playerPos.getZ() >> 4) + maxChunkRange;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                ChunkAccess chunk;
                try {
                    chunk = world.getChunk(cx, cz, ChunkStatus.STRUCTURE_REFERENCES, false);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (chunk == null) continue;
                for (Map.Entry entry : chunk.getAllStarts().entrySet()) {
                    Structure structure = (Structure)entry.getKey();
                    StructureStart start = (StructureStart)entry.getValue();
                    ResourceLocation id = world.registryAccess().lookupOrThrow(Registries.STRUCTURE).getKey((Object)structure);
                    StructureType type = StructureType.fromStructureId(id != null ? id.toString() : "?");
                    if (!type.isEnabled() || !start.isValid() || !MiscUtils.isStructureWithinRange(start.getBoundingBox(), playerPos, maxChunkRange << 4)) continue;
                    this.structures.put((Object)type, (Object)StructureData.fromStructureStart(type, start));
                }
            }
        }
        MiniHUD.debugLog("addStructureDataFromGenerator: updated from the integrated server: {} -> {} structures", lastCount, this.structures.size());
        this.structureRendererNeedsUpdate = true;
    }

    public void handleCarpetServerTPSData(Component textComponent) {
        if (!textComponent.getString().isEmpty()) {
            String[] lines;
            String text = ChatFormatting.stripFormatting((String)textComponent.getString());
            for (String line : lines = text.split("\n")) {
                Matcher matcher = PATTERN_CARPET_TPS.matcher(line);
                if (!matcher.matches()) continue;
                if (!TickUtils.getInstance().isUsingDirectServerData()) {
                    TickUtils.getInstance().toggleUseDirectServerData(true);
                }
                try {
                    this.serverTPS = Double.parseDouble(matcher.group("tps"));
                    this.serverMSPT = Double.parseDouble(matcher.group("mspt"));
                    this.serverTPSValid = true;
                    TickUtils.getInstance().updateNanoTickFromServerDirect(this.serverTPS, this.serverMSPT);
                    this.carpetServer = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("distance_pos", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.distanceReferencePoint));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        Vec3 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"distance_pos");
        this.distanceReferencePoint = Objects.requireNonNullElse(pos, Vec3.ZERO);
        if (JsonUtils.hasLong((JsonObject)obj, (String)"seed")) {
            HudDataManager.getInstance().setWorldSeed(JsonUtils.getLong((JsonObject)obj, (String)"seed"));
        }
        if (JsonUtils.hasInteger((JsonObject)obj, (String)"spawn_chunk_radius")) {
            HudDataManager.getInstance().setSpawnChunkRadius(JsonUtils.getIntegerOrDefault((JsonObject)obj, (String)"spawn_chunk_radius", (int)-1), false);
        }
    }
}

