/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import fi.dy.masa.minihud.event.RenderHandler;
import fi.dy.masa.minihud.util.DataStorage;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;

public class InventoryUtils {
    public static Container getInventory(Level world, BlockPos pos) {
        Container inv = fi.dy.masa.malilib.util.InventoryUtils.getInventory((Level)world, (BlockPos)pos);
        if ((inv == null || inv.isEmpty()) && !DataStorage.getInstance().hasIntegratedServer()) {
            RenderHandler.getInstance().requestBlockEntityAt(world, pos);
        }
        return inv;
    }

    public static int recalculateBundleSize(BundleContents bundle, int maxCount) {
        Iterator iter = bundle.itemCopyStream().iterator();
        int vanillaMax = 64;
        int vanillaBundleAdj = 4;
        int newCount = 0;
        while (iter.hasNext()) {
            ItemStack entry = (ItemStack)iter.next();
            if (entry.isEmpty()) continue;
            Bees beeData = (Bees)entry.getOrDefault(DataComponents.BEES, (Object)Bees.EMPTY);
            List list = beeData.bees();
            if (!list.isEmpty()) {
                return 64;
            }
            if (entry.has(DataComponents.BUNDLE_CONTENTS)) {
                BundleContents bundleEntry = (BundleContents)entry.get(DataComponents.BUNDLE_CONTENTS);
                if (bundleEntry != null) {
                    if (bundleEntry.isEmpty()) {
                        newCount += 4;
                        continue;
                    }
                    newCount += InventoryUtils.recalculateBundleSize(bundleEntry, maxCount) + 4;
                    continue;
                }
                newCount += Math.min(entry.getCount(), maxCount);
                continue;
            }
            if (entry.getMaxStackSize() != 64) {
                float fraction = (float)entry.getCount() / (float)entry.getMaxStackSize();
                if (fraction != 1.0f) {
                    newCount += (int)(64.0f * fraction);
                    continue;
                }
                return 64;
            }
            newCount += Math.min(entry.getCount(), maxCount);
        }
        return newCount;
    }
}

