/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.time.DurationFormat;
import fi.dy.masa.malilib.util.time.TimeFormat;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.mixin.block.IMixinAbstractFurnaceBlockEntity;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.InventoryUtils;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.math.Fraction;

public class MiscUtils {
    private static final Random RAND = new Random();
    private static final int[] AXOLOTL_COLORS = new int[]{16762860, 9202768, 16438299, 15267835, 11974142};

    public static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static double intAverage(int[] values) {
        long sum = 0L;
        for (int value : values) {
            sum += (long)value;
        }
        return (double)sum / (double)values.length;
    }

    public static long longAverage(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }

    public static boolean canSlimeSpawnAt(int posX, int posZ, long worldSeed) {
        return MiscUtils.canSlimeSpawnInChunk(posX >> 4, posZ >> 4, worldSeed);
    }

    public static boolean canSlimeSpawnInChunk(int chunkX, int chunkZ, long worldSeed) {
        long slimeSeed = 987234911L;
        long rngSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ slimeSeed;
        RAND.setSeed(rngSeed);
        return RAND.nextInt(10) == 0;
    }

    public static boolean isOverworld(Level world) {
        return world.dimensionType().natural();
    }

    public static boolean isStructureWithinRange(@Nullable BoundingBox bb, BlockPos playerPos, int maxRange) {
        return bb != null && playerPos.getX() >= bb.minX() - maxRange && playerPos.getX() <= bb.maxX() + maxRange && playerPos.getZ() >= bb.minZ() - maxRange && playerPos.getZ() <= bb.maxZ() + maxRange;
    }

    public static boolean isStructureWithinRange(@Nullable IntBoundingBox bb, BlockPos playerPos, int maxRange) {
        return bb != null && playerPos.getX() >= bb.minX - maxRange && playerPos.getX() <= bb.maxX + maxRange && playerPos.getZ() >= bb.minZ - maxRange && playerPos.getZ() <= bb.maxZ + maxRange;
    }

    public static boolean areBoxesEqual(IntBoundingBox bb1, IntBoundingBox bb2) {
        return bb1.minX == bb2.minX && bb1.minY == bb2.minY && bb1.minZ == bb2.minZ && bb1.maxX == bb2.maxX && bb1.maxY == bb2.maxY && bb1.maxZ == bb2.maxZ;
    }

    public static int getSpawnableChunksCount(@Nonnull ServerLevel world) {
        return world.getChunkSource().chunkMap.getDistanceManager().getNaturalSpawnChunkCount();
    }

    public static void addAxolotlTooltip(ItemStack stack, Consumer<Component> lines) {
        Axolotl.Variant variant = (Axolotl.Variant)stack.getComponents().getOrDefault(DataComponents.AXOLOTL_VARIANT, (Object)Axolotl.Variant.LUCY);
        int variantId = variant.getId();
        String variantName = variant.getName();
        MutableComponent labelText = Component.translatable((String)"minihud.label.axolotl_tooltip.label");
        MutableComponent valueText = Component.translatable((String)"minihud.label.axolotl_tooltip.value", (Object[])new Object[]{variantName, variantId});
        if (variantId < AXOLOTL_COLORS.length) {
            valueText.setStyle(Style.EMPTY.withColor(AXOLOTL_COLORS[variantId]));
        }
        lines.accept((Component)labelText.append((Component)valueText));
    }

    public static void addBeeTooltip(ItemStack stack, Consumer<Component> lines) {
        Bees bees = (Bees)stack.getComponents().getOrDefault(DataComponents.BEES, (Object)Bees.EMPTY);
        List beeList = bees.bees();
        if (beeList != null && !beeList.isEmpty()) {
            int count = beeList.size();
            int babyCount = 0;
            for (BeehiveBlockEntity.Occupant beeOccupant : beeList) {
                DataResult dr;
                Tag nbtName;
                TypedEntityData beeData = beeOccupant.entityData();
                CompoundTag beeTag = beeData.copyTagWithoutId();
                int beeTicks = beeOccupant.ticksInHive();
                Optional<Component> beeName = Optional.empty();
                int beeAge = -1;
                if (beeTag.contains("CustomName") && (nbtName = beeTag.get("CustomName")) != null && (dr = ComponentSerialization.CODEC.parse((DynamicOps)DataStorage.getInstance().getWorldRegistryManager().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbtName)).isSuccess()) {
                    beeName = Optional.of((Component)dr.getPartialOrThrow());
                }
                if (beeTag.contains("Age")) {
                    beeAge = beeTag.getIntOr("Age", 0);
                }
                if (beeAge + beeTicks < 0) {
                    ++babyCount;
                }
                beeName.ifPresent(text -> lines.accept((Component)Component.translatable((String)"minihud.label.bee_tooltip.name", (Object[])new Object[]{text})));
            }
            if (babyCount > 0) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.bee_tooltip.count_babies", (Object[])new Object[]{String.valueOf(count), String.valueOf(babyCount)}));
            } else {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.bee_tooltip.count", (Object[])new Object[]{String.valueOf(count)}));
            }
        }
    }

    public static void addBundleTooltip(ItemStack stack, Consumer<Component> lines) {
        BundleContents bundleData = (BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS);
        int maxCount = Configs.Generic.BUNDLE_TOOLTIPS_FILL_LEVEL.getIntegerValue();
        if (bundleData != null) {
            float fillPercent;
            int count;
            Fraction occupancy = bundleData.weight();
            if (maxCount != 64) {
                count = InventoryUtils.recalculateBundleSize(bundleData, maxCount);
                fillPercent = 100.0f * ((float)count / (float)maxCount);
            } else {
                count = Mth.mulAndTruncate((Fraction)occupancy, (int)maxCount);
                fillPercent = 100.0f * occupancy.floatValue();
            }
            if (count > maxCount) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.bundle_tooltip.count.full", (Object[])new Object[]{count, maxCount, Float.valueOf(fillPercent)}));
            } else {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.bundle_tooltip.count", (Object[])new Object[]{count, maxCount, Float.valueOf(fillPercent)}));
            }
        }
    }

    public static void addHoneyTooltip(ItemStack stack, Consumer<Component> lines) {
        BlockItemStateProperties blockItemState = (BlockItemStateProperties)stack.getComponents().get(DataComponents.BLOCK_STATE);
        if (blockItemState != null && !blockItemState.isEmpty()) {
            Integer honey = (Integer)blockItemState.get((Property)BlockStateProperties.LEVEL_HONEY);
            String honeyLevel = "0";
            if (honey != null && honey >= 0 && honey <= 5) {
                honeyLevel = String.valueOf(honey);
            }
            lines.accept(StringUtils.translateAsText((String)"minihud.label.honey_info.level", (Object[])new Object[]{honeyLevel}));
        }
    }

    public static void addCustomModelTooltip(ItemStack stack, Consumer<Component> lines) {
        CustomModelData data = (CustomModelData)stack.get(DataComponents.CUSTOM_MODEL_DATA);
        if (data != null) {
            Float aFloat = data.getFloat(0);
            Boolean aFlag = data.getBoolean(0);
            String aString = data.getString(0);
            Integer aColor = data.getColor(0);
            if (aFloat != null) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.custom_model_data_tooltip.float", (Object[])new Object[]{aFloat}));
            }
            if (aFlag != null) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.custom_model_data_tooltip.flag", (Object[])new Object[]{aFlag}));
            }
            if (aString != null) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.custom_model_data_tooltip.string", (Object[])new Object[]{aString}));
            }
            if (aColor != null) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.custom_model_data_tooltip.color", (Object[])new Object[]{aColor}));
            }
        }
    }

    public static void addFoodTooltip(ItemStack stack, Consumer<Component> lines) {
        FoodProperties data = (FoodProperties)stack.get(DataComponents.FOOD);
        if (data != null) {
            lines.accept(StringUtils.translateAsText((String)"minihud.label.food_tooltip", (Object[])new Object[]{Float.valueOf((float)data.nutrition() / 2.0f), Float.valueOf(data.saturation())}));
        }
    }

    public static void addLodestoneTooltip(ItemStack stack, Consumer<Component> lines) {
        LodestoneTracker data = (LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER);
        if (data != null && data.target().isPresent()) {
            GlobalPos pos = (GlobalPos)data.target().get();
            lines.accept(StringUtils.translateAsText((String)"minihud.label.lodestone_tooltip", (Object[])new Object[]{pos.dimension().location().getPath(), pos.pos().toShortString()}));
        }
    }

    public static int getFurnaceXpAmount(ServerLevel world, AbstractFurnaceBlockEntity be) {
        Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> recipes = ((IMixinAbstractFurnaceBlockEntity)be).minihud_getUsedRecipes();
        double xp = 0.0;
        if (recipes == null || recipes.isEmpty()) {
            return -1;
        }
        for (Reference2IntMap.Entry entry : recipes.reference2IntEntrySet()) {
            RecipeHolder recipeEntry = world.recipeAccess().byKey((ResourceKey)entry.getKey()).orElse(null);
            if (recipeEntry == null) continue;
            xp += (double)((float)entry.getIntValue() * ((AbstractCookingRecipe)recipeEntry.value()).experience());
        }
        return (int)xp;
    }

    public static int getFurnaceXpAmount(ServerLevel world, @Nonnull CompoundTag nbt) {
        Reference2IntOpenHashMap recipes = NbtBlockUtils.getRecipesUsedFromNbt((CompoundTag)nbt);
        double xp = 0.0;
        if (recipes.isEmpty()) {
            return -1;
        }
        for (Reference2IntMap.Entry entry : recipes.reference2IntEntrySet()) {
            RecipeHolder recipeEntry = world.recipeAccess().byKey((ResourceKey)entry.getKey()).orElse(null);
            if (recipeEntry == null) continue;
            xp += (double)((float)entry.getIntValue() * ((AbstractCookingRecipe)recipeEntry.value()).experience());
        }
        return (int)xp;
    }

    public static int getFurnaceXpAmount(AbstractFurnaceBlockEntity be) {
        Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> recipes = ((IMixinAbstractFurnaceBlockEntity)be).minihud_getUsedRecipes();
        double xp = 0.0;
        if (recipes == null || recipes.isEmpty() || HudDataManager.getInstance().getPreparedRecipes() == null) {
            return -1;
        }
        for (Reference2IntMap.Entry entry : recipes.reference2IntEntrySet()) {
            RecipeHolder recipeEntry = HudDataManager.getInstance().getPreparedRecipes().byKey((ResourceKey)entry.getKey());
            if (recipeEntry == null) continue;
            xp += (double)((float)entry.getIntValue() * ((AbstractCookingRecipe)recipeEntry.value()).experience());
        }
        return (int)xp;
    }

    public static int getFurnaceXpAmount(@Nonnull CompoundTag nbt) {
        Reference2IntOpenHashMap recipes = NbtBlockUtils.getRecipesUsedFromNbt((CompoundTag)nbt);
        double xp = 0.0;
        if (recipes.isEmpty() || HudDataManager.getInstance().getPreparedRecipes() == null) {
            return -1;
        }
        for (Reference2IntMap.Entry entry : recipes.reference2IntEntrySet()) {
            RecipeHolder recipeEntry = HudDataManager.getInstance().getPreparedRecipes().byKey((ResourceKey)entry.getKey());
            if (recipeEntry == null) continue;
            xp += (double)((float)entry.getIntValue() * ((AbstractCookingRecipe)recipeEntry.value()).experience());
        }
        return (int)xp;
    }

    public static String formatDateNow() {
        return MiscUtils.formatDateFromEpoch(-1L);
    }

    public static String formatDateFromEpoch(long epochMs) {
        TimeFormat type = (TimeFormat)Configs.Generic.DATE_FORMAT_TYPE.getOptionListValue();
        if (epochMs < 0L) {
            return type.formatNow(Configs.Generic.DATE_FORMAT_STRING.getStringValue());
        }
        return type.formatTo(epochMs, Configs.Generic.DATE_FORMAT_STRING.getStringValue());
    }

    public static long getEpochMsFromString(String time) {
        TimeFormat type = (TimeFormat)Configs.Generic.DATE_FORMAT_TYPE.getOptionListValue();
        return type.formatFrom(time, Configs.Generic.DATE_FORMAT_STRING.getStringValue());
    }

    public static String formatDuration(long duration) {
        DurationFormat type = (DurationFormat)Configs.Generic.DURATION_FORMAT_TYPE.getOptionListValue();
        return type.format(duration, Configs.Generic.DURATION_FORMAT_STRING.getStringValue());
    }
}

