/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.util.StructureType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureData {
    private final StructureType type;
    private final IntBoundingBox mainBox;
    private final ImmutableList<IntBoundingBox> componentBoxes;
    private long refreshTime;

    private StructureData(StructureType type, ImmutableList<IntBoundingBox> componentBoxes, long refreshTime) {
        this(type, componentBoxes);
        this.refreshTime = refreshTime;
    }

    private StructureData(StructureType type, ImmutableList<IntBoundingBox> componentBoxes) {
        this.type = type;
        this.mainBox = StructureData.encompass(componentBoxes);
        this.componentBoxes = componentBoxes;
    }

    public StructureType getStructureType() {
        return this.type;
    }

    public IntBoundingBox getBoundingBox() {
        return this.mainBox;
    }

    public ImmutableList<IntBoundingBox> getComponents() {
        return this.componentBoxes;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public static StructureData fromStructureStart(StructureType type, StructureStart structure) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List components = structure.getPieces();
        for (StructurePiece component : components) {
            builder.add((Object)IntBoundingBox.fromVanillaBox((BoundingBox)component.getBoundingBox()));
        }
        return new StructureData(type, (ImmutableList<IntBoundingBox>)builder.build());
    }

    @Nullable
    public static StructureData fromStructureStartTag(CompoundTag tag, long currentTime) {
        if (tag.contains("id") && tag.contains("Children")) {
            StructureType type = StructureType.fromStructureId(tag.getStringOr("id", "?"));
            if (type == StructureType.UNKNOWN && Configs.Generic.DEBUG_MESSAGES.getBooleanValue()) {
                MiniHUD.LOGGER.warn("StructureData.fromStructureStartTag(): Unknown structure type '{}'", (Object)tag.getString("id"));
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            ListTag pieces = tag.getListOrEmpty("Children");
            int count = pieces.size();
            for (int i = 0; i < count; ++i) {
                CompoundTag pieceTag = pieces.getCompoundOrEmpty(i);
                builder.add((Object)IntBoundingBox.fromArray((int[])((int[])pieceTag.getIntArray("BB").orElseThrow())));
            }
            return new StructureData(type, (ImmutableList<IntBoundingBox>)builder.build(), currentTime);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.componentBoxes == null ? 0 : this.componentBoxes.hashCode());
        result = 31 * result + (this.mainBox == null ? 0 : this.mainBox.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructureData other = (StructureData)obj;
        if (this.componentBoxes == null ? other.componentBoxes != null : !this.componentBoxes.equals(other.componentBoxes)) {
            return false;
        }
        if (this.mainBox == null ? other.mainBox != null : !this.mainBox.equals((Object)other.mainBox)) {
            return false;
        }
        return this.type == other.type;
    }

    public static IntBoundingBox encompass(Iterable<IntBoundingBox> boxes) {
        Iterator<IntBoundingBox> iterator = boxes.iterator();
        if (iterator.hasNext()) {
            IntBoundingBox box = iterator.next();
            int minX = box.minX;
            int minY = box.minY;
            int minZ = box.minZ;
            int maxX = box.maxX;
            int maxY = box.maxY;
            int maxZ = box.maxZ;
            while (iterator.hasNext()) {
                box = iterator.next();
                minX = Math.min(minX, box.minX);
                minY = Math.min(minY, box.minY);
                minZ = Math.min(minZ, box.minZ);
                maxX = Math.max(maxX, box.maxX);
                maxY = Math.max(maxY, box.maxY);
                maxZ = Math.max(maxZ, box.maxZ);
            }
            return new IntBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return new IntBoundingBox(0, 0, 0, 0, 0, 0);
    }
}

