/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util.shape;

import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ShapeRenderType;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class SphereUtils {
    public static void collectSpherePositions(Consumer<BlockPos.MutableBlockPos> positionConsumer, RingPositionTest test, BlockPos centerPos, int radius) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.set((Vec3i)centerPos);
        SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
        mutablePos.set((Vec3i)centerPos);
        SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, Direction.NORTH, test);
        int r = radius + 2;
        for (int i = 1; i < r; ++i) {
            mutablePos.set(centerPos.getX(), centerPos.getY() - i, centerPos.getZ());
            SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            mutablePos.set(centerPos.getX(), centerPos.getY() + i, centerPos.getZ());
            SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            mutablePos.set(centerPos.getX(), centerPos.getY(), centerPos.getZ() - i);
            SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, Direction.NORTH, test);
            mutablePos.set(centerPos.getX(), centerPos.getY(), centerPos.getZ() + i);
            SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, Direction.NORTH, test);
        }
    }

    public static boolean movePositionToRing(BlockPos.MutableBlockPos posMutable, Direction moveDirection, RingPositionTest test) {
        int incX = moveDirection.getStepX();
        int incY = moveDirection.getStepY();
        int incZ = moveDirection.getStepZ();
        int x = posMutable.getX();
        int y = posMutable.getY();
        int z = posMutable.getZ();
        int nextX = x;
        int nextY = y;
        int nextZ = z;
        while (test.isInsideOrCloserThan(nextX, nextY, nextZ, moveDirection)) {
            x = nextX;
            y = nextY;
            z = nextZ;
            nextX += incX;
            nextY += incY;
            nextZ += incZ;
        }
        if (x != nextX || y != nextY | z != nextZ) {
            posMutable.set(x, y, z);
            return true;
        }
        return false;
    }

    public static void addPositionsOnHorizontalBlockRing(Consumer<BlockPos.MutableBlockPos> positionConsumer, BlockPos.MutableBlockPos mutablePos, RingPositionTest test) {
        Function<Direction, Direction> nextDirectionFunction = SphereUtils::getNextHorizontalDirection;
        Direction startDirection = Direction.EAST;
        SphereUtils.addPositionsOnBlockRing(positionConsumer, mutablePos, startDirection, test, nextDirectionFunction);
    }

    public static void addPositionsOnVerticalBlockRing(Consumer<BlockPos.MutableBlockPos> positionConsumer, BlockPos.MutableBlockPos mutablePos, Direction mainAxis, RingPositionTest test) {
        Function<Direction, Direction> nextDirectionFunction = dir -> SphereUtils.getNextVerticalRingDirection(dir, mainAxis);
        Direction startDirection = Direction.UP;
        SphereUtils.addPositionsOnBlockRing(positionConsumer, mutablePos, startDirection, test, nextDirectionFunction);
    }

    public static void addPositionsOnBlockRing(Consumer<BlockPos.MutableBlockPos> positionConsumer, BlockPos.MutableBlockPos mutablePos, Direction startDirection, RingPositionTest test, Function<Direction, Direction> nextDirectionFunction) {
        if (SphereUtils.movePositionToRing(mutablePos, startDirection, test)) {
            LongOpenHashSet seenPositions = new LongOpenHashSet();
            BlockPos firstPos = mutablePos.immutable();
            Direction direction = startDirection;
            positionConsumer.accept(mutablePos);
            while (true) {
                direction = SphereUtils.getNextPositionOnBlockRing(mutablePos, direction, test, nextDirectionFunction);
                long posLong = mutablePos.asLong();
                if (direction == null || mutablePos.equals((Object)firstPos) || seenPositions.contains(posLong)) break;
                positionConsumer.accept(mutablePos);
                seenPositions.add(posLong);
            }
        }
    }

    @Nullable
    public static Direction getNextPositionOnBlockRing(BlockPos.MutableBlockPos posMutable, Direction escapeDirection, RingPositionTest test, Function<Direction, Direction> nextDirectionFunction) {
        Direction dirOut = escapeDirection;
        for (int i = 0; i < 4; ++i) {
            int z;
            int y;
            int x = posMutable.getX() + escapeDirection.getStepX();
            if (test.isInsideOrCloserThan(x, y = posMutable.getY() + escapeDirection.getStepY(), z = posMutable.getZ() + escapeDirection.getStepZ(), escapeDirection)) {
                posMutable.set(x, y, z);
                return dirOut;
            }
            Direction ccw90 = nextDirectionFunction.apply(escapeDirection);
            if (test.isInsideOrCloserThan(x += ccw90.getStepX(), y += ccw90.getStepY(), z += ccw90.getStepZ(), escapeDirection)) {
                posMutable.set(x, y, z);
                return dirOut;
            }
            dirOut = escapeDirection;
            escapeDirection = nextDirectionFunction.apply(escapeDirection);
        }
        return null;
    }

    public static boolean isPositionInsideOrClosestToRadiusOnBlockRing(int blockX, int blockY, int blockZ, Vec3 center, double squareRadius, Direction escapeDirection) {
        double x = (double)blockX + 0.5;
        double y = (double)blockY + 0.5;
        double z = (double)blockZ + 0.5;
        double dist = center.distanceToSqr(x, y, z);
        double diff = squareRadius - dist;
        return diff >= 0.0;
    }

    public static Direction getNextHorizontalDirection(Direction dirIn) {
        return dirIn.getCounterClockWise();
    }

    public static Direction getNextVerticalRingDirection(Direction currentDirection, Direction mainAxis) {
        return switch (mainAxis) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> {
                switch (currentDirection) {
                    case NORTH: {
                        yield Direction.DOWN;
                    }
                    case SOUTH: {
                        yield Direction.UP;
                    }
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                }
                yield Direction.NORTH;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                switch (currentDirection) {
                    case WEST: {
                        yield Direction.UP;
                    }
                    case EAST: {
                        yield Direction.DOWN;
                    }
                    case DOWN: {
                        yield Direction.WEST;
                    }
                }
                yield Direction.EAST;
            }
            case Direction.WEST, Direction.EAST -> {
                switch (currentDirection) {
                    case NORTH: {
                        yield Direction.UP;
                    }
                    case SOUTH: {
                        yield Direction.DOWN;
                    }
                    case DOWN: {
                        yield Direction.NORTH;
                    }
                }
                yield Direction.SOUTH;
            }
        };
    }

    public static Direction[] getDirectionsNotOnAxis(Direction.Axis axis) {
        Direction[] sides = new Direction[4];
        int index = 0;
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            if (side.getAxis() == axis) continue;
            sides[index++] = side;
        }
        return sides;
    }

    public static List<SideQuad> buildSphereShellToQuads(LongOpenHashSet positions, Direction.Axis mainAxis, RingPositionTest test, ShapeRenderType renderType, LayerRange layerRange) {
        Long2ObjectOpenHashMap<SideQuad> strips = SphereUtils.buildSphereShellToStrips(positions, mainAxis, test, renderType, layerRange);
        return SphereUtils.buildStripsToQuads(strips, mainAxis);
    }

    public static Long2ObjectOpenHashMap<SideQuad> buildSphereShellToStrips(LongOpenHashSet positions, Direction.Axis mainAxis, RingPositionTest test, ShapeRenderType renderType, LayerRange layerRange) {
        Long2ObjectOpenHashMap strips = new Long2ObjectOpenHashMap();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        Direction[] sides = PositionUtils.ALL_DIRECTIONS;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            if (!layerRange.isPositionWithinRange(pos)) continue;
            for (Direction side : sides) {
                if (SphereUtils.isHandledAndMarkHandled(pos, side, handledPositions) || !SphereUtils.shouldRenderSide(pos, side, test, renderType, positions)) continue;
                Direction minDir = side.getAxis() != mainAxis ? SphereUtils.getNegativeDirectionFor(SphereUtils.getThirdAxis(mainAxis, side.getAxis())) : (mainAxis.isVertical() ? Direction.WEST : Direction.DOWN);
                Direction maxDir = minDir.getOpposite();
                int lengthMin = SphereUtils.getStripLengthOnSide(pos, side, minDir, test, renderType, positions, handledPositions);
                int lengthMax = SphereUtils.getStripLengthOnSide(pos, side, maxDir, test, renderType, positions, handledPositions);
                long startPosLong = SphereUtils.offsetPos(pos, minDir, lengthMin);
                int length = lengthMin + lengthMax + 1;
                long index = SphereUtils.getCompressedPosSide(startPosLong, side);
                strips.put(index, (Object)new SideQuad(startPosLong, length, 1, side));
            }
        }
        return strips;
    }

    public static List<SideQuad> buildStripsToQuads(Long2ObjectOpenHashMap<SideQuad> strips, Direction.Axis mainAxis) {
        ArrayList<SideQuad> quads = new ArrayList<SideQuad>();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        for (SideQuad strip : strips.values()) {
            Direction side;
            long pos = strip.startPos();
            if (SphereUtils.isHandledAndMarkHandled(pos, side = strip.side(), handledPositions)) continue;
            Direction minDir = side.getAxis() != mainAxis ? SphereUtils.getNegativeDirectionFor(mainAxis) : (mainAxis.isVertical() ? Direction.NORTH : Direction.DOWN);
            Direction maxDir = minDir.getOpposite();
            int stripCountMin = SphereUtils.getStripCountOnSide(strip, minDir, strips, handledPositions);
            int stripCountMax = SphereUtils.getStripCountOnSide(strip, maxDir, strips, handledPositions);
            long startPos = SphereUtils.offsetPos(pos, minDir, stripCountMin);
            int height = stripCountMin + stripCountMax + 1;
            quads.add(new SideQuad(startPos, strip.width(), height, side));
        }
        return quads;
    }

    protected static int getStripCountOnSide(SideQuad startStrip, Direction offsetSide, Long2ObjectOpenHashMap<SideQuad> strips, Long2ByteOpenHashMap handledPositions) {
        long index;
        SideQuad adjStrip;
        long startPos = startStrip.startPos();
        Direction side = startStrip.side();
        int width = startStrip.width();
        long adjPos = BlockPos.offset((long)startPos, (Direction)offsetSide);
        int count = 0;
        while ((adjStrip = (SideQuad)strips.get(index = SphereUtils.getCompressedPosSide(adjPos, side))) != null && adjStrip.width() == width && !SphereUtils.isHandledAndMarkHandled(adjPos, side, handledPositions)) {
            ++count;
            adjPos = BlockPos.offset((long)adjPos, (Direction)offsetSide);
        }
        return count;
    }

    protected static int getStripLengthOnSide(long pos, Direction side, Direction moveDirection, RingPositionTest test, ShapeRenderType renderType, LongOpenHashSet positions, Long2ByteOpenHashMap handledPositions) {
        int length = 0;
        long adjPos = BlockPos.offset((long)pos, (Direction)moveDirection);
        while (positions.contains(adjPos) && SphereUtils.shouldRenderSide(adjPos, side, test, renderType, positions) && !SphereUtils.isHandledAndMarkHandled(adjPos, side, handledPositions)) {
            ++length;
            adjPos = BlockPos.offset((long)adjPos, (Direction)moveDirection);
        }
        return length;
    }

    public static boolean isHandledAndMarkHandled(long pos, Direction side, Long2ByteOpenHashMap handledPositions) {
        byte sideMask = (byte)(1 << side.get3DDataValue());
        byte val = handledPositions.get(pos);
        if ((val & sideMask) != 0) {
            return true;
        }
        val = (byte)(val | sideMask);
        handledPositions.put(pos, val);
        return false;
    }

    protected static boolean shouldRenderSide(long pos, Direction side, RingPositionTest test, ShapeRenderType renderType, LongOpenHashSet positions) {
        long adjPos = BlockPos.offset((long)pos, (Direction)side);
        if (positions.contains(adjPos)) {
            return false;
        }
        if (renderType == ShapeRenderType.FULL_BLOCK) {
            return true;
        }
        int adjX = BlockPos.getX((long)adjPos);
        int adjY = BlockPos.getY((long)adjPos);
        int adjZ = BlockPos.getZ((long)adjPos);
        boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
        return renderType == ShapeRenderType.OUTER_EDGE && !onOrIn || renderType == ShapeRenderType.INNER_EDGE && onOrIn;
    }

    public static Direction getNegativeDirectionFor(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> Direction.WEST;
            case Direction.Axis.Y -> Direction.DOWN;
            case Direction.Axis.Z -> Direction.NORTH;
        };
    }

    public static Direction getPositiveDirectionFor(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> Direction.EAST;
            case Direction.Axis.Y -> Direction.UP;
            case Direction.Axis.Z -> Direction.SOUTH;
        };
    }

    public static Direction.Axis getThirdAxis(Direction.Axis axis1, Direction.Axis axis2) {
        return switch (axis1) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (axis2 == Direction.Axis.Y) {
                    yield Direction.Axis.Z;
                }
                yield Direction.Axis.Y;
            }
            case Direction.Axis.Y -> {
                if (axis2 == Direction.Axis.X) {
                    yield Direction.Axis.Z;
                }
                yield Direction.Axis.X;
            }
            case Direction.Axis.Z -> axis2 == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X;
        };
    }

    public static long offsetPos(long pos, Direction direction, int amount) {
        return BlockPos.offset((long)pos, (int)(direction.getStepX() * amount), (int)(direction.getStepY() * amount), (int)(direction.getStepZ() * amount));
    }

    public static long getCompressedPosSide(long pos, Direction side) {
        int x = BlockPos.getX((long)pos);
        int y = BlockPos.getY((long)pos);
        int z = BlockPos.getZ((long)pos);
        long val = 1L << side.get3DDataValue() << 58;
        val |= ((long)y & 0x3FFFL) << 44;
        val |= ((long)z & 0x3FFFFFL) << 22;
        return val |= (long)x & 0x3FFFFFL;
    }

    public static interface RingPositionTest {
        public boolean isInsideOrCloserThan(int var1, int var2, int var3, Direction var4);
    }
}

