/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.horsedebug;

import com.google.common.collect.Lists;
import fr.atesab.horsedebug.BuildAPI;
import fr.atesab.horsedebug.StatValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1451;
import net.minecraft.class_1472;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1767;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_5134;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7375;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class HorseDebugMain {
    public static final String UTF8_STAR = "\u2b50";
    public static final String UTF8_HEART = "\u2764";
    private static final Logger log = LogManager.getLogger((String)"HorseDebug");
    private static HorseDebugMain instance;
    private boolean show3DOverlay;
    private class_304 configKey;
    public static final StatValue STAT_HEALTH;
    public static final StatValue STAT_JUMP;
    public static final StatValue STAT_SPEED;
    @Deprecated
    public static final double BAD_HP;
    @Deprecated
    public static final double BAD_JUMP;
    @Deprecated
    public static final double BAD_SPEED;
    @Deprecated
    public static final double EXELLENT_HP;
    @Deprecated
    public static final double EXELLENT_JUMP;
    @Deprecated
    public static final double EXELLENT_SPEED;

    public static void log(String message) {
        log.info("[" + log.getName() + "] " + message);
    }

    private static double getBaseValue(class_1309 entity, class_6880<class_1320> attribute) {
        class_1324 inst = entity.method_5996(attribute);
        if (inst == null) {
            return ((class_1320)attribute.comp_349()).method_6169();
        }
        return inst.method_6201();
    }

    public static HorseDebugMain getMod() {
        return instance;
    }

    public static boolean isAPIRegister() {
        return instance != null;
    }

    public static HorseDebugMain registerAPI(BuildAPI api) throws IllegalStateException {
        instance = new HorseDebugMain();
        HorseDebugMain.log("Starting HorseDebug with " + api.getAPIName());
        return instance;
    }

    public static String getHorseColorNameDescription(class_5149 color) {
        return color.method_15434();
    }

    public static String getHorseColorNameDescription(class_5148 color) {
        return color.name().toLowerCase();
    }

    public static String getHorseColorName(class_5149 color, class_5148 marking) {
        return class_1074.method_4662((String)("gui.act.invView.horse.variant." + HorseDebugMain.getHorseColorNameDescription(color)), (Object[])new Object[0]) + " / " + class_1074.method_4662((String)("gui.act.invView.horse.variant.marking." + HorseDebugMain.getHorseColorNameDescription(marking)), (Object[])new Object[0]);
    }

    public static String getCatColorName(class_6880<class_7375> color) {
        Optional key = color.method_40230();
        if (key.isEmpty()) {
            return class_1074.method_4662((String)"gui.act.invView.cat.variant.unknown", (Object[])new Object[0]);
        }
        return class_1074.method_4662((String)("gui.act.invView.cat.variant." + ((class_5321)key.get()).method_29177().method_12832()), (Object[])new Object[0]);
    }

    private HorseDebugMain() {
        if (HorseDebugMain.isAPIRegister()) {
            throw new IllegalStateException("An API is already register for this mod!");
        }
    }

    public void drawInventory(class_332 drawContext, class_310 mc, int posX, int posY, String[] addText, class_1309 entity) {
        int l = addText.length;
        if (l == 0) {
            return;
        }
        int sizeX = 0;
        int sizeY = 0;
        for (String s : addText) {
            Objects.requireNonNull(mc.field_1772);
            sizeY += 9 + 1;
            int a = mc.field_1772.method_1727(s) + 10;
            if (a <= sizeX) continue;
            sizeX = a;
        }
        if (entity != null) {
            sizeX += 100;
            if (sizeY < 100) {
                sizeY = 100;
            }
        }
        class_1041 mw = mc.method_22683();
        posY += 5;
        if ((posX += 5) + sizeX > mw.method_4486()) {
            posX -= sizeX + 10;
        }
        if (posY + sizeY > mw.method_4502()) {
            posY -= sizeY + 10;
        }
        int posY1 = posY + 5;
        for (String s : addText) {
            drawContext.method_25303(mc.field_1772, s, posX + 5, posY1, -1);
            Objects.requireNonNull(mc.field_1772);
            posY1 += 9 + 1;
        }
        if (entity != null) {
            int lx = posX + sizeX - 55;
            int ly = posY + 2;
            class_490.method_2486((class_332)drawContext, (int)(lx - 25), (int)(ly - 25), (int)(lx + 75), (int)(ly + 75), (int)30, (float)0.0f, (float)0.0f, (float)((float)ly + 37.5f), (class_1309)entity);
        }
    }

    private static double getJump(class_1309 e) {
        return HorseDebugMain.getBaseValue(e, (class_6880<class_1320>)class_5134.field_23728);
    }

    public String[] getEntityData(class_1309 entity) {
        ArrayList text = Lists.newArrayList();
        text.add("\u00a7b" + entity.method_5476().getString());
        text.add("\u00a77" + class_1299.method_5890((class_1299)entity.method_5864()).toString());
        if (entity instanceof class_1451) {
            class_1451 cat = (class_1451)entity;
            class_6880 color = cat.method_47843();
            text.add(class_1074.method_4662((String)"gui.act.invView.horse.variant", (Object[])new Object[0]) + ": " + HorseDebugMain.getCatColorName((class_6880<class_7375>)color) + " (" + (String)color.method_40230().map(k -> k.method_29177().method_12832()).orElse(null) + ")");
        } else if (entity instanceof class_1472) {
            class_1472 sheep = (class_1472)entity;
            class_1767 color = sheep.method_6633();
            text.add(class_1074.method_4662((String)"gui.act.invView.horse.variant", (Object[])new Object[0]) + ": " + color.method_7792() + " (" + color.method_7789() + ")");
        } else if (entity instanceof class_1496) {
            class_1496 baby = (class_1496)entity;
            if (baby instanceof class_1498) {
                class_1498 horse = (class_1498)baby;
                class_5149 color = horse.method_27077();
                class_5148 markings = horse.method_27078();
                int id = color.method_27082() + markings.method_27079() << 8;
                text.add(class_1074.method_4662((String)"gui.act.invView.horse.variant", (Object[])new Object[0]) + ": " + HorseDebugMain.getHorseColorName(color, markings) + " (" + id + ")");
            }
            text.add(class_1074.method_4662((String)"gui.act.invView.horse.jump", (Object[])new Object[0]) + ": " + STAT_JUMP.getFormattedText(HorseDebugMain.getJump((class_1309)baby)));
            text.add(class_1074.method_4662((String)"gui.act.invView.horse.speed", (Object[])new Object[0]) + ": " + STAT_SPEED.getFormattedText(HorseDebugMain.getBaseValue((class_1309)baby, (class_6880<class_1320>)class_5134.field_23719)) + " m/s (" + HorseDebugMain.significantNumbers(HorseDebugMain.getBaseValue((class_1309)baby, (class_6880<class_1320>)class_5134.field_23719)) + " iu)");
            text.add(class_1074.method_4662((String)"gui.act.invView.horse.health", (Object[])new Object[0]) + ": " + STAT_HEALTH.getFormattedText(baby.method_6063()) + " HP");
        }
        return (String[])text.toArray(String[]::new);
    }

    public static String significantNumbers(double d) {
        boolean negative;
        boolean bl = negative = d < 0.0;
        if (negative) {
            d *= -1.0;
        }
        int d1 = (int)d;
        String s = String.format("%.3G", d %= 1.0);
        if (s.length() > 0) {
            s = s.substring(1);
        }
        if (s.contains("E+")) {
            s = String.format(Locale.US, "%.0f", Double.valueOf(String.format("%.3G", d)));
        }
        return (negative ? "-" : "") + d1 + s;
    }

    public void renderOverlay(class_332 drawContext) {
        class_310 mc = class_310.method_1551();
        if (!mc.field_1705.method_53531().method_53536()) {
            return;
        }
        class_1041 mw = mc.method_22683();
        class_1297 class_12972 = mc.field_1724.method_5854();
        if (class_12972 instanceof class_1496) {
            class_1496 baby = (class_1496)class_12972;
            this.drawInventory(drawContext, mc, mw.method_4486(), mw.method_4502(), this.getEntityData((class_1309)baby), (class_1309)baby);
        } else {
            class_3966 eo;
            class_1297 class_12973;
            class_239 obj = mc.field_1765;
            if (obj instanceof class_3966 && (class_12973 = (eo = (class_3966)obj).method_17782()) instanceof class_1309) {
                class_1309 le = (class_1309)class_12973;
                this.drawInventory(drawContext, mc, mw.method_4486(), mw.method_4502(), this.getEntityData(le), le);
            }
        }
    }

    public double score(double jump, double health, double speed) {
        return STAT_JUMP.normalized(jump) + STAT_HEALTH.normalized(health) + STAT_SPEED.normalized(speed);
    }

    public void renderWorld(Iterable<class_1297> entities, class_4587 matrices, class_4184 camera, class_4597 source) {
        double score;
        double speed;
        double health;
        double jump;
        if (!this.show3DOverlay) {
            return;
        }
        ArrayList<class_1496> horses = new ArrayList<class_1496>();
        double bestScore = 0.0;
        double bestJump = 0.0;
        double bestSpeed = 0.0;
        double bestHealth = 0.0;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        for (class_1297 entity : entities) {
            if (!(entity instanceof class_1496)) continue;
            class_1496 h = (class_1496)entity;
            double distance = player.method_19538().method_1025(h.method_19538());
            if (distance > 4096.0) continue;
            horses.add(h);
            jump = HorseDebugMain.getJump((class_1309)h);
            health = h.method_6063();
            speed = HorseDebugMain.getBaseValue((class_1309)h, (class_6880<class_1320>)class_5134.field_23719);
            score = this.score(jump, health, speed);
            if (jump > bestJump) {
                bestJump = jump;
            }
            if (health > bestHealth) {
                bestHealth = health;
            }
            if (speed > bestSpeed) {
                bestSpeed = speed;
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
        }
        class_327 textRenderer = mc.field_1772;
        float opacity = mc.field_1690.method_19343(0.25f);
        class_2561[] texts = new class_2561[4];
        for (class_1496 h : horses) {
            int n;
            jump = HorseDebugMain.getJump((class_1309)h);
            health = h.method_6063();
            speed = HorseDebugMain.getBaseValue((class_1309)h, (class_6880<class_1320>)class_5134.field_23719);
            score = this.score(jump, health, speed);
            texts[0] = class_2561.method_43470((String)STAT_JUMP.getFormattedText(jump, " b", jump >= bestJump));
            texts[1] = class_2561.method_43470((String)STAT_HEALTH.getFormattedText(health, " " + String.valueOf(class_124.field_1061) + UTF8_HEART, health >= bestHealth));
            texts[2] = class_2561.method_43470((String)STAT_SPEED.getFormattedText(speed, " m/s", speed >= bestSpeed));
            texts[3] = score >= bestScore ? class_2561.method_43470((String)(String.valueOf(class_124.field_1054) + UTF8_STAR)) : null;
            float textHeight = h.method_17682() + 0.5f;
            class_1496 e = h;
            while (!e.method_5685().isEmpty()) {
                e = (class_1297)e.method_5685().get(0);
            }
            double textY = e.method_23318();
            matrices.method_22903();
            matrices.method_22904(h.method_23317() - camera.method_19326().field_1352, textY - camera.method_19326().field_1351 + (double)textHeight, h.method_23321() - camera.method_19326().field_1350);
            matrices.method_22907(camera.method_23767());
            matrices.method_22905(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            int background = (int)(opacity * 255.0f) << 24;
            if (h.method_16914()) {
                Objects.requireNonNull(textRenderer);
                n = -(9 + 4);
            } else {
                n = 0;
            }
            int y = n;
            for (class_2561 text : texts) {
                if (text == null) continue;
                float x = -textRenderer.method_27525((class_5348)text) / 2;
                textRenderer.method_30882(text, x, (float)y, -1, false, matrix4f, source, class_327.class_6415.field_33993, background, 0xF000F0);
                textRenderer.method_30882(text, x, (float)y, 0x22FFFFFF, false, matrix4f, source, class_327.class_6415.field_33994, 0, 0xF000F0);
                Objects.requireNonNull(textRenderer);
                y -= 9 + 2;
            }
            matrices.method_22909();
        }
    }

    public void setup() {
        HorseDebugMain.log("Initialization");
        this.configKey = new class_304("gui.act.invView.horse", class_3675.field_16237.method_1444(), "key.categories.horsedebug");
        KeyBindingHelper.registerKeyBinding((class_304)this.configKey);
        this.syncConfig();
    }

    public void onKey() {
        if (this.configKey.method_1436()) {
            this.setShow3DOverlay(!this.isShow3DOverlay());
        }
    }

    public void setShow3DOverlay(boolean show3DOverlay) {
        this.show3DOverlay = show3DOverlay;
        this.saveConfig();
    }

    public boolean isShow3DOverlay() {
        return this.show3DOverlay;
    }

    public void syncConfig() {
        Properties prop = new Properties();
        try (InputStream stream = Files.newInputStream(this.getConfigFile(), new OpenOption[0]);){
            prop.load(stream);
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
        this.show3DOverlay = String.valueOf(prop.getOrDefault((Object)"show3DOverlay", (Object)this.show3DOverlay)).equals("true");
        this.saveConfig();
    }

    public void saveConfig() {
        Properties prop = new Properties();
        prop.setProperty("show3DOverlay", String.valueOf(this.show3DOverlay));
        try (OutputStream stream = Files.newOutputStream(this.getConfigFile(), new OpenOption[0]);){
            prop.store(stream, "");
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public Path getConfigFile() {
        return class_310.method_1551().field_1697.toPath().resolve("horsedebug.cfg");
    }

    static {
        STAT_HEALTH = StatValue.builder().base(15.0).add(8.0).add(9.0).showScale(0.5).build();
        STAT_JUMP = StatValue.builder().base(0.4f).add(0.2).add(0.2).add(0.2).showFunc(d -> -0.2 * Math.pow(d, 3.0) + 3.7 * Math.pow(d, 2.0) + 2.1 * d - 0.4).build();
        STAT_SPEED = StatValue.builder().base(0.45f).add(0.3).add(0.3).add(0.3).scale(0.25).showScale(43.0).build();
        BAD_HP = STAT_HEALTH.getBadValue();
        BAD_JUMP = STAT_JUMP.getBadValue();
        BAD_SPEED = STAT_SPEED.getBadValue();
        EXELLENT_HP = STAT_HEALTH.getExcellentValue();
        EXELLENT_JUMP = STAT_JUMP.getExcellentValue();
        EXELLENT_SPEED = STAT_HEALTH.getExcellentValue();
    }
}

