/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.horsedebug;

import fr.atesab.horsedebug.HorseDebugMain;
import java.util.function.DoubleFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;

@Environment(value=EnvType.CLIENT)
public class StatValue {
    private final double min;
    private final double max;
    private final DoubleFunction<Double> showFunction;

    public static StatValueBuilder builder() {
        return new StatValueBuilder();
    }

    private StatValue(double min, double max, DoubleFunction<Double> showFunction) {
        this.min = min;
        this.max = max;
        this.showFunction = showFunction;
    }

    public double getMax() {
        return this.max;
    }

    public double getAverage() {
        return (this.max + this.min) / 2.0;
    }

    public double getMin() {
        return this.min;
    }

    public double getScale() {
        return this.max - this.min;
    }

    public double normalized(double value) {
        return value / this.getScale();
    }

    public double getBadValue() {
        return this.getMin() + this.getScale() / 5.0;
    }

    public double getExcellentValue() {
        return this.getMax() - this.getScale() / 5.0;
    }

    public String getFormattedText(double value) {
        return this.getFormattedText(value, "", false);
    }

    public String getFormattedText(double value, String unit, boolean stared) {
        return String.valueOf(value >= this.getExcellentValue() ? class_124.field_1065 : (value <= this.getBadValue() ? class_124.field_1061 : class_124.field_1060)) + HorseDebugMain.significantNumbers(this.showFunction.apply(value)) + unit + (String)(stared ? String.valueOf(class_124.field_1054) + " \u2b50" : "");
    }

    @Environment(value=EnvType.CLIENT)
    public static class StatValueBuilder {
        private double base = 0.0;
        private double scale = 1.0;
        private double added = 0.0;
        private DoubleFunction<Double> showFunction = d -> d;

        private StatValueBuilder() {
        }

        public StatValueBuilder base(double base) {
            this.base += base;
            return this;
        }

        public StatValueBuilder scale(double scale) {
            this.scale *= scale;
            return this;
        }

        public StatValueBuilder showScale(double scale) {
            return this.showFunc(d -> d * scale);
        }

        public StatValueBuilder showFunc(DoubleFunction<Double> showFunction) {
            this.showFunction = showFunction;
            return this;
        }

        public StatValueBuilder add(double value) {
            this.added += value;
            return this;
        }

        public StatValue build() {
            double min = this.base * this.scale;
            double max = (this.base + this.added) * this.scale;
            return new StatValue(min, max, this.showFunction);
        }
    }
}

