/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.zelythia.AutoToolsConfig;
import net.zelythia.ItemMiningSpeed;
import net.zelythia.clientTags.ClientTags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoTools {
    public static final String MOD_ID = "autotools";
    public static final Logger LOGGER = LogManager.getLogger((String)"AutoTools");
    public static final TagKey<Block> SHEARS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"shears"));
    public static final TagKey<Block> SILK_TOUCH = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"silk_touch"));
    public static final TagKey<Block> SILK_TOUCH_SETTING_ALWAYS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"silk_touch_setting_always"));
    public static final TagKey<Block> SILK_TOUCH_SETTING_ALWAYS_ORES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"silk_touch_setting_always_ores"));
    public static final TagKey<Block> SILK_TOUCH_SETTING_ALWAYS_EXC_ORES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"silk_touch_setting_always_exc_ores"));
    public static final TagKey<Block> FORTUNE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"fortune"));
    public static final TagKey<Block> FORTUNE_SETTING = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"fortune_setting"));
    public static final TagKey<Block> DO_NOT_SWAP_UNLESS_ENCH = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"do_not_swap_unless_ench"));
    public static final HashMap<ResourceLocation, List<ResourceLocation>> CUSTOM_TOOLS = new HashMap();
    private static final HashMap<String, ResourceLocation[]> TOOL_LISTS = new HashMap<String, ResourceLocation[]>(){
        {
            this.put("autotools:pickaxe", new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:netherite_pickaxe"), ResourceLocation.parse((String)"minecraft:diamond_pickaxe"), ResourceLocation.parse((String)"minecraft:iron_pickaxe"), ResourceLocation.parse((String)"minecraft:golden_pickaxe"), ResourceLocation.parse((String)"minecraft:stone_pickaxe"), ResourceLocation.parse((String)"minecraft:wooden_pickaxe")});
            this.put("autotools:shovel", new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:netherite_shovel"), ResourceLocation.parse((String)"minecraft:diamond_shovel"), ResourceLocation.parse((String)"minecraft:iron_shovel"), ResourceLocation.parse((String)"minecraft:golden_shovel"), ResourceLocation.parse((String)"minecraft:stone_shovel"), ResourceLocation.parse((String)"minecraft:wooden_shovel")});
            this.put("autotools:hoe", new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:netherite_hoe"), ResourceLocation.parse((String)"minecraft:diamond_hoe"), ResourceLocation.parse((String)"minecraft:iron_hoe"), ResourceLocation.parse((String)"minecraft:golden_hoe"), ResourceLocation.parse((String)"minecraft:stone_hoe"), ResourceLocation.parse((String)"minecraft:wooden_hoe")});
            this.put("autotools:sword", new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:netherite_sword"), ResourceLocation.parse((String)"minecraft:diamond_sword"), ResourceLocation.parse((String)"minecraft:iron_sword"), ResourceLocation.parse((String)"minecraft:golden_sword"), ResourceLocation.parse((String)"minecraft:stone_sword"), ResourceLocation.parse((String)"minecraft:wooden_sword")});
            this.put("autotools:axe", new ResourceLocation[]{ResourceLocation.parse((String)"minecraft:netherite_axe"), ResourceLocation.parse((String)"minecraft:diamond_axe"), ResourceLocation.parse((String)"minecraft:iron_axe"), ResourceLocation.parse((String)"minecraft:golden_axe"), ResourceLocation.parse((String)"minecraft:stone_axe"), ResourceLocation.parse((String)"minecraft:wooden_axe")});
        }
    };
    public static final Stack<Integer> swaps = new Stack();
    public static boolean toggle = true;
    public static boolean startedMining = false;
    public static boolean swapped = false;

    public static void init() {
        AutoTools.reloadConfig();
    }

    public static void reloadConfig() {
        AutoToolsConfig.load();
        CUSTOM_TOOLS.put(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"bamboo"), new ArrayList<ResourceLocation>(Arrays.asList(TOOL_LISTS.get("autotools:sword"))));
        AutoTools.loadCustomItems();
        AutoToolsConfig.IGNORED_SLOTS = AutoToolsConfig.IGNORED_SLOTS.stream().map(i -> i - 1).toList();
        AutoToolsConfig.TARGET_SLOTS = AutoToolsConfig.TARGET_SLOTS.stream().map(i -> i - 1).toList();
    }

    private static void loadCustomItems() {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)AutoToolsConfig.CUSTOM_TOOLS);
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject jsonObject = (JsonObject)jsonElement;
            for (String key : jsonObject.keySet()) {
                ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
                if (jsonObject.get(key).isJsonArray()) {
                    JsonArray toolsArray = jsonObject.getAsJsonArray(key);
                    for (int i = 0; i < toolsArray.size(); ++i) {
                        if (TOOL_LISTS.containsKey(toolsArray.get(i).getAsString())) {
                            tools.addAll(Arrays.asList(TOOL_LISTS.get(toolsArray.get(i).getAsString())));
                            continue;
                        }
                        tools.add(ResourceLocation.parse((String)toolsArray.get(i).getAsString()));
                    }
                } else if (TOOL_LISTS.containsKey(jsonObject.get(key).getAsString())) {
                    tools.addAll(List.of(TOOL_LISTS.get(jsonObject.get(key).getAsString())));
                } else {
                    tools.add(ResourceLocation.parse((String)jsonObject.get(key).getAsString()));
                }
                CUSTOM_TOOLS.computeIfAbsent(ResourceLocation.parse((String)key), k -> new ArrayList()).addAll(tools);
            }
            LOGGER.info("Loaded custom block configs: " + String.valueOf(CUSTOM_TOOLS.keySet()));
        }
        catch (Exception e) {
            LOGGER.error("Error while parsing custom blocks");
        }
    }

    public static void onBlockBreaking(Minecraft client, HitResult hitResult) {
        if (AutoToolsConfig.TOGGLE && toggle) {
            if (client.player.isCreative()) {
                if (!AutoToolsConfig.DISABLECREATIVE) {
                    AutoTools.getCorrectTool(hitResult, client);
                }
            } else {
                AutoTools.getCorrectTool(hitResult, client);
            }
        }
    }

    public static void selectItem(Minecraft client, Inventory inventory, int sourceSlot) {
        int destSlot;
        if (sourceSlot == inventory.getSelectedSlot()) {
            return;
        }
        if (swaps.empty()) {
            swaps.push(inventory.getSelectedSlot());
        }
        if (sourceSlot <= 8 && !AutoToolsConfig.KEEPSLOT) {
            if (((Integer)swaps.getLast()).intValue() != inventory.getSelectedSlot() && swaps.peek() != sourceSlot) {
                swaps.push(inventory.getSelectedSlot());
            }
            inventory.setSelectedSlot(sourceSlot);
            return;
        }
        if (sourceSlot <= 8) {
            sourceSlot += 36;
        }
        int n = destSlot = AutoToolsConfig.KEEPSLOT ? inventory.getSelectedSlot() : AutoTools.getSuitableHotbarSlot(inventory);
        if (!AutoToolsConfig.TARGET_SLOTS.contains(destSlot)) {
            destSlot = AutoToolsConfig.TARGET_SLOTS.getFirst();
        }
        if (swaps.peek() != sourceSlot) {
            swaps.push(sourceSlot);
        }
        if (swaps.peek() != destSlot) {
            swaps.push(destSlot);
        }
        swapped = true;
        client.gameMode.handleInventoryMouseClick(client.player.inventoryMenu.containerId, sourceSlot, destSlot, ClickType.SWAP, (Player)client.player);
        inventory.setSelectedSlot(destSlot);
        inventory.setChanged();
        if (!AutoToolsConfig.SWITCH_BACK) {
            swaps.clear();
        }
    }

    public static int getSuitableHotbarSlot(Inventory inventory) {
        int j;
        int i;
        for (i = 0; i < 9; ++i) {
            j = (inventory.getSelectedSlot() + i) % 9;
            if (!AutoToolsConfig.TARGET_SLOTS.contains(j) || !inventory.getItem(j).isEmpty()) continue;
            return j;
        }
        for (i = 0; i < 9; ++i) {
            j = (inventory.getSelectedSlot() + i) % 9;
            if (!AutoToolsConfig.TARGET_SLOTS.contains(j) || inventory.getItem(j).isEnchanted()) continue;
            return j;
        }
        return inventory.getSelectedSlot();
    }

    public static void switchBack() {
        if (Minecraft.getInstance().options.keyAttack.isDown() || swaps.empty()) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client.player == null || client.gameMode == null) {
            return;
        }
        Inventory inventory = client.player.getInventory();
        boolean changed = true;
        block0: while (changed && swaps.size() > 1) {
            changed = false;
            for (int intervalSize = swaps.size() / 2; intervalSize >= 2; --intervalSize) {
                for (int topOffset = 0; topOffset <= swaps.size() / intervalSize; ++topOffset) {
                    boolean foundDuplicate = true;
                    if (swaps.size() - 1 - topOffset >= 2 * intervalSize) {
                        for (int j = topOffset; j < intervalSize + topOffset; ++j) {
                            if (swaps.elementAt(swaps.size() - j - 1) == swaps.elementAt(swaps.size() - 1 - intervalSize - j)) continue;
                            foundDuplicate = false;
                            break;
                        }
                    } else {
                        foundDuplicate = false;
                    }
                    if (!foundDuplicate) continue;
                    int initialSize = swaps.size();
                    for (int i = 0; i < intervalSize * 2; ++i) {
                        swaps.remove(initialSize - topOffset - intervalSize * 2);
                    }
                    changed = true;
                    continue block0;
                }
            }
        }
        while (!swaps.empty()) {
            int i = swaps.pop();
            if (i <= 8) {
                if (AutoToolsConfig.KEEPSLOT && i != inventory.getSelectedSlot()) {
                    client.gameMode.handleInventoryMouseClick(client.player.inventoryMenu.containerId, inventory.getSelectedSlot(), i, ClickType.SWAP, (Player)client.player);
                    return;
                }
                inventory.setSelectedSlot(i);
                return;
            }
            client.gameMode.handleInventoryMouseClick(client.player.inventoryMenu.containerId, i, inventory.getSelectedSlot(), ClickType.SWAP, (Player)client.player);
        }
        inventory.setChanged();
    }

    public static ItemMiningSpeed getMiningSpeed(ItemStack stack, BlockState blockState, BlockPos pos, Player player, Level level) {
        float modifier = 1.0f;
        int priority = 0;
        float miningSpeed = stack.getDestroySpeed(blockState);
        if (miningSpeed > 1.0f) {
            miningSpeed += (float)player.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed((LivingEntity)player)) {
            miningSpeed *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.hasEffect(MobEffects.MINING_FATIGUE)) {
            miningSpeed *= (switch (player.getEffect(MobEffects.MINING_FATIGUE).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        miningSpeed *= (float)player.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (player.isEyeInFluid(FluidTags.WATER)) {
            miningSpeed *= (float)player.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        HolderLookup.RegistryLookup EnchantmentsLookup = (HolderLookup.RegistryLookup)level.registryAccess().lookup(Registries.ENCHANTMENT).get();
        if (stack.isEnchanted()) {
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)EnchantmentsLookup.get(Enchantments.SILK_TOUCH).get()), (ItemStack)stack) == 1) {
                if (ClientTags.isInWithLocalFallback(SILK_TOUCH, blockState.getBlock()) || AutoToolsConfig.PREFER_SILK_TOUCH == AutoToolsConfig.PreferSilkTouch.always && ClientTags.isInWithLocalFallback(SILK_TOUCH_SETTING_ALWAYS, blockState.getBlock()) || AutoToolsConfig.PREFER_SILK_TOUCH == AutoToolsConfig.PreferSilkTouch.except_ores && ClientTags.isInWithLocalFallback(SILK_TOUCH_SETTING_ALWAYS_EXC_ORES, blockState.getBlock()) || AutoToolsConfig.PREFER_SILK_TOUCH == AutoToolsConfig.PreferSilkTouch.ores && ClientTags.isInWithLocalFallback(SILK_TOUCH_SETTING_ALWAYS_ORES, blockState.getBlock())) {
                    priority = 6;
                }
            } else if (EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)EnchantmentsLookup.get(Enchantments.FORTUNE).get()), (ItemStack)stack) >= 1 && (ClientTags.isInWithLocalFallback(FORTUNE, blockState.getBlock()) || AutoToolsConfig.ALWAYS_PREFER_FORTUNE && ClientTags.isInWithLocalFallback(FORTUNE_SETTING, blockState.getBlock()))) {
                priority += EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)EnchantmentsLookup.get(Enchantments.FORTUNE).get()), (ItemStack)stack);
            }
            if (ClientTags.isInWithLocalFallback(FORTUNE, blockState.getBlock()) && ClientTags.isInWithLocalFallback(DO_NOT_SWAP_UNLESS_ENCH, blockState.getBlock()) && stack.getItem() instanceof HoeItem) {
                ++priority;
            }
        }
        if (blockState.getDestroySpeed(null, pos) != 0.0f && miningSpeed > 1.0f) {
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)EnchantmentsLookup.get(Enchantments.SILK_TOUCH).get()), (ItemStack)stack) == 0 && !ClientTags.isInWithLocalFallback(SILK_TOUCH, blockState.getBlock()) && (ClientTags.isInWithLocalFallback(SILK_TOUCH_SETTING_ALWAYS_EXC_ORES, blockState.getBlock()) && AutoToolsConfig.PREFER_SILK_TOUCH != AutoToolsConfig.PreferSilkTouch.except_ores || ClientTags.isInWithLocalFallback(SILK_TOUCH_SETTING_ALWAYS_ORES, blockState.getBlock()) && AutoToolsConfig.PREFER_SILK_TOUCH != AutoToolsConfig.PreferSilkTouch.ores || ClientTags.isInWithLocalFallback(SILK_TOUCH_SETTING_ALWAYS, blockState.getBlock()) && AutoToolsConfig.PREFER_SILK_TOUCH != AutoToolsConfig.PreferSilkTouch.always)) {
                ++priority;
            }
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)EnchantmentsLookup.get(Enchantments.FORTUNE).get()), (ItemStack)stack) == 0 && !ClientTags.isInWithLocalFallback(FORTUNE, blockState.getBlock()) && ClientTags.isInWithLocalFallback(FORTUNE_SETTING, blockState.getBlock()) && !AutoToolsConfig.ALWAYS_PREFER_FORTUNE) {
                ++priority;
            }
        }
        if (stack.is(Items.SHEARS) && ClientTags.isInWithLocalFallback(SHEARS, blockState.getBlock())) {
            priority += 6;
        }
        return new ItemMiningSpeed(Float.valueOf(miningSpeed * modifier), priority);
    }

    public static int findSlotMatchingItem(Inventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.getContainerSize() - Inventory.EQUIPMENT_SLOT_MAPPING.size(); ++i) {
            if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)inventory.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean checkDurability(ItemStack stack) {
        double durability;
        return !(AutoToolsConfig.MIN_DURABILITY < 1.0 ? (durability = (double)(stack.getMaxDamage() - stack.getDamageValue()) / (double)stack.getMaxDamage()) < AutoToolsConfig.MIN_DURABILITY : (double)(stack.getMaxDamage() - stack.getDamageValue()) <= AutoToolsConfig.MIN_DURABILITY);
    }

    public static void getCorrectTool(HitResult hit, Minecraft client) {
        Inventory inventory = client.player.getInventory();
        if (AutoToolsConfig.IGNORED_SLOTS.contains(inventory.getSelectedSlot())) {
            return;
        }
        ItemStack stack = inventory.getSelectedItem();
        if (AutoToolsConfig.ENABLED == AutoToolsConfig.Enabled.tool && !stack.getComponents().has(DataComponents.TOOL)) {
            return;
        }
        if (AutoToolsConfig.ENABLED == AutoToolsConfig.Enabled.no_tool && stack.getComponents().has(DataComponents.TOOL)) {
            return;
        }
        if (hit.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hit;
            BlockState blockState = client.level.getBlockState(blockHitResult.getBlockPos());
            int toolSlot = -1;
            ItemMiningSpeed miningSpeed = new ItemMiningSpeed(Float.valueOf(1.0f), 0);
            if (CUSTOM_TOOLS.containsKey(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))) {
                List<ResourceLocation> tools = CUSTOM_TOOLS.get(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()));
                for (ResourceLocation resourceLocation : tools) {
                    if (Objects.equals(resourceLocation, ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"disabled"))) {
                        return;
                    }
                    Optional itemReference = BuiltInRegistries.ITEM.get(resourceLocation);
                    if (!itemReference.isPresent() || (toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((Holder)itemReference.get()))) == -1) continue;
                    break;
                }
                if (toolSlot != -1) {
                    AutoTools.selectItem(client, inventory, toolSlot);
                    return;
                }
            }
            if (!AutoToolsConfig.TOGGLE && blockState.getBlock() == Blocks.END_PORTAL_FRAME && (toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((ItemLike)Items.ENDER_EYE))) != -1) {
                if (toolSlot <= 8) {
                    inventory.setSelectedSlot(toolSlot);
                    return;
                }
                AutoTools.selectItem(client, inventory, toolSlot);
                return;
            }
            if (blockState.getDestroySpeed(null, blockHitResult.getBlockPos()) == 0.0f && !ClientTags.isInWithLocalFallback(DO_NOT_SWAP_UNLESS_ENCH, blockState.getBlock())) {
                return;
            }
            if (AutoToolsConfig.ONLY_SWITCH_IF_NECESSARY && (inventory.getItem(inventory.getSelectedSlot()).getItem().isCorrectToolForDrops(inventory.getItem(inventory.getSelectedSlot()), blockState) || !blockState.requiresCorrectToolForDrops())) {
                return;
            }
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                Item item = inventory.getItem(i).getItem();
                if (item == Items.AIR) continue;
                ItemMiningSpeed newMiningSpeed = new ItemMiningSpeed(Float.valueOf(1.0f), 0);
                if (item.isCorrectToolForDrops(inventory.getItem(i), blockState) || !blockState.requiresCorrectToolForDrops()) {
                    if (!AutoTools.checkDurability(inventory.getItem(i))) continue;
                    newMiningSpeed = AutoTools.getMiningSpeed(inventory.getItem(i), blockState, blockHitResult.getBlockPos(), inventory.player, (Level)client.level);
                }
                if (newMiningSpeed.equals(miningSpeed)) {
                    if (toolSlot == -1) continue;
                    if (AutoToolsConfig.PREFER_HOTBAR_TOOL) {
                        if (i > 8 || toolSlot <= 8 && i != inventory.getSelectedSlot() && (!AutoToolsConfig.PREFER_LOW_DURABILITY || inventory.getItem(i).getDamageValue() <= inventory.getItem(toolSlot).getDamageValue()) && (AutoToolsConfig.PREFER_LOW_DURABILITY || inventory.getItem(i).getDamageValue() >= inventory.getItem(toolSlot).getDamageValue())) continue;
                        toolSlot = i;
                        miningSpeed = newMiningSpeed;
                        continue;
                    }
                    if ((!AutoToolsConfig.PREFER_LOW_DURABILITY || inventory.getItem(i).getDamageValue() <= inventory.getItem(toolSlot).getDamageValue()) && (AutoToolsConfig.PREFER_LOW_DURABILITY || inventory.getItem(i).getDamageValue() >= inventory.getItem(toolSlot).getDamageValue())) continue;
                    toolSlot = i;
                    miningSpeed = newMiningSpeed;
                    continue;
                }
                if (newMiningSpeed.priority <= miningSpeed.priority && (!(newMiningSpeed.miningSpeed.floatValue() > miningSpeed.miningSpeed.floatValue()) || newMiningSpeed.priority < miningSpeed.priority)) continue;
                toolSlot = i;
                miningSpeed = newMiningSpeed;
            }
            if (!(toolSlot == -1 || ClientTags.isInWithLocalFallback(DO_NOT_SWAP_UNLESS_ENCH, blockState.getBlock()) && miningSpeed.priority == 0)) {
                AutoTools.selectItem(client, inventory, toolSlot);
            }
        } else if (AutoToolsConfig.CHANGE_FOR_ENTITIES && hit.getType() == HitResult.Type.ENTITY) {
            if (AutoToolsConfig.SWITCH_BACK) {
                return;
            }
            Entity entity = ((EntityHitResult)hit).getEntity();
            int toolSlot = -1;
            float attackDamage = 0.0f;
            if (AutoToolsConfig.KEEP_AXE && Arrays.asList(TOOL_LISTS.get("autotools:axe")).contains(BuiltInRegistries.ITEM.getKey((Object)inventory.getSelectedItem().getItem()))) {
                return;
            }
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                Item item = inventory.getItem(i).getItem();
                if (item == Items.AIR) continue;
                double newAttackDamage = 1.0;
                if (!(entity instanceof Boat) && !(entity instanceof AbstractMinecart) && !(entity instanceof LivingEntity)) continue;
                if (CUSTOM_TOOLS.containsKey(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()))) {
                    List<ResourceLocation> tools = CUSTOM_TOOLS.get(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()));
                    for (ResourceLocation resourceLocation : tools) {
                        if (Objects.equals(resourceLocation, ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"disabled"))) {
                            return;
                        }
                        Optional itemReference = BuiltInRegistries.ITEM.get(resourceLocation);
                        if (!itemReference.isPresent() || (toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((Holder)itemReference.get()))) == -1) continue;
                        break;
                    }
                    if (toolSlot != -1) {
                        AutoTools.selectItem(client, inventory, toolSlot);
                        return;
                    }
                }
                if (!AutoTools.checkDurability(inventory.getItem(i))) continue;
                float baseAttackDamage = 0.0f;
                float baseAttackSpeed = 0.0f;
                if (inventory.getItem(i).has(DataComponents.ATTRIBUTE_MODIFIERS)) {
                    for (ItemAttributeModifiers.Entry modifier : ((ItemAttributeModifiers)inventory.getItem(i).get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers()) {
                        if (modifier.modifier().id().equals((Object)ResourceLocation.parse((String)"minecraft:base_attack_damage"))) {
                            baseAttackDamage = (float)modifier.modifier().amount();
                            continue;
                        }
                        if (!modifier.modifier().id().equals((Object)ResourceLocation.parse((String)"minecraft:base_attack_speed"))) continue;
                        baseAttackSpeed = (float)modifier.modifier().amount();
                    }
                }
                if (baseAttackDamage > 0.0f) {
                    if (inventory.getItem(i).isEnchanted()) {
                        DamageSource damageSource = client.level.damageSources().playerAttack((Player)client.player);
                        LootParams lootParams = new LootParams.Builder(null).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)i).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity()).create(LootContextParamSets.ENCHANTED_DAMAGE);
                        LootContext lootContext = new LootContext(lootParams, RandomSource.create(), (HolderGetter.Provider)client.level.registryAccess());
                        ItemEnchantments itemEnchantments = (ItemEnchantments)inventory.getItem(i).getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                            List effects = enchantment.getEffects(EnchantmentEffectComponents.DAMAGE);
                            for (ConditionalEffect effect : effects) {
                                if (!effect.matches(lootContext)) continue;
                                baseAttackDamage = ((EnchantmentValueEffect)effect.effect()).process(entry.getIntValue(), entity.getRandom(), baseAttackDamage);
                            }
                        }
                    }
                    newAttackDamage = (1.0f + baseAttackDamage) * (4.0f + baseAttackSpeed);
                }
                if (newAttackDamage > (double)attackDamage || newAttackDamage == (double)attackDamage && toolSlot != -1 && inventory.getItem(i).getDamageValue() < inventory.getItem(toolSlot).getDamageValue()) {
                    attackDamage = (float)newAttackDamage;
                    toolSlot = i;
                    continue;
                }
                if (newAttackDamage != (double)attackDamage || inventory.getItem(i).getDamageValue() <= inventory.getItem(toolSlot).getDamageValue()) continue;
                toolSlot = i;
            }
            if (toolSlot == -1) {
                if (!AutoToolsConfig.TOGGLE && client.player.isCreative()) {
                    inventory.setItem(inventory.getSuitableHotbarSlot(), new ItemStack((ItemLike)Items.NETHERITE_SWORD));
                }
            } else {
                AutoTools.selectItem(client, inventory, toolSlot);
            }
        }
    }
}

