/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.clientTags;

import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.zelythia.clientTags.ClientTagsImpl;

public final class ClientTags {
    private ClientTags() {
    }

    public static Set<ResourceLocation> getOrCreateLocalTag(TagKey<?> tagKey) {
        return ClientTagsImpl.getOrCreatePartiallySyncedTag(tagKey).completeIds();
    }

    public static <T> boolean isInWithLocalFallback(TagKey<T> tagKey, T entry) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(entry);
        return ClientTagsImpl.getRegistryEntry(tagKey, entry).map(re -> ClientTags.isInWithLocalFallback(tagKey, re)).orElse(false);
    }

    public static <T> boolean isInWithLocalFallback(TagKey<T> tagKey, Holder<T> registryEntry) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(registryEntry);
        return ClientTagsImpl.isInWithLocalFallback(tagKey, registryEntry);
    }

    public static <T> boolean isInLocal(TagKey<T> tagKey, ResourceKey<T> registryKey) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(registryKey);
        if (tagKey.registry().location().equals((Object)registryKey.registry())) {
            Set<ResourceLocation> ids = ClientTags.getOrCreateLocalTag(tagKey);
            return ids.contains(registryKey.location());
        }
        return false;
    }
}

