/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.jarjar.nio.util.Lazy;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.zelythia.AutoTools;
import net.zelythia.AutoToolsConfig;
import net.zelythia.TooltipHelper;
import net.zelythia.neoforge.AutoToolsConfigImpl;

@Mod(value="autotools")
public class AutoToolsNeoForge {
    private boolean keyPressed = false;
    public static final Lazy<KeyMapping> KEY_CHANGE_TOOL = Lazy.of(() -> new KeyMapping("key.autotools.get_tool", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 342, "key.autotools.category"));
    public static final Lazy<KeyMapping> KEY_SILKTOUCH = Lazy.of(() -> new KeyMapping("key.autotools.silktouch", InputConstants.Type.KEYSYM, 90, "key.autotools.category"));

    public AutoToolsNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::registerKeyBinding);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::ConfigLoaded);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AutoToolsConfigImpl.SPEC, "autotools.toml");
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public void clientSetup(FMLCommonSetupEvent event) {
        AutoTools.init();
    }

    public void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)KEY_CHANGE_TOOL.get());
        event.register((KeyMapping)KEY_SILKTOUCH.get());
    }

    public void ConfigLoaded(ModConfigEvent.Reloading event) {
        AutoToolsConfig.load();
    }

    @SubscribeEvent
    public void ClientTickStart(ClientTickEvent.Pre event) {
        Minecraft client = Minecraft.getInstance();
        if (AutoToolsConfig.TOGGLE) {
            if (((KeyMapping)KEY_CHANGE_TOOL.get()).consumeClick()) {
                if (!this.keyPressed) {
                    AutoTools.toggle = !AutoTools.toggle;
                    client.player.displayClientMessage((Component)(AutoTools.toggle ? Component.translatable((String)"chat.enabled_autotools") : Component.translatable((String)"chat.disabled_autotools")), false);
                    this.keyPressed = true;
                }
            } else {
                this.keyPressed = false;
            }
        } else if (((KeyMapping)KEY_CHANGE_TOOL.get()).consumeClick()) {
            AutoTools.startedMining = false;
            AutoTools.getCorrectTool(client.hitResult, client);
        }
    }

    @SubscribeEvent
    public void ClientTickEnd(ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (AutoToolsConfig.SWITCH_BACK) {
            if (client.options.keyAttack.isDown()) {
                AutoTools.startedMining = true;
            } else if (AutoToolsConfig.TOGGLE || AutoTools.startedMining) {
                AutoTools.switchBack();
            }
        }
        if (((KeyMapping)KEY_SILKTOUCH.get()).consumeClick()) {
            AutoToolsConfig.PreferSilkTouch[] values = AutoToolsConfig.PreferSilkTouch.values();
            AutoToolsConfig.PREFER_SILK_TOUCH = values[(AutoToolsConfig.PREFER_SILK_TOUCH.ordinal() + 1) % values.length];
            client.player.displayClientMessage((Component)Component.translatable((String)"chat.cycle_silktouch").append((Component)Component.translatable((String)("autotools.configuration.preferSilkTouch." + String.valueOf((Object)AutoToolsConfig.PREFER_SILK_TOUCH)))), false);
            AutoToolsConfig.save();
        }
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent event) {
        TooltipHelper.applyTooltip(event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent
    public void onJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        AutoTools.swaps.clear();
    }
}

