/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools.config.autoconfig;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.AbstractListListEntry;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.impl.ConfigEntryBuilderImpl;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemListListEntry
extends AbstractListListEntry<String, ItemCell, ItemListListEntry> {
    public ItemListListEntry(Component fieldName, List<String> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<String>> saveConsumer, Supplier<List<String>> defaultValue, Component resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, (s, itemListListEntry) -> new ItemCell(fieldName, (String)s, (ItemListListEntry)((Object)itemListListEntry)));
    }

    public ItemListListEntry self() {
        return this;
    }

    public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.lateRender(graphics, mouseX, mouseY, delta);
        for (ItemCell cell : this.cells) {
            cell.lateRender(graphics, mouseX, mouseY, delta);
        }
    }

    public void save() {
        super.save();
    }

    public static class ItemCell
    extends AbstractListListEntry.AbstractListCell<String, ItemCell, ItemListListEntry> {
        @NotNull
        private final DropdownBoxEntry<String> dropdownBoxEntry;

        public ItemCell(Component fieldName, @Nullable String value, ItemListListEntry listListEntry) {
            super((Object)value, (AbstractListListEntry)listListEntry);
            if (value == null) {
                value = "minecraft:air";
            }
            DropdownBoxEntry.SelectionTopCellElement topCellElement = DropdownMenuBuilder.TopCellElementBuilder.of((Object)value, s -> {
                if (s.startsWith("#")) {
                    if (s.indexOf(":") <= 1 || s.indexOf(":") == s.length() - 1) {
                        return null;
                    }
                    return s;
                }
                try {
                    ResourceLocation identifier = ResourceLocation.parse((String)s);
                    if (BuiltInRegistries.BLOCK.getOptional(identifier).isPresent()) {
                        return s;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
            DropdownBoxEntry.DefaultSelectionCellCreator<String> cellCreator = new DropdownBoxEntry.DefaultSelectionCellCreator<String>(this){

                public DropdownBoxEntry.SelectionCellElement<String> create(String selection) {
                    ResourceLocation resourceLocation = selection.startsWith("#") ? ResourceLocation.parse((String)"minecraft:air") : ResourceLocation.parse((String)selection);
                    final ItemStack s = new ItemStack((ItemLike)BuiltInRegistries.BLOCK.getValue(resourceLocation));
                    return new DropdownBoxEntry.DefaultSelectionCellElement<String>(this, selection, this.toTextFunction){

                        public void render(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                graphics.fill(x + 1, y + 1, x + width - 1, y + height - 1, -15132391);
                            }
                            graphics.drawString(Minecraft.getInstance().font, ((Component)this.toTextFunction.apply((String)this.r)).getVisualOrderText(), x + 6 + 18, y + 6, b ? -1 : -7829368);
                            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                            graphics.renderItem(s, x + 4, y + 2);
                        }
                    };
                }

                public int getCellHeight() {
                    return 20;
                }

                public int getCellWidth() {
                    return 146;
                }

                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * 7;
                }
            };
            this.dropdownBoxEntry = ConfigEntryBuilderImpl.create().startDropdownMenu(fieldName, topCellElement, (DropdownBoxEntry.SelectionCellCreator)cellCreator).setSelections((Iterable)BuiltInRegistries.BLOCK.stream().map(block -> BuiltInRegistries.BLOCK.getKey(block).toString()).collect(Collectors.toSet())).build();
        }

        public String getValue() {
            return (String)this.dropdownBoxEntry.getValue();
        }

        public void updateSelected(boolean isSelected) {
            this.dropdownBoxEntry.updateSelected(isSelected);
        }

        public boolean isRequiresRestart() {
            return this.dropdownBoxEntry.isRequiresRestart();
        }

        public boolean isEdited() {
            return this.dropdownBoxEntry.isEdited();
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.dropdownBoxEntry.isMouseOver(mouseX, mouseY);
        }

        public Optional<Component> getError() {
            return this.dropdownBoxEntry.getError();
        }

        public int getCellHeight() {
            return this.dropdownBoxEntry.getItemHeight();
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            this.dropdownBoxEntry.setScreen(((ItemListListEntry)this.listListEntry).getConfigScreen());
            this.dropdownBoxEntry.setParent((DynamicEntryListWidget)((ClothConfigScreen.ListWidget)((ItemListListEntry)this.listListEntry).getParent()));
            this.dropdownBoxEntry.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        }

        public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.dropdownBoxEntry.lateRender(graphics, mouseX, mouseY, delta);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.dropdownBoxEntry.mouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
            return this.dropdownBoxEntry.mouseClicked(mouseButtonEvent, bl);
        }

        public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
            return this.dropdownBoxEntry.mouseReleased(mouseButtonEvent);
        }

        public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double d, double e) {
            return this.dropdownBoxEntry.mouseDragged(mouseButtonEvent, d, e);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.dropdownBoxEntry.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent keyEvent) {
            return this.dropdownBoxEntry.keyPressed(keyEvent);
        }

        public boolean keyReleased(KeyEvent keyEvent) {
            return this.dropdownBoxEntry.keyReleased(keyEvent);
        }

        public boolean charTyped(CharacterEvent characterEvent) {
            return this.dropdownBoxEntry.charTyped(characterEvent);
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.dropdownBoxEntry.getFocused();
        }

        public boolean isFocused() {
            return this.dropdownBoxEntry.isFocused();
        }

        public void setFocused(@Nullable GuiEventListener focused) {
            super.setFocused(focused);
            this.dropdownBoxEntry.setFocused(focused);
        }

        public void setFocused(boolean focused) {
            this.dropdownBoxEntry.setFocused(focused);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.dropdownBoxEntry);
        }

        @NotNull
        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
            this.dropdownBoxEntry.updateNarration(narrationElementOutput);
        }
    }
}

