/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.gui.registry.api.GuiTransformer;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.zelythia.autotools.AutoTools;
import net.zelythia.autotools.PlatformHelper;
import net.zelythia.autotools.TooltipHelper;
import net.zelythia.autotools.config.AutoToolsConfig;
import net.zelythia.autotools.config.autoconfig.BlockList;
import net.zelythia.autotools.config.autoconfig.BlockListAnnotationProvider;
import net.zelythia.autotools.config.autoconfig.CustomToolsTransformer;

@Mod(value="autotools")
public class AutoToolsNeoForge {
    private boolean keyPressed = false;
    private static final KeyMapping.Category CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autotools", (String)"keys"));
    private static final KeyMapping KEY_AUTOTOOLS = new KeyMapping("key.autotools.get_tool", InputConstants.Type.KEYSYM, 342, CATEGORY);
    private static final KeyMapping KEY_SILKTOUCH = new KeyMapping("key.autotools.silktouch", InputConstants.Type.KEYSYM, 90, CATEGORY);

    public AutoToolsNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::registerKeyBinding);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer1, parent) -> (Screen)AutoConfig.getConfigScreen(AutoToolsConfig.class, (Screen)parent).get()));
    }

    public void clientSetup(FMLCommonSetupEvent event) {
        AutoConfig.register(AutoToolsConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(GsonConfigSerializer::new));
        AutoConfig.getConfigHolder(AutoToolsConfig.class).registerSaveListener((configHolder, autoToolsConfig) -> {
            AutoTools.reloadConfig();
            return InteractionResult.SUCCESS;
        });
        GuiRegistry registry = AutoConfig.getGuiRegistry(AutoToolsConfig.class);
        registry.registerAnnotationProvider((GuiProvider)new BlockListAnnotationProvider(), new Class[]{BlockList.class});
        registry.registerPredicateTransformer((GuiTransformer)new CustomToolsTransformer(), field -> field.getName().equals("customTools"));
        AutoTools.init();
    }

    public void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(KEY_AUTOTOOLS);
        event.register(KEY_SILKTOUCH);
    }

    @SubscribeEvent
    public void ClientTickStart(ClientTickEvent.Pre event) {
        Minecraft client = Minecraft.getInstance();
        if (AutoToolsConfig.get().toggle) {
            if (KEY_AUTOTOOLS.consumeClick()) {
                if (!this.keyPressed) {
                    AutoTools.toggle = !AutoTools.toggle;
                    client.player.displayClientMessage((Component)(AutoTools.toggle ? Component.translatable((String)"chat.enabled_autotools") : Component.translatable((String)"chat.disabled_autotools")), false);
                    this.keyPressed = true;
                }
            } else {
                this.keyPressed = false;
            }
        } else if (KEY_AUTOTOOLS.consumeClick()) {
            AutoTools.startedMining = false;
            AutoTools.getCorrectTool(client.hitResult, client);
        }
    }

    @SubscribeEvent
    public void ClientTickEnd(ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (AutoToolsConfig.get().switchBack) {
            if (client.options.keyAttack.isDown() || PlatformHelper.controllableAttackDown()) {
                AutoTools.startedMining = true;
            } else if (AutoToolsConfig.get().toggle || AutoTools.startedMining) {
                AutoTools.switchBack();
            }
        }
        if (KEY_SILKTOUCH.consumeClick()) {
            AutoToolsConfig.PreferSilkTouch[] values = AutoToolsConfig.PreferSilkTouch.values();
            AutoToolsConfig.get().preferSilkTouch = values[(AutoToolsConfig.get().preferSilkTouch.ordinal() + 1) % values.length];
            client.player.displayClientMessage((Component)Component.translatable((String)"chat.cycle_silktouch").append((Component)Component.translatable((String)("text.autoconfig.autotools.option.general.preferSilkTouch." + String.valueOf((Object)AutoToolsConfig.get().preferSilkTouch)))), false);
            AutoToolsConfig.save();
        }
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent event) {
        TooltipHelper.applyTooltip(event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent
    public void onJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        AutoTools.swaps.clear();
    }
}

