/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.zelythia.autotools.ItemMiningSpeed;
import net.zelythia.autotools.clientTags.ClientTags;
import net.zelythia.autotools.config.AutoToolsConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoTools {
    public static final String MOD_ID = "autotools";
    public static final Logger LOGGER = LogManager.getLogger((String)"AutoTools");
    public static final Set<ResourceLocation> SILK_TOUCH = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> SILK_TOUCH_SETTING_ALWAYS = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> SILK_TOUCH_SETTING_ALWAYS_ORES = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> SILK_TOUCH_SETTING_ALWAYS_EXC_ORES = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> FORTUNE = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> FORTUNE_SETTING = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> SHEARS = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> DO_NOT_SWAP_UNLESS_ENCH = new HashSet<ResourceLocation>();
    public static final HashMap<ResourceLocation, List<ResourceLocation>> CUSTOM_TOOLS = new HashMap();
    public static final Stack<Integer> swaps = new Stack();
    public static boolean toggle = true;
    public static boolean startedMining = false;
    public static boolean swapped = false;

    public static void init() {
        AutoTools.reloadConfig();
    }

    public static void reloadConfig() {
        AutoToolsConfig.BlockLists lists = AutoToolsConfig.blockLists();
        AutoTools.createLists(lists.silktouch, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"shears")), SILK_TOUCH);
        AutoTools.createLists(lists.silktouch_setting_always, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"silk_touch_setting_always")), SILK_TOUCH_SETTING_ALWAYS);
        AutoTools.createLists(lists.silktouch_setting_always_ores, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"silk_touch_setting_always_ores")), SILK_TOUCH_SETTING_ALWAYS_ORES);
        AutoTools.createLists(lists.silktouch_setting_exc_ores, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"silk_touch_setting_always_exc_ores")), SILK_TOUCH_SETTING_ALWAYS_EXC_ORES);
        AutoTools.createLists(lists.fortune, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"fortune")), FORTUNE);
        AutoTools.createLists(lists.fortune_setting, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"fortune_setting")), FORTUNE_SETTING);
        AutoTools.createLists(lists.shears, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"shears")), SHEARS);
        AutoTools.createLists(lists.do_not_swap_unless_ench, (TagKey<Block>)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"do_not_swap_unless_ench")), DO_NOT_SWAP_UNLESS_ENCH);
        AutoTools.loadCustomItems();
        CUSTOM_TOOLS.computeIfAbsent(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"bamboo"), k -> new ArrayList()).addAll(ClientTags.getOrCreateLocalTag(ItemTags.SWORDS));
    }

    private static void createLists(List<String> input, TagKey<Block> tag, Set<ResourceLocation> output) {
        output.clear();
        for (String identifier : input) {
            ResourceLocation resourceLocation;
            if (identifier.startsWith("#")) {
                resourceLocation = ResourceLocation.tryParse((String)identifier.substring(1));
                if (resourceLocation == null) continue;
                output.addAll(ClientTags.getOrCreateLocalTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)resourceLocation)));
                continue;
            }
            resourceLocation = ResourceLocation.tryParse((String)identifier);
            if (resourceLocation == null) continue;
            output.add(resourceLocation);
        }
        if (AutoToolsConfig.blockLists().enable_datapacks) {
            output.addAll(ClientTags.getOrCreateLocalTag(tag));
        }
    }

    private static void loadCustomItems() {
        CUSTOM_TOOLS.clear();
        try {
            JsonElement jsonElement = JsonParser.parseString((String)("{" + AutoToolsConfig.blockLists().customTools.stream().reduce((s, s2) -> s + ", " + s2).orElse("") + "}"));
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject jsonObject = (JsonObject)jsonElement;
            for (String key : jsonObject.keySet()) {
                ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
                if (jsonObject.get(key).isJsonArray()) {
                    JsonArray toolsArray = jsonObject.getAsJsonArray(key);
                    for (int i = 0; i < toolsArray.size(); ++i) {
                        String tool = toolsArray.get(i).getAsString();
                        if (tool.startsWith("#")) {
                            TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tool.substring(1)));
                            Set<ResourceLocation> tag = ClientTags.getOrCreateLocalTag(tagKey);
                            tools.addAll(tag);
                            continue;
                        }
                        tools.add(ResourceLocation.parse((String)tool));
                    }
                } else {
                    String tool = jsonObject.get(key).getAsString();
                    if (tool.startsWith("#")) {
                        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tool.substring(1)));
                        Set<ResourceLocation> tag = ClientTags.getOrCreateLocalTag(tagKey);
                        tools.addAll(tag);
                    } else {
                        tools.add(ResourceLocation.parse((String)tool));
                    }
                }
                if (key.startsWith("#")) {
                    TagKey blockTagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)key.substring(1)));
                    Set<ResourceLocation> tag = ClientTags.getOrCreateLocalTag(blockTagKey);
                    tag.forEach(resourceLocation -> CUSTOM_TOOLS.computeIfAbsent((ResourceLocation)resourceLocation, k -> new ArrayList()).addAll(tools));
                    continue;
                }
                CUSTOM_TOOLS.computeIfAbsent(ResourceLocation.parse((String)key), k -> new ArrayList()).addAll(tools);
            }
            LOGGER.info("Loaded custom block configs: " + String.valueOf(CUSTOM_TOOLS.keySet()));
        }
        catch (Exception e) {
            LOGGER.error("Error while parsing custom blocks", (Throwable)e);
        }
    }

    public static void onBlockBreaking(Minecraft client, HitResult hitResult) {
        if (AutoToolsConfig.get().toggle && toggle) {
            if (client.player.isCreative()) {
                if (!AutoToolsConfig.get().disableCreative) {
                    AutoTools.getCorrectTool(hitResult, client);
                }
            } else {
                AutoTools.getCorrectTool(hitResult, client);
            }
        }
    }

    public static void selectItem(Minecraft client, Inventory inventory, int sourceSlot) {
        int destSlot;
        if (sourceSlot == inventory.selected) {
            return;
        }
        if (swaps.empty()) {
            swaps.push(inventory.selected);
        }
        if (sourceSlot <= 8 && !AutoToolsConfig.get().keepSlot) {
            if ((Integer)swaps.getLast() != inventory.selected && swaps.peek() != sourceSlot) {
                swaps.push(inventory.selected);
            }
            inventory.selected = sourceSlot;
            return;
        }
        if (sourceSlot <= 8) {
            sourceSlot += 36;
        }
        int n = destSlot = AutoToolsConfig.get().keepSlot ? inventory.selected : AutoTools.getSuitableHotbarSlot(inventory);
        if (!AutoToolsConfig.get().targetSlots.contains(destSlot + 1)) {
            destSlot = AutoToolsConfig.get().targetSlots.get(0) - 1;
        }
        if (swaps.peek() != sourceSlot) {
            swaps.push(sourceSlot);
        }
        if (swaps.peek() != destSlot) {
            swaps.push(destSlot);
        }
        swapped = true;
        client.gameMode.handleInventoryMouseClick(client.player.inventoryMenu.containerId, sourceSlot, destSlot, ClickType.SWAP, (Player)client.player);
        inventory.selected = destSlot;
        inventory.setChanged();
        if (!AutoToolsConfig.get().switchBack) {
            swaps.clear();
        }
    }

    public static int getSuitableHotbarSlot(Inventory inventory) {
        int j;
        int i;
        for (i = 0; i < 9; ++i) {
            j = (inventory.selected + i) % 9;
            if (!AutoToolsConfig.get().targetSlots.contains(j + 1) || !((ItemStack)inventory.items.get(j)).isEmpty()) continue;
            return j;
        }
        for (i = 0; i < 9; ++i) {
            j = (inventory.selected + i) % 9;
            if (!AutoToolsConfig.get().targetSlots.contains(j + 1) || ((ItemStack)inventory.items.get(j)).isEnchanted()) continue;
            return j;
        }
        return inventory.selected;
    }

    public static void switchBack() {
        if (!AutoToolsConfig.get().switchBack) {
            return;
        }
        if (Minecraft.getInstance().options.keyAttack.isDown() || swaps.empty()) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client.player == null || client.gameMode == null) {
            return;
        }
        Inventory inventory = client.player.getInventory();
        boolean changed = true;
        block0: while (changed && swaps.size() > 1) {
            changed = false;
            for (int intervalSize = swaps.size() / 2; intervalSize >= 2; --intervalSize) {
                for (int topOffset = 0; topOffset <= swaps.size() / intervalSize; ++topOffset) {
                    boolean foundDuplicate = true;
                    if (swaps.size() - 1 - topOffset >= 2 * intervalSize) {
                        for (int j = topOffset; j < intervalSize + topOffset; ++j) {
                            if (swaps.elementAt(swaps.size() - j - 1) == swaps.elementAt(swaps.size() - 1 - intervalSize - j)) continue;
                            foundDuplicate = false;
                            break;
                        }
                    } else {
                        foundDuplicate = false;
                    }
                    if (!foundDuplicate) continue;
                    int initialSize = swaps.size();
                    for (int i = 0; i < intervalSize * 2; ++i) {
                        swaps.remove(initialSize - topOffset - intervalSize * 2);
                    }
                    changed = true;
                    continue block0;
                }
            }
        }
        while (!swaps.empty()) {
            int i = swaps.pop();
            if (i <= 8) {
                if (AutoToolsConfig.get().keepSlot && i != inventory.selected) {
                    client.gameMode.handleInventoryMouseClick(client.player.inventoryMenu.containerId, inventory.selected, i, ClickType.SWAP, (Player)client.player);
                    return;
                }
                inventory.selected = i;
                return;
            }
            client.gameMode.handleInventoryMouseClick(client.player.inventoryMenu.containerId, i, inventory.selected, ClickType.SWAP, (Player)client.player);
        }
        inventory.setChanged();
    }

    public static ItemMiningSpeed getMiningSpeed(ItemStack stack, BlockState blockState, BlockPos pos, Player player, Level level) {
        float modifier = 1.0f;
        int priority = 0;
        float miningSpeed = stack.getDestroySpeed(blockState);
        if (miningSpeed > 1.0f) {
            miningSpeed += (float)player.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed((LivingEntity)player)) {
            miningSpeed *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.hasEffect(MobEffects.DIG_SLOWDOWN)) {
            miningSpeed *= (switch (player.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        miningSpeed *= (float)player.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (player.isEyeInFluid(FluidTags.WATER)) {
            miningSpeed *= (float)player.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (level.registryAccess().lookup(Registries.ENCHANTMENT).isPresent()) {
            HolderLookup.RegistryLookup EnchantmentsLookup = (HolderLookup.RegistryLookup)level.registryAccess().lookup(Registries.ENCHANTMENT).get();
            Optional Enchantment_SilkTouch = EnchantmentsLookup.get(Enchantments.SILK_TOUCH);
            Optional Enchantment_Fortune = EnchantmentsLookup.get(Enchantments.FORTUNE);
            if (stack.isEnchanted()) {
                if (Enchantment_SilkTouch.isPresent() && EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)Enchantment_SilkTouch.get()), (ItemStack)stack) == 1) {
                    if (SILK_TOUCH.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.always && SILK_TOUCH_SETTING_ALWAYS.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.except_ores && SILK_TOUCH_SETTING_ALWAYS_EXC_ORES.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.ores && SILK_TOUCH_SETTING_ALWAYS_ORES.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))) {
                        priority = 6;
                    }
                } else if (Enchantment_Fortune.isPresent() && EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)Enchantment_Fortune.get()), (ItemStack)stack) >= 1) {
                    if (FORTUNE.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) || AutoToolsConfig.get().alwaysPreferFortune && FORTUNE_SETTING.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))) {
                        priority += EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)Enchantment_Fortune.get()), (ItemStack)stack);
                    }
                    if (AutoToolsConfig.get().alwaysPreferFortune && FORTUNE_SETTING.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))) {
                        priority += 6;
                    }
                }
                if (FORTUNE.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && DO_NOT_SWAP_UNLESS_ENCH.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && ClientTags.isInWithLocalFallback(ItemTags.HOES, stack.getItem())) {
                    ++priority;
                }
            }
            if (blockState.getDestroySpeed((BlockGetter)level, pos) != 0.0f && miningSpeed > 1.0f) {
                if (Enchantment_SilkTouch.isPresent() && EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)Enchantment_SilkTouch.get()), (ItemStack)stack) == 0 && !SILK_TOUCH.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && (SILK_TOUCH_SETTING_ALWAYS_EXC_ORES.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.except_ores || SILK_TOUCH_SETTING_ALWAYS_ORES.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.ores || SILK_TOUCH_SETTING_ALWAYS.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.always)) {
                    ++priority;
                }
                if (Enchantment_Fortune.isPresent() && EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)Enchantment_Fortune.get()), (ItemStack)stack) == 0 && !FORTUNE.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && FORTUNE_SETTING.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && !AutoToolsConfig.get().alwaysPreferFortune) {
                    ++priority;
                }
            }
        }
        if (stack.is(Items.SHEARS) && SHEARS.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))) {
            priority += 6;
        }
        return new ItemMiningSpeed(Float.valueOf(miningSpeed * modifier), priority);
    }

    public static int findSlotMatchingItem(Inventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.items.size(); ++i) {
            if (!ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)((ItemStack)inventory.items.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public static boolean checkDurability(ItemStack stack) {
        double durability;
        return !(AutoToolsConfig.get().minDurability < 1.0 ? (durability = (double)(stack.getMaxDamage() - stack.getDamageValue()) / (double)stack.getMaxDamage()) < AutoToolsConfig.get().minDurability : (double)(stack.getMaxDamage() - stack.getDamageValue()) <= AutoToolsConfig.get().minDurability);
    }

    public static void getCorrectTool(HitResult hit, Minecraft client) {
        Inventory inventory = client.player.getInventory();
        if (AutoToolsConfig.get().ignoredSlots.contains(inventory.selected + 1)) {
            return;
        }
        ItemStack stack = inventory.getSelected();
        if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.tool && !stack.getComponents().has(DataComponents.TOOL)) {
            return;
        }
        if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.no_tool && stack.getComponents().has(DataComponents.TOOL)) {
            return;
        }
        if (hit.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hit;
            BlockState blockState = client.level.getBlockState(blockHitResult.getBlockPos());
            int toolSlot = -1;
            ItemMiningSpeed miningSpeed = new ItemMiningSpeed(Float.valueOf(1.0f), 0);
            if (CUSTOM_TOOLS.containsKey(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))) {
                List<ResourceLocation> tools = CUSTOM_TOOLS.get(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()));
                for (ResourceLocation resourceLocation : tools) {
                    if (Objects.equals(resourceLocation, ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"disabled"))) {
                        return;
                    }
                    Item item = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
                    if (item == Items.AIR || (toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((ItemLike)item))) == -1) continue;
                    break;
                }
                if (toolSlot != -1) {
                    AutoTools.selectItem(client, inventory, toolSlot);
                    return;
                }
            }
            if (!AutoToolsConfig.get().toggle && blockState.getBlock() == Blocks.END_PORTAL_FRAME && (toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((ItemLike)Items.ENDER_EYE))) != -1) {
                if (toolSlot <= 8) {
                    inventory.selected = toolSlot;
                    return;
                }
                AutoTools.selectItem(client, inventory, toolSlot);
                return;
            }
            if (blockState.getDestroySpeed(null, blockHitResult.getBlockPos()) == 0.0f && !DO_NOT_SWAP_UNLESS_ENCH.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))) {
                return;
            }
            if (AutoToolsConfig.get().onlySwitchIfNecessary && (inventory.getItem(inventory.selected).getItem().isCorrectToolForDrops(inventory.getItem(inventory.selected), blockState) || !blockState.requiresCorrectToolForDrops())) {
                return;
            }
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                Item item = inventory.getItem(i).getItem();
                if (item == Items.AIR) continue;
                ItemMiningSpeed newMiningSpeed = new ItemMiningSpeed(Float.valueOf(1.0f), 0);
                if (item.isCorrectToolForDrops(inventory.getItem(i), blockState) || !blockState.requiresCorrectToolForDrops()) {
                    if (!AutoTools.checkDurability(inventory.getItem(i))) continue;
                    newMiningSpeed = AutoTools.getMiningSpeed(inventory.getItem(i), blockState, blockHitResult.getBlockPos(), inventory.player, (Level)client.level);
                }
                if (newMiningSpeed.equals(miningSpeed)) {
                    if (toolSlot == -1) continue;
                    if (AutoToolsConfig.get().preferHotbarTool) {
                        if (i > 8 || toolSlot <= 8 && i != inventory.selected && (!AutoToolsConfig.get().preferLowDurability || inventory.getItem(i).getDamageValue() <= inventory.getItem(toolSlot).getDamageValue()) && (AutoToolsConfig.get().preferLowDurability || inventory.getItem(i).getDamageValue() >= inventory.getItem(toolSlot).getDamageValue())) continue;
                        toolSlot = i;
                        miningSpeed = newMiningSpeed;
                        continue;
                    }
                    if ((!AutoToolsConfig.get().preferLowDurability || inventory.getItem(i).getDamageValue() <= inventory.getItem(toolSlot).getDamageValue()) && (AutoToolsConfig.get().preferLowDurability || inventory.getItem(i).getDamageValue() >= inventory.getItem(toolSlot).getDamageValue())) continue;
                    toolSlot = i;
                    miningSpeed = newMiningSpeed;
                    continue;
                }
                if (newMiningSpeed.priority <= miningSpeed.priority && (!(newMiningSpeed.miningSpeed.floatValue() > miningSpeed.miningSpeed.floatValue()) || newMiningSpeed.priority < miningSpeed.priority)) continue;
                toolSlot = i;
                miningSpeed = newMiningSpeed;
            }
            if (!(toolSlot == -1 || DO_NOT_SWAP_UNLESS_ENCH.contains(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock())) && miningSpeed.priority == 0)) {
                AutoTools.selectItem(client, inventory, toolSlot);
            }
        } else if (AutoToolsConfig.get().changeForEntities && hit.getType() == HitResult.Type.ENTITY) {
            if (AutoToolsConfig.get().switchBack) {
                return;
            }
            Entity entity = ((EntityHitResult)hit).getEntity();
            int toolSlot = -1;
            float attackDamage = 0.0f;
            if (AutoToolsConfig.get().keepAxe && ClientTags.isInWithLocalFallback(ItemTags.AXES, inventory.getSelected().getItem())) {
                return;
            }
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                Item item = inventory.getItem(i).getItem();
                if (item == Items.AIR) continue;
                double newAttackDamage = 1.0;
                if (!(entity instanceof Boat) && !(entity instanceof AbstractMinecart) && !(entity instanceof LivingEntity)) continue;
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (!item.hurtEnemy(inventory.getItem(i), livingEntity, (LivingEntity)inventory.player)) continue;
                }
                if (CUSTOM_TOOLS.containsKey(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()))) {
                    List<ResourceLocation> tools = CUSTOM_TOOLS.get(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()));
                    for (ResourceLocation resourceLocation : tools) {
                        if (Objects.equals(resourceLocation, ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"disabled"))) {
                            return;
                        }
                        Item item1 = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
                        if (item1 == Items.AIR || (toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((ItemLike)item1))) == -1) continue;
                        break;
                    }
                    if (toolSlot != -1) {
                        AutoTools.selectItem(client, inventory, toolSlot);
                        return;
                    }
                }
                if (!AutoTools.checkDurability(inventory.getItem(i))) continue;
                float baseAttackDamage = 0.0f;
                float baseAttackSpeed = 0.0f;
                if (inventory.getItem(i).has(DataComponents.ATTRIBUTE_MODIFIERS)) {
                    for (ItemAttributeModifiers.Entry modifier : ((ItemAttributeModifiers)inventory.getItem(i).get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers()) {
                        if (modifier.modifier().id().equals((Object)ResourceLocation.parse((String)"minecraft:base_attack_damage"))) {
                            baseAttackDamage = (float)modifier.modifier().amount();
                            continue;
                        }
                        if (!modifier.modifier().id().equals((Object)ResourceLocation.parse((String)"minecraft:base_attack_speed"))) continue;
                        baseAttackSpeed = (float)modifier.modifier().amount();
                    }
                }
                if (baseAttackDamage > 0.0f) {
                    if (inventory.getItem(i).isEnchanted()) {
                        DamageSource damageSource = client.level.damageSources().playerAttack((Player)client.player);
                        LootParams lootParams = new LootParams.Builder(null).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ENCHANTMENT_LEVEL, (Object)i).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity()).create(LootContextParamSets.ENCHANTED_DAMAGE);
                        LootContext lootContext = new LootContext(lootParams, RandomSource.create(), client.level.registryAccess().asGetterLookup());
                        ItemEnchantments itemEnchantments = (ItemEnchantments)inventory.getItem(i).getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                            List effects = enchantment.getEffects(EnchantmentEffectComponents.DAMAGE);
                            for (ConditionalEffect effect : effects) {
                                if (!effect.matches(lootContext)) continue;
                                baseAttackDamage = ((EnchantmentValueEffect)effect.effect()).process(entry.getIntValue(), entity.getRandom(), baseAttackDamage);
                            }
                        }
                    }
                    newAttackDamage = (1.0f + baseAttackDamage) * (4.0f + baseAttackSpeed);
                }
                if (newAttackDamage > (double)attackDamage || newAttackDamage == (double)attackDamage && toolSlot != -1 && inventory.getItem(i).getDamageValue() < inventory.getItem(toolSlot).getDamageValue()) {
                    attackDamage = (float)newAttackDamage;
                    toolSlot = i;
                    continue;
                }
                if (newAttackDamage != (double)attackDamage || inventory.getItem(i).getDamageValue() <= inventory.getItem(toolSlot).getDamageValue()) continue;
                toolSlot = i;
            }
            if (toolSlot == -1) {
                if (!AutoToolsConfig.get().toggle && client.player.isCreative()) {
                    inventory.setItem(inventory.getSuitableHotbarSlot(), new ItemStack((ItemLike)Items.NETHERITE_SWORD));
                }
            } else {
                AutoTools.selectItem(client, inventory, toolSlot);
            }
        }
    }
}

