/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.zelythia.autotools.config.AutoToolsConfig;

public class TooltipHelper {
    public static void applyTooltip(ItemStack stack, List<Component> tooltip) {
        Item item;
        if (AutoToolsConfig.get().showDPS && (item = stack.getItem()) != Items.AIR) {
            double attackDamage = 0.0;
            double attackSpeed = 0.0;
            attackDamage = stack.getDamageValue();
            for (ItemAttributeModifiers.Entry modifier : ((ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers()) {
                if (modifier.attribute().is(Attributes.ATTACK_DAMAGE)) {
                    attackDamage = modifier.modifier().amount();
                    continue;
                }
                if (!modifier.attribute().is(Attributes.ATTACK_SPEED)) continue;
                attackSpeed = modifier.modifier().amount();
            }
            if (attackDamage > 0.0) {
                attackDamage = attackSpeed > 0.0 ? (1.0 + attackDamage) * (4.0 + attackSpeed) : (attackDamage += 1.0);
            }
            double optionalAttackDamage = attackDamage;
            if (stack.isEnchanted()) {
                attackDamage += (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, null);
                if (optionalAttackDamage + (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, (EntityType)EntityType.ZOMBIE) > attackDamage) {
                    optionalAttackDamage += (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, (EntityType)EntityType.ZOMBIE);
                } else if (optionalAttackDamage + (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, (EntityType)EntityType.SPIDER) > attackDamage) {
                    optionalAttackDamage += (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, (EntityType)EntityType.SPIDER);
                } else if (optionalAttackDamage + (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, (EntityType)EntityType.GUARDIAN) > attackDamage) {
                    optionalAttackDamage += (double)EnchantmentHelper.getDamageBonus((ItemStack)stack, (EntityType)EntityType.GUARDIAN);
                }
            }
            if (attackDamage > 1.0) {
                int index = 0;
                for (int i = tooltip.size() - 1; i >= 0; --i) {
                    if (tooltip.get(i).getStyle().getColor() == null || tooltip.get(i).getStyle().getColor().getValue() != 43520) continue;
                    index = i;
                    break;
                }
                if (index < tooltip.size()) {
                    ++index;
                }
                String damage = optionalAttackDamage > attackDamage ? (double)Math.round(attackDamage * 10.0) / 10.0 + " (" + (double)Math.round(optionalAttackDamage * 10.0) / 10.0 + ")" : String.valueOf((double)Math.round(attackDamage * 10.0) / 10.0);
                tooltip.add(index, (Component)Component.literal((String)(" " + damage + " Dps")).withStyle(ChatFormatting.DARK_GREEN));
            }
        }
    }
}

