/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools.mixins;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.HitResult;
import net.zelythia.autotools.AutoTools;
import net.zelythia.autotools.config.AutoToolsConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class GameModeMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private HitResult autoTools$lastHit;
    @Unique
    SystemToast.SystemToastId autoTools$toastId = new SystemToast.SystemToastId(276L);

    @Inject(at={@At(value="HEAD")}, method={"ensureHasSentCarriedItem()V"})
    private void ensureHasSentCarriedItem(CallbackInfo ci) {
        if (this.minecraft.hitResult.equals(this.autoTools$lastHit)) {
            return;
        }
        if (this.minecraft.options.keyAttack.isDown()) {
            AutoTools.onBlockBreaking(this.minecraft, this.minecraft.hitResult);
            this.autoTools$lastHit = this.minecraft.hitResult;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"startDestroyBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z"}, cancellable=true)
    private void startDestroyBlock(BlockPos blockPos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        if (this.minecraft.player.getInventory().getSelected().getMaxDamage() > 0 && AutoToolsConfig.get().durabilityCheck && !AutoTools.checkDurability(this.minecraft.player.getInventory().getSelected())) {
            cir.setReturnValue((Object)false);
            SystemToast.addOrUpdate((ToastComponent)this.minecraft.getToasts(), (SystemToast.SystemToastId)this.autoTools$toastId, (Component)Component.literal((String)"AutoTools"), (Component)Component.translatable((String)"ui.toast.autotools.durability_warning", (Object[])new Object[]{AutoToolsConfig.get().minDurability < 1.0 ? AutoToolsConfig.get().minDurability * 100.0 + "%" : Double.valueOf(AutoToolsConfig.get().minDurability)}));
        }
        if (AutoToolsConfig.get().toggle && AutoToolsConfig.get().experimentalBreakDelay && AutoTools.swapped) {
            cir.setReturnValue((Object)false);
            AutoTools.swapped = false;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"attack(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;)V"}, cancellable=true)
    private void attack(CallbackInfo ci) {
        if (this.minecraft.player.getInventory().getSelected().getMaxDamage() > 0 && AutoToolsConfig.get().durabilityCheck && !AutoTools.checkDurability(this.minecraft.player.getInventory().getSelected())) {
            ci.cancel();
            SystemToast.addOrUpdate((ToastComponent)this.minecraft.getToasts(), (SystemToast.SystemToastId)this.autoTools$toastId, (Component)Component.literal((String)"AutoTools"), (Component)Component.translatable((String)"ui.toast.autotools.durability_warning", (Object[])new Object[]{AutoToolsConfig.get().minDurability < 1.0 ? AutoToolsConfig.get().minDurability * 100.0 + "%" : Double.valueOf(AutoToolsConfig.get().minDurability)}));
        }
    }
}

