/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.clientTags;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.zelythia.clientTags.ClientTagsLoader;

public class ClientTagsImpl {
    private static final Map<class_6862<?>, ClientTagsLoader.LoadedTag> LOCAL_TAG_HIERARCHY = new ConcurrentHashMap();

    public static <T> boolean isInWithLocalFallback(class_6862<T> tagKey, class_6880<T> registryEntry) {
        return ClientTagsImpl.isInWithLocalFallback(tagKey, registryEntry, new HashSet<class_6862<T>>());
    }

    private static <T> boolean isInWithLocalFallback(class_6862<T> tagKey, class_6880<T> registryEntry, Set<class_6862<T>> checked) {
        if (checked.contains(tagKey)) {
            return false;
        }
        checked.add(tagKey);
        Optional<class_2378<T>> maybeRegistry = ClientTagsImpl.getRegistry(tagKey);
        if (maybeRegistry.isPresent() && maybeRegistry.get().method_46733(tagKey).isPresent()) {
            return registryEntry.method_40220(tagKey);
        }
        if (registryEntry.method_40230().isEmpty()) {
            return false;
        }
        ClientTagsLoader.LoadedTag wt = ClientTagsImpl.getOrCreatePartiallySyncedTag(tagKey);
        if (wt.immediateChildIds().contains(((class_5321)registryEntry.method_40230().get()).method_29177())) {
            return true;
        }
        for (class_6862<?> key : wt.immediateChildTags()) {
            if (ClientTagsImpl.isInWithLocalFallback(key, registryEntry, checked)) {
                return true;
            }
            checked.add(key);
        }
        return false;
    }

    public static <T> Optional<? extends class_2378<T>> getRegistry(class_6862<T> tagKey) {
        Optional maybeRegistry;
        Objects.requireNonNull(tagKey);
        if (class_310.method_1551() != null && class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_30349() != null && (maybeRegistry = class_310.method_1551().field_1687.method_30349().method_46759(tagKey.comp_326())).isPresent()) {
            return maybeRegistry;
        }
        return class_7923.field_41167.method_17966(tagKey.comp_326().method_29177());
    }

    public static <T> Optional<class_6880<T>> getRegistryEntry(class_6862<T> tagKey, T entry) {
        Optional<class_2378<T>> maybeRegistry = ClientTagsImpl.getRegistry(tagKey);
        if (maybeRegistry.isEmpty() || !tagKey.method_41007(maybeRegistry.get().method_46765())) {
            return Optional.empty();
        }
        class_2378<T> registry = maybeRegistry.get();
        Optional maybeKey = registry.method_29113(entry);
        return maybeKey.map(arg_0 -> registry.method_46747(arg_0));
    }

    public static ClientTagsLoader.LoadedTag getOrCreatePartiallySyncedTag(class_6862<?> tagKey) {
        ClientTagsLoader.LoadedTag loadedTag = LOCAL_TAG_HIERARCHY.get(tagKey);
        if (loadedTag == null) {
            loadedTag = ClientTagsLoader.loadTag(tagKey);
            LOCAL_TAG_HIERARCHY.put(tagKey, loadedTag);
        }
        return loadedTag;
    }
}

