/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.zelythia.config.AutoToolsConfig;

public class TooltipHelper {
    public static void applyTooltip(ItemStack stack, List<Component> tooltip) {
        Item item;
        if (AutoToolsConfig.get().showDPS && (item = stack.getItem()) != Items.AIR) {
            float baseAttackDamage = 0.0f;
            float attackDamage = 0.0f;
            float attackSpeed = 0.0f;
            ItemAttributeModifiers modifiers = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            if (modifiers == null) {
                return;
            }
            for (ItemAttributeModifiers.Entry modifier : modifiers.modifiers()) {
                if (modifier.modifier().id().equals((Object)ResourceLocation.parse((String)"minecraft:base_attack_damage"))) {
                    baseAttackDamage = (float)modifier.modifier().amount();
                    continue;
                }
                if (!modifier.modifier().id().equals((Object)ResourceLocation.parse((String)"minecraft:base_attack_speed"))) continue;
                attackSpeed = (float)modifier.modifier().amount();
            }
            if (baseAttackDamage > 0.0f) {
                attackDamage = (1.0f + baseAttackDamage) * (4.0f + attackSpeed);
            }
            float optionalAttackDamage = baseAttackDamage;
            if (stack.isEnchanted()) {
                ItemEnchantments itemEnchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                    Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                    List effects = enchantment.getEffects(EnchantmentEffectComponents.DAMAGE);
                    for (ConditionalEffect effect : effects) {
                        optionalAttackDamage = ((EnchantmentValueEffect)effect.effect()).process(entry.getIntValue(), RandomSource.create(), optionalAttackDamage);
                    }
                }
                optionalAttackDamage = (1.0f + optionalAttackDamage) * (4.0f + attackSpeed);
            }
            if (attackDamage > 1.0f) {
                int index = 0;
                for (int i = tooltip.size() - 1; i >= 0; --i) {
                    if (tooltip.get(i).getStyle().getColor() == null || tooltip.get(i).getStyle().getColor().getValue() != 43520) continue;
                    index = i;
                    break;
                }
                if (index < tooltip.size()) {
                    ++index;
                }
                String damage = optionalAttackDamage > attackDamage ? (double)Math.round((double)attackDamage * 10.0) / 10.0 + " (" + (double)Math.round((double)optionalAttackDamage * 10.0) / 10.0 + ")" : String.valueOf((double)Math.round((double)attackDamage * 10.0) / 10.0);
                tooltip.add(index, (Component)Component.literal((String)(" " + damage + " Dps")).withStyle(ChatFormatting.DARK_GREEN));
            }
        }
    }
}

