/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.clientTags;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.zelythia.clientTags.ClientTagsLoader;

public class ClientTagsImpl {
    private static final Map<TagKey<?>, ClientTagsLoader.LoadedTag> LOCAL_TAG_HIERARCHY = new ConcurrentHashMap();

    public static <T> boolean isInWithLocalFallback(TagKey<T> tagKey, Holder<T> registryEntry) {
        return ClientTagsImpl.isInWithLocalFallback(tagKey, registryEntry, new HashSet<TagKey<T>>());
    }

    private static <T> boolean isInWithLocalFallback(TagKey<T> tagKey, Holder<T> registryEntry, Set<TagKey<T>> checked) {
        if (checked.contains(tagKey)) {
            return false;
        }
        checked.add(tagKey);
        Optional<Registry<T>> maybeRegistry = ClientTagsImpl.getRegistry(tagKey);
        if (maybeRegistry.isPresent() && maybeRegistry.get().get(tagKey).isPresent()) {
            return registryEntry.is(tagKey);
        }
        if (registryEntry.unwrapKey().isEmpty()) {
            return false;
        }
        ClientTagsLoader.LoadedTag wt = ClientTagsImpl.getOrCreatePartiallySyncedTag(tagKey);
        if (wt.immediateChildIds().contains(((ResourceKey)registryEntry.unwrapKey().get()).location())) {
            return true;
        }
        for (TagKey<?> key : wt.immediateChildTags()) {
            if (ClientTagsImpl.isInWithLocalFallback(key, registryEntry, checked)) {
                return true;
            }
            checked.add(key);
        }
        return false;
    }

    public static <T> Optional<? extends Registry<T>> getRegistry(TagKey<T> tagKey) {
        Optional maybeRegistry;
        Objects.requireNonNull(tagKey);
        if (Minecraft.getInstance() != null && Minecraft.getInstance().level != null && Minecraft.getInstance().level.registryAccess() != null && (maybeRegistry = Minecraft.getInstance().level.registryAccess().lookup(tagKey.registry())).isPresent()) {
            return maybeRegistry;
        }
        return BuiltInRegistries.REGISTRY.getOptional(tagKey.registry().location());
    }

    public static <T> Optional<Holder<T>> getRegistryEntry(TagKey<T> tagKey, T entry) {
        Optional<Registry<T>> maybeRegistry = ClientTagsImpl.getRegistry(tagKey);
        if (maybeRegistry.isEmpty() || !tagKey.isFor(maybeRegistry.get().key())) {
            return Optional.empty();
        }
        Registry<T> registry = maybeRegistry.get();
        Optional maybeKey = registry.getResourceKey(entry);
        return maybeKey.map(arg_0 -> registry.getOrThrow(arg_0));
    }

    public static ClientTagsLoader.LoadedTag getOrCreatePartiallySyncedTag(TagKey<?> tagKey) {
        ClientTagsLoader.LoadedTag loadedTag = LOCAL_TAG_HIERARCHY.get(tagKey);
        if (loadedTag == null) {
            loadedTag = ClientTagsLoader.loadTag(tagKey);
            LOCAL_TAG_HIERARCHY.put(tagKey, loadedTag);
        }
        return loadedTag;
    }
}

