/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools.forge;

import com.mojang.blaze3d.platform.InputConstants;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.gui.registry.api.GuiTransformer;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.zelythia.autotools.AutoTools;
import net.zelythia.autotools.PlatformHelper;
import net.zelythia.autotools.TooltipHelper;
import net.zelythia.autotools.config.AutoToolsConfig;
import net.zelythia.autotools.config.autoconfig.BlockList;
import net.zelythia.autotools.config.autoconfig.BlockListAnnotationProvider;
import net.zelythia.autotools.config.autoconfig.CustomToolsTransformer;
import org.jetbrains.annotations.NotNull;

@Mod(value="autotools")
public class AutoToolsForge {
    private boolean keyPressed = false;
    public static final KeyMapping KEY_CHANGE_TOOL = new KeyMapping("key.autotools.get_tool", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 342, "key.autotools.category");
    public static final KeyMapping KEY_SILKTOUCH = new KeyMapping("key.autotools.silktouch", InputConstants.Type.KEYSYM, 90, "key.autotools.category");

    public AutoToolsForge(FMLJavaModLoadingContext context) {
        context.getModEventBus().addListener(this::clientSetup);
        context.getModEventBus().addListener(this::registerKeyBinding);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> (Screen)AutoConfig.getConfigScreen(AutoToolsConfig.class, (Screen)screen).get()));
    }

    public void clientSetup(FMLCommonSetupEvent event) {
        AutoConfig.register(AutoToolsConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(GsonConfigSerializer::new));
        AutoConfig.getConfigHolder(AutoToolsConfig.class).registerSaveListener((configHolder, autoToolsConfig) -> {
            AutoTools.reloadConfig();
            return InteractionResult.SUCCESS;
        });
        GuiRegistry registry = AutoConfig.getGuiRegistry(AutoToolsConfig.class);
        registry.registerAnnotationProvider((GuiProvider)new BlockListAnnotationProvider(), new Class[]{BlockList.class});
        registry.registerPredicateTransformer((GuiTransformer)new CustomToolsTransformer(), field -> field.getName().equals("customTools"));
        AutoTools.init();
    }

    public void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(KEY_CHANGE_TOOL);
        event.register(KEY_SILKTOUCH);
    }

    @SubscribeEvent
    public void ClientTickStart(@NotNull TickEvent.ClientTickEvent.Pre event) {
        Minecraft client = Minecraft.getInstance();
        if (AutoToolsConfig.get().toggle) {
            if (KEY_CHANGE_TOOL.consumeClick()) {
                if (!this.keyPressed) {
                    AutoTools.toggle = !AutoTools.toggle;
                    client.player.sendSystemMessage((Component)(AutoTools.toggle ? Component.translatable((String)"chat.enabled_autotools") : Component.translatable((String)"chat.disabled_autotools")));
                    this.keyPressed = true;
                }
            } else {
                this.keyPressed = false;
            }
        } else if (KEY_CHANGE_TOOL.consumeClick()) {
            AutoTools.startedMining = false;
            AutoTools.getCorrectTool(client.hitResult, client);
        }
    }

    @SubscribeEvent
    public void ClientTickEnd(@NotNull TickEvent.ClientTickEvent.Post event) {
        Minecraft client = Minecraft.getInstance();
        if (AutoToolsConfig.get().switchBack) {
            if (client.options.keyAttack.isDown() || PlatformHelper.controllableAttackDown()) {
                AutoTools.startedMining = true;
            } else if (AutoToolsConfig.get().toggle || AutoTools.startedMining) {
                AutoTools.switchBack();
            }
        }
        if (KEY_SILKTOUCH.consumeClick()) {
            AutoToolsConfig.PreferSilkTouch[] values = AutoToolsConfig.PreferSilkTouch.values();
            AutoToolsConfig.get().preferSilkTouch = values[(AutoToolsConfig.get().preferSilkTouch.ordinal() + 1) % values.length];
            client.player.displayClientMessage((Component)Component.translatable((String)"chat.cycle_silktouch").append((Component)Component.translatable((String)("text.autoconfig.autotools.option.general.preferSilkTouch." + String.valueOf((Object)AutoToolsConfig.get().preferSilkTouch)))), false);
            AutoToolsConfig.save();
        }
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent event) {
        TooltipHelper.applyTooltip(event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent
    public void onJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        AutoTools.swaps.clear();
    }
}

