/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.zelythia.autotools.ItemMiningSpeed;
import net.zelythia.autotools.clientTags.ClientTags;
import net.zelythia.autotools.config.AutoToolsConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoTools {
    public static final String MOD_ID = "autotools";
    public static final Logger LOGGER = LogManager.getLogger((String)"AutoTools");
    public static final Set<ResourceLocation> SILK_TOUCH = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> SILK_TOUCH_SETTING_ALWAYS = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> SILK_TOUCH_SETTING_ALWAYS_ORES = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> SILK_TOUCH_SETTING_ALWAYS_EXC_ORES = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> FORTUNE = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> FORTUNE_SETTING = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> SHEARS = new HashSet<ResourceLocation>();
    public static final Set<ResourceLocation> DO_NOT_SWAP_UNLESS_ENCH = new HashSet<ResourceLocation>();
    public static final HashMap<ResourceLocation, List<ResourceLocation>> CUSTOM_TOOLS = new HashMap();
    public static final Stack<Integer> swaps = new Stack();
    public static boolean toggle = true;
    public static boolean startedMining = false;
    public static boolean swapped = false;

    public static void init() {
        AutoTools.reloadConfig();
    }

    public static void reloadConfig() {
        AutoToolsConfig.BlockLists lists = AutoToolsConfig.blockLists();
        AutoTools.createLists(lists.silktouch, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "shears")), SILK_TOUCH);
        AutoTools.createLists(lists.silktouch_setting_always, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "silk_touch_setting_always")), SILK_TOUCH_SETTING_ALWAYS);
        AutoTools.createLists(lists.silktouch_setting_always_ores, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "silk_touch_setting_always_ores")), SILK_TOUCH_SETTING_ALWAYS_ORES);
        AutoTools.createLists(lists.silktouch_setting_exc_ores, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "silk_touch_setting_always_exc_ores")), SILK_TOUCH_SETTING_ALWAYS_EXC_ORES);
        AutoTools.createLists(lists.fortune, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "fortune")), FORTUNE);
        AutoTools.createLists(lists.fortune_setting, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "fortune_setting")), FORTUNE_SETTING);
        AutoTools.createLists(lists.shears, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "shears")), SHEARS);
        AutoTools.createLists(lists.do_not_swap_unless_ench, (TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(MOD_ID, "do_not_swap_unless_ench")), DO_NOT_SWAP_UNLESS_ENCH);
        AutoTools.loadCustomItems();
        CUSTOM_TOOLS.computeIfAbsent(new ResourceLocation("minecraft", "bamboo"), k -> new ArrayList()).addAll(ClientTags.getOrCreateLocalTag(ItemTags.f_271388_));
    }

    private static void createLists(List<String> input, TagKey<Block> tag, Set<ResourceLocation> output) {
        output.clear();
        for (String identifier : input) {
            ResourceLocation resourceLocation;
            if (identifier.startsWith("#")) {
                resourceLocation = ResourceLocation.m_135820_((String)identifier.substring(1));
                if (resourceLocation == null) continue;
                output.addAll(ClientTags.getOrCreateLocalTag(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)resourceLocation)));
                continue;
            }
            resourceLocation = ResourceLocation.m_135820_((String)identifier);
            if (resourceLocation == null) continue;
            output.add(resourceLocation);
        }
        if (AutoToolsConfig.blockLists().enable_datapacks) {
            output.addAll(ClientTags.getOrCreateLocalTag(tag));
        }
    }

    private static void loadCustomItems() {
        CUSTOM_TOOLS.clear();
        try {
            JsonElement jsonElement = JsonParser.parseString((String)("{" + AutoToolsConfig.blockLists().customTools.stream().reduce((s, s2) -> s + ", " + s2).orElse("") + "}"));
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject jsonObject = (JsonObject)jsonElement;
            for (String key : jsonObject.keySet()) {
                ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
                if (jsonObject.get(key).isJsonArray()) {
                    JsonArray toolsArray = jsonObject.getAsJsonArray(key);
                    for (int i = 0; i < toolsArray.size(); ++i) {
                        String tool = toolsArray.get(i).getAsString();
                        if (tool.startsWith("#")) {
                            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tool.substring(1)));
                            Set<ResourceLocation> tag = ClientTags.getOrCreateLocalTag(tagKey);
                            tools.addAll(tag);
                            continue;
                        }
                        tools.add(new ResourceLocation(tool));
                    }
                } else {
                    String tool = jsonObject.get(key).getAsString();
                    if (tool.startsWith("#")) {
                        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tool.substring(1)));
                        Set<ResourceLocation> tag = ClientTags.getOrCreateLocalTag(tagKey);
                        tools.addAll(tag);
                    } else {
                        tools.add(new ResourceLocation(tool));
                    }
                }
                if (key.startsWith("#")) {
                    TagKey blockTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(key.substring(1)));
                    Set<ResourceLocation> tag = ClientTags.getOrCreateLocalTag(blockTagKey);
                    tag.forEach(resourceLocation -> CUSTOM_TOOLS.computeIfAbsent((ResourceLocation)resourceLocation, k -> new ArrayList()).addAll(tools));
                    continue;
                }
                CUSTOM_TOOLS.computeIfAbsent(new ResourceLocation(key), k -> new ArrayList()).addAll(tools);
            }
            LOGGER.info("Loaded custom block configs: " + String.valueOf(CUSTOM_TOOLS.keySet()));
        }
        catch (Exception e) {
            LOGGER.error("Error while parsing custom blocks", (Throwable)e);
        }
    }

    public static void onBlockBreaking(Minecraft client, HitResult hitResult) {
        if (AutoToolsConfig.get().toggle && toggle) {
            if (client.f_91074_.m_7500_()) {
                if (!AutoToolsConfig.get().disableCreative) {
                    AutoTools.getCorrectTool(hitResult, client);
                }
            } else {
                AutoTools.getCorrectTool(hitResult, client);
            }
        }
    }

    public static void selectItem(Minecraft client, Inventory inventory, int sourceSlot) {
        int destSlot;
        if (sourceSlot == inventory.f_35977_) {
            return;
        }
        if (swaps.empty()) {
            swaps.push(inventory.f_35977_);
        }
        if (sourceSlot <= 8 && !AutoToolsConfig.get().keepSlot) {
            if ((Integer)swaps.get(swaps.size() - 1) != inventory.f_35977_ && swaps.peek() != sourceSlot) {
                swaps.push(inventory.f_35977_);
            }
            inventory.f_35977_ = sourceSlot;
            return;
        }
        if (sourceSlot <= 8) {
            sourceSlot += 36;
        }
        int n = destSlot = AutoToolsConfig.get().keepSlot ? inventory.f_35977_ : AutoTools.getSuitableHotbarSlot(inventory);
        if (!AutoToolsConfig.get().targetSlots.contains(destSlot + 1)) {
            destSlot = AutoToolsConfig.get().targetSlots.get(0) - 1;
        }
        if (swaps.peek() != sourceSlot) {
            swaps.push(sourceSlot);
        }
        if (swaps.peek() != destSlot) {
            swaps.push(destSlot);
        }
        swapped = true;
        client.f_91072_.m_171799_(client.f_91074_.f_36095_.f_38840_, sourceSlot, destSlot, ClickType.SWAP, (Player)client.f_91074_);
        inventory.f_35977_ = destSlot;
        inventory.m_6596_();
        if (!AutoToolsConfig.get().switchBack) {
            swaps.clear();
        }
    }

    public static int getSuitableHotbarSlot(Inventory inventory) {
        int j;
        int i;
        for (i = 0; i < 9; ++i) {
            j = (inventory.f_35977_ + i) % 9;
            if (!AutoToolsConfig.get().targetSlots.contains(j + 1) || !((ItemStack)inventory.f_35974_.get(j)).m_41619_()) continue;
            return j;
        }
        for (i = 0; i < 9; ++i) {
            j = (inventory.f_35977_ + i) % 9;
            if (!AutoToolsConfig.get().targetSlots.contains(j + 1) || ((ItemStack)inventory.f_35974_.get(j)).m_41793_()) continue;
            return j;
        }
        return inventory.f_35977_;
    }

    public static void switchBack() {
        if (!AutoToolsConfig.get().switchBack) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92096_.m_90857_() || swaps.empty()) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null || client.f_91072_ == null) {
            return;
        }
        Inventory inventory = client.f_91074_.m_150109_();
        boolean changed = true;
        block0: while (changed && swaps.size() > 1) {
            changed = false;
            for (int intervalSize = swaps.size() / 2; intervalSize >= 2; --intervalSize) {
                for (int topOffset = 0; topOffset <= swaps.size() / intervalSize; ++topOffset) {
                    boolean foundDuplicate = true;
                    if (swaps.size() - 1 - topOffset >= 2 * intervalSize) {
                        for (int j = topOffset; j < intervalSize + topOffset; ++j) {
                            if (swaps.elementAt(swaps.size() - j - 1) == swaps.elementAt(swaps.size() - 1 - intervalSize - j)) continue;
                            foundDuplicate = false;
                            break;
                        }
                    } else {
                        foundDuplicate = false;
                    }
                    if (!foundDuplicate) continue;
                    int initialSize = swaps.size();
                    for (int i = 0; i < intervalSize * 2; ++i) {
                        swaps.remove(initialSize - topOffset - intervalSize * 2);
                    }
                    changed = true;
                    continue block0;
                }
            }
        }
        while (!swaps.empty()) {
            int i = swaps.pop();
            if (i <= 8) {
                if (AutoToolsConfig.get().keepSlot && i != inventory.f_35977_) {
                    client.f_91072_.m_171799_(client.f_91074_.f_36095_.f_38840_, inventory.f_35977_, i, ClickType.SWAP, (Player)client.f_91074_);
                    return;
                }
                inventory.f_35977_ = i;
                return;
            }
            client.f_91072_.m_171799_(client.f_91074_.f_36095_.f_38840_, i, inventory.f_35977_, ClickType.SWAP, (Player)client.f_91074_);
        }
        inventory.m_6596_();
    }

    public static ItemMiningSpeed getMiningSpeed(ItemStack stack, BlockState blockState, BlockPos pos) {
        float modifier = 1.0f;
        int priority = 0;
        float miningSpeed = stack.m_41691_(blockState);
        if (stack.m_41793_()) {
            if (blockState.m_60800_(null, pos) != 0.0f && stack.m_41735_(blockState)) {
                modifier += (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)stack) * 20.0f / 100.0f;
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) == 1) {
                if (SILK_TOUCH.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.always && SILK_TOUCH_SETTING_ALWAYS.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.except_ores && SILK_TOUCH_SETTING_ALWAYS_EXC_ORES.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.ores && SILK_TOUCH_SETTING_ALWAYS_ORES.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()))) {
                    priority = 6;
                }
            } else if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack) >= 1) {
                if (FORTUNE.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) || AutoToolsConfig.get().alwaysPreferFortune && FORTUNE_SETTING.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()))) {
                    priority += EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
                }
                if (AutoToolsConfig.get().alwaysPreferFortune && FORTUNE_SETTING.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()))) {
                    priority += 6;
                }
            }
            if (FORTUNE.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && DO_NOT_SWAP_UNLESS_ENCH.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && ClientTags.isInWithLocalFallback(ItemTags.f_271298_, stack.m_41720_())) {
                ++priority;
            }
        }
        if (blockState.m_60800_(null, pos) != 0.0f && miningSpeed > 1.0f) {
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) == 0 && !SILK_TOUCH.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && (SILK_TOUCH_SETTING_ALWAYS_EXC_ORES.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.except_ores || SILK_TOUCH_SETTING_ALWAYS_ORES.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.ores || SILK_TOUCH_SETTING_ALWAYS.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.always)) {
                ++priority;
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack) == 0 && !FORTUNE.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && FORTUNE_SETTING.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && !AutoToolsConfig.get().alwaysPreferFortune) {
                ++priority;
            }
        }
        if (stack.m_150930_(Items.f_42574_) && SHEARS.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()))) {
            priority += 6;
        }
        return new ItemMiningSpeed(Float.valueOf(miningSpeed * modifier), priority);
    }

    public static int findSlotMatchingItem(Inventory inventory, ItemStack itemStack) {
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            if (!ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)((ItemStack)inventory.f_35974_.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public static boolean checkDurability(ItemStack stack) {
        double durability;
        return !(AutoToolsConfig.get().minDurability < 1.0 ? (durability = (double)(stack.m_41776_() - stack.m_41773_()) / (double)stack.m_41776_()) < AutoToolsConfig.get().minDurability : (double)(stack.m_41776_() - stack.m_41773_()) <= AutoToolsConfig.get().minDurability);
    }

    public static void getCorrectTool(HitResult hit, Minecraft client) {
        Inventory inventory = client.f_91074_.m_150109_();
        if (AutoToolsConfig.get().ignoredSlots.contains(inventory.f_35977_ + 1)) {
            return;
        }
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hit;
            BlockState blockState = client.f_91073_.m_8055_(blockHitResult.m_82425_());
            if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.tool && !(AutoTools.getMiningSpeed((ItemStack)inventory.m_36056_(), (BlockState)blockState, (BlockPos)blockHitResult.m_82425_()).miningSpeed.floatValue() > 1.0f) && !inventory.m_36056_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_)) {
                return;
            }
            if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.no_tool && (AutoTools.getMiningSpeed((ItemStack)inventory.m_36056_(), (BlockState)blockState, (BlockPos)blockHitResult.m_82425_()).miningSpeed.floatValue() > 1.0f || inventory.m_36056_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_))) {
                return;
            }
            int toolSlot = -1;
            ItemMiningSpeed miningSpeed = new ItemMiningSpeed(Float.valueOf(1.0f), 0);
            if (CUSTOM_TOOLS.containsKey(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()))) {
                List<ResourceLocation> tools = CUSTOM_TOOLS.get(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()));
                for (ResourceLocation resourceLocation : tools) {
                    if (Objects.equals(resourceLocation, new ResourceLocation(MOD_ID, "disabled"))) {
                        return;
                    }
                    toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(resourceLocation)));
                    if (toolSlot == -1) continue;
                    break;
                }
                if (toolSlot != -1) {
                    AutoTools.selectItem(client, inventory, toolSlot);
                    return;
                }
            }
            if (!AutoToolsConfig.get().toggle && blockState.m_60734_() == Blocks.f_50258_ && (toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((ItemLike)Items.f_42545_))) != -1) {
                if (toolSlot <= 8) {
                    inventory.f_35977_ = toolSlot;
                    return;
                }
                AutoTools.selectItem(client, inventory, toolSlot);
                return;
            }
            if (blockState.m_60800_(null, blockHitResult.m_82425_()) == 0.0f && !DO_NOT_SWAP_UNLESS_ENCH.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_()))) {
                return;
            }
            if (AutoToolsConfig.get().onlySwitchIfNecessary && (inventory.m_8020_(inventory.f_35977_).m_41735_(blockState) || !blockState.m_60834_())) {
                return;
            }
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                Item item = inventory.m_8020_(i).m_41720_();
                if (item == Items.f_41852_) continue;
                ItemMiningSpeed newMiningSpeed = new ItemMiningSpeed(Float.valueOf(1.0f), 0);
                if (item.m_8096_(blockState) || !blockState.m_60834_()) {
                    if (!AutoTools.checkDurability(inventory.m_8020_(i))) continue;
                    newMiningSpeed = AutoTools.getMiningSpeed(inventory.m_8020_(i), blockState, blockHitResult.m_82425_());
                }
                if (newMiningSpeed.equals(miningSpeed)) {
                    if (toolSlot == -1) continue;
                    if (AutoToolsConfig.get().preferHotbarTool) {
                        if (i > 8 || toolSlot <= 8 && i != inventory.f_35977_ && (!AutoToolsConfig.get().preferLowDurability || inventory.m_8020_(i).m_41773_() <= inventory.m_8020_(toolSlot).m_41773_()) && (AutoToolsConfig.get().preferLowDurability || inventory.m_8020_(i).m_41773_() >= inventory.m_8020_(toolSlot).m_41773_())) continue;
                        toolSlot = i;
                        miningSpeed = newMiningSpeed;
                        continue;
                    }
                    if ((!AutoToolsConfig.get().preferLowDurability || inventory.m_8020_(i).m_41773_() <= inventory.m_8020_(toolSlot).m_41773_()) && (AutoToolsConfig.get().preferLowDurability || inventory.m_8020_(i).m_41773_() >= inventory.m_8020_(toolSlot).m_41773_())) continue;
                    toolSlot = i;
                    miningSpeed = newMiningSpeed;
                    continue;
                }
                if (newMiningSpeed.priority <= miningSpeed.priority && (!(newMiningSpeed.miningSpeed.floatValue() > miningSpeed.miningSpeed.floatValue()) || newMiningSpeed.priority < miningSpeed.priority)) continue;
                toolSlot = i;
                miningSpeed = newMiningSpeed;
            }
            if (!(toolSlot == -1 || DO_NOT_SWAP_UNLESS_ENCH.contains(BuiltInRegistries.f_256975_.m_7981_((Object)blockState.m_60734_())) && miningSpeed.priority == 0)) {
                AutoTools.selectItem(client, inventory, toolSlot);
            }
        } else if (AutoToolsConfig.get().changeForEntities && hit.m_6662_() == HitResult.Type.ENTITY) {
            if (AutoToolsConfig.get().switchBack) {
                return;
            }
            Entity entity = ((EntityHitResult)hit).m_82443_();
            if (AutoToolsConfig.get().keepAxe && ClientTags.isInWithLocalFallback(ItemTags.f_271207_, inventory.m_36056_().m_41720_())) {
                return;
            }
            if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.tool && !inventory.m_36056_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_)) {
                return;
            }
            if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.no_tool && inventory.m_36056_().m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_)) {
                return;
            }
            int toolSlot = -1;
            float attackDamage = 0.0f;
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                Entity entity2;
                LivingEntity livingEntity;
                Item item = inventory.m_8020_(i).m_41720_();
                if (item == Items.f_41852_) continue;
                double newAttackDamage = 1.0;
                if (!(entity instanceof Boat) && !(entity instanceof AbstractMinecart) && !(entity instanceof LivingEntity)) continue;
                if (entity instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity;
                    if (!item.m_7579_(inventory.m_8020_(i), livingEntity, (LivingEntity)inventory.f_35978_)) continue;
                }
                if (CUSTOM_TOOLS.containsKey(BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()))) {
                    List<ResourceLocation> tools = CUSTOM_TOOLS.get(BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()));
                    entity2 = tools.iterator();
                    while (entity2.hasNext()) {
                        ResourceLocation resourceLocation = entity2.next();
                        if (Objects.equals(resourceLocation, new ResourceLocation(MOD_ID, "disabled"))) {
                            return;
                        }
                        toolSlot = AutoTools.findSlotMatchingItem(inventory, new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(resourceLocation)));
                        if (toolSlot == -1) continue;
                        break;
                    }
                    if (toolSlot != -1) {
                        AutoTools.selectItem(client, inventory, toolSlot);
                        return;
                    }
                }
                if (!AutoTools.checkDurability(inventory.m_8020_(i))) continue;
                if (inventory.m_8020_(i).m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_)) {
                    newAttackDamage = inventory.m_8020_(i).m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22283_) ? (1.0 + ((AttributeModifier)inventory.m_8020_(i).m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).toArray()[0]).m_22218_()) * (4.0 + ((AttributeModifier)inventory.m_8020_(i).m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).toArray()[0]).m_22218_()) : 1.0 + ((AttributeModifier)inventory.m_8020_(i).m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).toArray()[0]).m_22218_();
                }
                if (inventory.m_8020_(i).m_41793_() && (entity2 = ((EntityHitResult)hit).m_82443_()) instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity2;
                    newAttackDamage += (double)EnchantmentHelper.m_44833_((ItemStack)inventory.m_8020_(i), (MobType)livingEntity.m_6336_());
                }
                if (newAttackDamage > (double)attackDamage || newAttackDamage == (double)attackDamage && toolSlot != -1 && inventory.m_8020_(i).m_41773_() < inventory.m_8020_(toolSlot).m_41773_()) {
                    attackDamage = (float)newAttackDamage;
                    toolSlot = i;
                    continue;
                }
                if (newAttackDamage != (double)attackDamage || inventory.m_8020_(i).m_41773_() <= inventory.m_8020_(toolSlot).m_41773_()) continue;
                toolSlot = i;
            }
            if (toolSlot == -1) {
                if (!AutoToolsConfig.get().toggle && client.f_91074_.m_7500_()) {
                    inventory.m_6836_(inventory.m_36065_(), new ItemStack((ItemLike)Items.f_42393_));
                }
            } else {
                AutoTools.selectItem(client, inventory, toolSlot);
            }
        }
    }
}

