/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools.config.autoconfig;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.AbstractListListEntry;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.impl.ConfigEntryBuilderImpl;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemListListEntry
extends AbstractListListEntry<String, ItemCell, ItemListListEntry> {
    public ItemListListEntry(Component fieldName, List<String> value, boolean defaultExpanded, Supplier<Optional<Component[]>> tooltipSupplier, Consumer<List<String>> saveConsumer, Supplier<List<String>> defaultValue, Component resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, (s, itemListListEntry) -> new ItemCell(fieldName, (String)s, (ItemListListEntry)((Object)itemListListEntry)));
    }

    public ItemListListEntry self() {
        return this;
    }

    public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.lateRender(graphics, mouseX, mouseY, delta);
        for (ItemCell cell : this.cells) {
            cell.lateRender(graphics, mouseX, mouseY, delta);
        }
    }

    public void m_94757_(double d, double e) {
        super.m_94757_(d, e);
    }

    public boolean m_6050_(double d, double e, double f) {
        return this.m_94729_(d, e).filter(guiEventListener -> guiEventListener.m_6050_(d, e, f)).isPresent();
    }

    public List<? extends GuiEventListener> m_6702_() {
        return super.m_6702_();
    }

    public void save() {
        super.save();
    }

    public static class ItemCell
    extends AbstractListListEntry.AbstractListCell<String, ItemCell, ItemListListEntry> {
        @NotNull
        private final DropdownBoxEntry<String> dropdownBoxEntry;

        public ItemCell(Component fieldName, @Nullable String value, ItemListListEntry listListEntry) {
            super((Object)value, (AbstractListListEntry)listListEntry);
            if (value == null) {
                value = "minecraft:air";
            }
            DropdownBoxEntry.SelectionTopCellElement topCellElement = DropdownMenuBuilder.TopCellElementBuilder.of((Object)value, s -> {
                if (s.startsWith("#")) {
                    if (s.indexOf(":") <= 1 || s.indexOf(":") == s.length() - 1) {
                        return null;
                    }
                    return s;
                }
                try {
                    ResourceLocation identifier = new ResourceLocation(s);
                    if (BuiltInRegistries.f_256975_.m_6612_(identifier).isPresent()) {
                        return s;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
            DropdownBoxEntry.DefaultSelectionCellCreator<String> cellCreator = new DropdownBoxEntry.DefaultSelectionCellCreator<String>(){

                public DropdownBoxEntry.SelectionCellElement<String> create(String selection) {
                    ResourceLocation resourceLocation = selection.startsWith("#") ? ResourceLocation.m_135820_((String)"minecraft:air") : ResourceLocation.m_135820_((String)selection);
                    final ItemStack s = new ItemStack((ItemLike)BuiltInRegistries.f_256975_.m_7745_(resourceLocation));
                    return new DropdownBoxEntry.DefaultSelectionCellElement<String>(selection, this.toTextFunction){

                        public void render(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height, float delta) {
                            boolean b;
                            this.rendering = true;
                            this.x = x;
                            this.y = y;
                            this.width = width;
                            this.height = height;
                            boolean bl = b = mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
                            if (b) {
                                graphics.m_280509_(x + 1, y + 1, x + width - 1, y + height - 1, -15132391);
                            }
                            graphics.m_280648_(Minecraft.m_91087_().f_91062_, ((Component)this.toTextFunction.apply((String)this.r)).m_7532_(), x + 6 + 18, y + 6, b ? -1 : -7829368);
                            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                            graphics.m_280480_(s, x + 4, y + 2);
                        }
                    };
                }

                public int getCellHeight() {
                    return 20;
                }

                public int getCellWidth() {
                    return 146;
                }

                public int getDropBoxMaxHeight() {
                    return this.getCellHeight() * 7;
                }
            };
            this.dropdownBoxEntry = new FixedDropdownBoxEntry<String>(fieldName, ConfigEntryBuilderImpl.create().getResetButtonKey(), null, false, null, null, BuiltInRegistries.f_256975_.m_123024_().map(block -> BuiltInRegistries.f_256975_.m_7981_(block).toString()).collect(Collectors.toSet()), topCellElement, (DropdownBoxEntry.SelectionCellCreator)cellCreator);
        }

        public String getValue() {
            return (String)this.dropdownBoxEntry.getValue();
        }

        public void updateSelected(boolean isSelected) {
            this.dropdownBoxEntry.updateSelected(isSelected);
        }

        public boolean isRequiresRestart() {
            return this.dropdownBoxEntry.isRequiresRestart();
        }

        public boolean isEdited() {
            return this.dropdownBoxEntry.isEdited();
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return this.dropdownBoxEntry.m_5953_(mouseX, mouseY);
        }

        public Optional<Component> getError() {
            return this.dropdownBoxEntry.getError();
        }

        public int getCellHeight() {
            return this.dropdownBoxEntry.getItemHeight();
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            this.dropdownBoxEntry.setScreen(((ItemListListEntry)this.listListEntry).getConfigScreen());
            this.dropdownBoxEntry.setParent((DynamicEntryListWidget)((ClothConfigScreen.ListWidget)((ItemListListEntry)this.listListEntry).getParent()));
            this.dropdownBoxEntry.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        }

        public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.dropdownBoxEntry.lateRender(graphics, mouseX, mouseY, delta);
        }

        public void m_94757_(double mouseX, double mouseY) {
            this.dropdownBoxEntry.m_94757_(mouseX, mouseY);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.dropdownBoxEntry.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.dropdownBoxEntry.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return this.dropdownBoxEntry.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean m_6050_(double d, double e, double f) {
            return this.dropdownBoxEntry.m_6050_(d, e, f);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return this.dropdownBoxEntry.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
            return this.dropdownBoxEntry.m_7920_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char codePoint, int modifiers) {
            return this.dropdownBoxEntry.m_5534_(codePoint, modifiers);
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.dropdownBoxEntry.m_7222_();
        }

        public boolean m_93696_() {
            return this.dropdownBoxEntry.m_93696_();
        }

        public void m_7522_(@Nullable GuiEventListener focused) {
            super.m_7522_(focused);
            this.dropdownBoxEntry.m_7522_(focused);
        }

        public void m_93692_(boolean focused) {
            this.dropdownBoxEntry.m_93692_(focused);
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.dropdownBoxEntry);
        }

        @NotNull
        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            this.dropdownBoxEntry.m_142291_(narrationElementOutput);
        }
    }

    public static class FixedDropdownBoxEntry<T>
    extends DropdownBoxEntry<T> {
        public FixedDropdownBoxEntry(Component fieldName, @NotNull Component resetButtonKey, @Nullable Supplier tooltipSupplier, boolean requiresRestart, @Nullable Supplier defaultValue, @Nullable Consumer saveConsumer, @Nullable Iterable selections, @NotNull DropdownBoxEntry.SelectionTopCellElement topRenderer, @NotNull DropdownBoxEntry.SelectionCellCreator cellCreator) {
            super(fieldName, resetButtonKey, tooltipSupplier, requiresRestart, defaultValue, saveConsumer, selections, topRenderer, cellCreator);
            this.selectionElement = new FixedSelectionElement(this, new Rectangle(0, 0, 150, 20), new FixedDefaultDropdownMenuElement(selections == null ? ImmutableList.of() : ImmutableList.copyOf((Iterable)selections)), topRenderer, cellCreator);
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return this.selectionElement.m_5953_(mouseX, mouseY);
        }

        public static class FixedSelectionElement<T>
        extends DropdownBoxEntry.SelectionElement<T> {
            public FixedSelectionElement(DropdownBoxEntry<T> entry, Rectangle bounds, DropdownBoxEntry.DropdownMenuElement<T> menu, DropdownBoxEntry.SelectionTopCellElement<T> topRenderer, DropdownBoxEntry.SelectionCellCreator<T> cellCreator) {
                super(entry, bounds, menu, topRenderer, cellCreator);
            }

            public boolean m_5953_(double mouseX, double mouseY) {
                return this.bounds.contains(mouseX, mouseY) || this.menu.isExpanded() && this.menu.m_5953_(mouseX, mouseY);
            }
        }

        public static class FixedDefaultDropdownMenuElement<T>
        extends DropdownBoxEntry.DefaultDropdownMenuElement<T> {
            public FixedDefaultDropdownMenuElement(@NotNull ImmutableList<T> selections) {
                super(selections);
            }

            public void lateRender(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                int last10Height = this.getHeight();
                int cWidth = this.getCellCreator().getCellWidth();
                graphics.m_280509_(this.lastRectangle.x, this.lastRectangle.y + this.lastRectangle.height, this.lastRectangle.x + cWidth, this.lastRectangle.y + this.lastRectangle.height + last10Height + 1, this.isExpanded() ? -1 : -6250336);
                graphics.m_280509_(this.lastRectangle.x + 1, this.lastRectangle.y + this.lastRectangle.height + 1, this.lastRectangle.x + cWidth - 1, this.lastRectangle.y + this.lastRectangle.height + last10Height, -16777216);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
                ScissorsHandler.INSTANCE.scissor(new Rectangle(this.lastRectangle.x, this.lastRectangle.y + this.lastRectangle.height + 1, cWidth - 6, last10Height - 1));
                double yy = (double)(this.lastRectangle.y + this.lastRectangle.height) - this.scroll;
                for (DropdownBoxEntry.SelectionCellElement cell : this.currentElements) {
                    if (yy + (double)this.getCellCreator().getCellHeight() >= (double)(this.lastRectangle.y + this.lastRectangle.height) && yy <= (double)(this.lastRectangle.y + this.lastRectangle.height + last10Height + 1)) {
                        graphics.m_280509_(this.lastRectangle.x + 1, (int)yy, this.lastRectangle.x + this.getCellCreator().getCellWidth(), (int)yy + this.getCellCreator().getCellHeight(), -16777216);
                        cell.render(graphics, mouseX, mouseY, this.lastRectangle.x, (int)yy, this.getMaxScrollPosition() > 6.0 ? this.getCellCreator().getCellWidth() - 6 : this.getCellCreator().getCellWidth(), this.getCellCreator().getCellHeight(), delta);
                    } else {
                        cell.dontRender(graphics, delta);
                    }
                    yy += (double)this.getCellCreator().getCellHeight();
                }
                ScissorsHandler.INSTANCE.removeLastScissor();
                if (this.currentElements.isEmpty()) {
                    Font textRenderer = Minecraft.m_91087_().f_91062_;
                    MutableComponent text = Component.m_237115_((String)"text.cloth-config.dropdown.value.unknown");
                    graphics.m_280648_(textRenderer, text.m_7532_(), (int)((float)this.lastRectangle.x + (float)this.getCellCreator().getCellWidth() / 2.0f - (float)textRenderer.m_92852_((FormattedText)text) / 2.0f), this.lastRectangle.y + this.lastRectangle.height + 3, -1);
                }
                if (this.getMaxScrollPosition() > 6.0) {
                    RenderSystem.setShader(GameRenderer::m_172820_);
                    int scrollbarPositionMinX = this.lastRectangle.x + this.getCellCreator().getCellWidth() - 6;
                    int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
                    int height = (int)((double)(last10Height * last10Height) / this.getMaxScrollPosition());
                    height = Mth.m_14045_((int)height, (int)32, (int)(last10Height - 8));
                    height = (int)((double)height - Math.min(this.scroll < 0.0 ? (double)((int)(-this.scroll)) : (this.scroll > this.getMaxScrollPosition() ? (double)((int)this.scroll) - this.getMaxScrollPosition() : 0.0), (double)height * 0.95));
                    height = Math.max(10, height);
                    int minY = (int)Math.min(Math.max((double)((int)this.scroll * (last10Height - height)) / this.getMaxScrollPosition() + (double)(this.lastRectangle.y + this.lastRectangle.height + 1), (double)(this.lastRectangle.y + this.lastRectangle.height + 1)), (double)(this.lastRectangle.y + this.lastRectangle.height + 1 + last10Height - height));
                    int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
                    int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 222 : 172;
                    Tesselator tesselator = Tesselator.m_85913_();
                    BufferBuilder buffer = tesselator.m_85915_();
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                    buffer.m_5483_((double)scrollbarPositionMinX, (double)(minY + height), 0.0).m_6122_(bottomc, bottomc, bottomc, 255).m_5752_();
                    buffer.m_5483_((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).m_6122_(bottomc, bottomc, bottomc, 255).m_5752_();
                    buffer.m_5483_((double)scrollbarPositionMaxX, (double)minY, 0.0).m_6122_(bottomc, bottomc, bottomc, 255).m_5752_();
                    buffer.m_5483_((double)scrollbarPositionMinX, (double)minY, 0.0).m_6122_(bottomc, bottomc, bottomc, 255).m_5752_();
                    buffer.m_5483_((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).m_6122_(topc, topc, topc, 255).m_5752_();
                    buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).m_6122_(topc, topc, topc, 255).m_5752_();
                    buffer.m_5483_((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).m_6122_(topc, topc, topc, 255).m_5752_();
                    buffer.m_5483_((double)scrollbarPositionMinX, (double)minY, 0.0).m_6122_(topc, topc, topc, 255).m_5752_();
                    tesselator.m_85914_();
                }
                graphics.m_280168_().m_85849_();
            }
        }
    }
}

