/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools.mixins;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.HitResult;
import net.zelythia.autotools.AutoTools;
import net.zelythia.autotools.PlatformHelper;
import net.zelythia.autotools.config.AutoToolsConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class GameModeMixin {
    @Shadow
    @Final
    private Minecraft f_105189_;
    @Unique
    private HitResult autoTools$lastHit;

    @Inject(at={@At(value="HEAD")}, method={"ensureHasSentCarriedItem"})
    private void ensureHasSentCarriedItem(CallbackInfo ci) {
        if (this.f_105189_.f_91077_.equals(this.autoTools$lastHit)) {
            return;
        }
        if (this.f_105189_.f_91066_.f_92096_.m_90857_() || PlatformHelper.controllableAttackDown()) {
            AutoTools.onBlockBreaking(this.f_105189_, this.f_105189_.f_91077_);
            this.autoTools$lastHit = this.f_105189_.f_91077_;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"startDestroyBlock"}, cancellable=true)
    private void startDestroyBlock(BlockPos blockPos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        if (this.f_105189_.f_91074_.m_150109_().m_36056_().m_41776_() > 0 && AutoToolsConfig.get().durabilityCheck && !AutoTools.checkDurability(this.f_105189_.f_91074_.m_150109_().m_36056_())) {
            cir.setReturnValue((Object)false);
            SystemToast.m_94869_((ToastComponent)this.f_105189_.m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)Component.m_237113_((String)"AutoTools"), (Component)Component.m_237110_((String)"ui.toast.autotools.durability_warning", (Object[])new Object[]{AutoToolsConfig.get().minDurability < 1.0 ? AutoToolsConfig.get().minDurability * 100.0 + "%" : Double.valueOf(AutoToolsConfig.get().minDurability)}));
        }
        if (AutoToolsConfig.get().toggle && AutoToolsConfig.get().experimentalBreakDelay && AutoTools.swapped) {
            cir.setReturnValue((Object)false);
            AutoTools.swapped = false;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"}, cancellable=true)
    private void attack(CallbackInfo ci) {
        if (this.f_105189_.f_91074_.m_150109_().m_36056_().m_41776_() > 0 && AutoToolsConfig.get().durabilityCheck && !AutoTools.checkDurability(this.f_105189_.f_91074_.m_150109_().m_36056_())) {
            ci.cancel();
            SystemToast.m_94869_((ToastComponent)this.f_105189_.m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PERIODIC_NOTIFICATION, (Component)Component.m_237113_((String)"AutoTools"), (Component)Component.m_237110_((String)"ui.toast.autotools.durability_warning", (Object[])new Object[]{AutoToolsConfig.get().minDurability < 1.0 ? AutoToolsConfig.get().minDurability * 100.0 + "%" : Double.valueOf(AutoToolsConfig.get().minDurability)}));
        }
    }
}

